#include "petsc.h"
#include "petscfix.h"
#include "private/fortranimpl.h"
/* taosolver.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void*);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void*);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "taosolver.h"
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taocreate_ TAOCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taocreate_ taocreate
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taosolve_ TAOSOLVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taosolve_ taosolve
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taosetup_ TAOSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taosetup_ taosetup
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taodestroy_ TAODESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taodestroy_ taodestroy
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taosetfromoptions_ TAOSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taosetfromoptions_ taosetfromoptions
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taosettolerances_ TAOSETTOLERANCES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taosettolerances_ taosettolerances
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taosetconstrainttolerances_ TAOSETCONSTRAINTTOLERANCES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taosetconstrainttolerances_ taosetconstrainttolerances
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taosetfunctionlowerbound_ TAOSETFUNCTIONLOWERBOUND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taosetfunctionlowerbound_ taosetfunctionlowerbound
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taogetfunctionlowerbound_ TAOGETFUNCTIONLOWERBOUND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taogetfunctionlowerbound_ taogetfunctionlowerbound
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taosetmaximumfunctionevaluations_ TAOSETMAXIMUMFUNCTIONEVALUATIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taosetmaximumfunctionevaluations_ taosetmaximumfunctionevaluations
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taogetmaximumfunctionevaluations_ TAOGETMAXIMUMFUNCTIONEVALUATIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taogetmaximumfunctionevaluations_ taogetmaximumfunctionevaluations
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taosetmaximumiterations_ TAOSETMAXIMUMITERATIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taosetmaximumiterations_ taosetmaximumiterations
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taogetmaximumiterations_ TAOGETMAXIMUMITERATIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taogetmaximumiterations_ taogetmaximumiterations
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taosetinitialtrustregionradius_ TAOSETINITIALTRUSTREGIONRADIUS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taosetinitialtrustregionradius_ taosetinitialtrustregionradius
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taogetinitialtrustregionradius_ TAOGETINITIALTRUSTREGIONRADIUS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taogetinitialtrustregionradius_ taogetinitialtrustregionradius
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taogetcurrenttrustregionradius_ TAOGETCURRENTTRUSTREGIONRADIUS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taogetcurrenttrustregionradius_ taogetcurrenttrustregionradius
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taogettolerances_ TAOGETTOLERANCES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taogettolerances_ taogettolerances
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taogetksp_ TAOGETKSP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taogetksp_ taogetksp
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taogetlinesearch_ TAOGETLINESEARCH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taogetlinesearch_ taogetlinesearch
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taoaddlinesearchcounts_ TAOADDLINESEARCHCOUNTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taoaddlinesearchcounts_ taoaddlinesearchcounts
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taogetsolutionvector_ TAOGETSOLUTIONVECTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taogetsolutionvector_ taogetsolutionvector
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taogetgradientvector_ TAOGETGRADIENTVECTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taogetgradientvector_ taogetgradientvector
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taoresetstatistics_ TAORESETSTATISTICS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taoresetstatistics_ taoresetstatistics
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taocancelmonitors_ TAOCANCELMONITORS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taocancelmonitors_ taocancelmonitors
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taosetdefaultksptype_ TAOSETDEFAULTKSPTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taosetdefaultksptype_ taosetdefaultksptype
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taosetdefaultlinesearchtype_ TAOSETDEFAULTLINESEARCHTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taosetdefaultlinesearchtype_ taosetdefaultlinesearchtype
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taosetdefaultpctype_ TAOSETDEFAULTPCTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taosetdefaultpctype_ taosetdefaultpctype
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taosetterminationreason_ TAOSETTERMINATIONREASON
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taosetterminationreason_ taosetterminationreason
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taogetterminationreason_ TAOGETTERMINATIONREASON
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taogetterminationreason_ taogetterminationreason
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taogetsolutionstatus_ TAOGETSOLUTIONSTATUS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taogetsolutionstatus_ taogetsolutionstatus
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taosethistory_ TAOSETHISTORY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taosethistory_ taosethistory
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taosetapplicationcontext_ TAOSETAPPLICATIONCONTEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taosetapplicationcontext_ taosetapplicationcontext
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taogetapplicationcontext_ TAOGETAPPLICATIONCONTEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taogetapplicationcontext_ taogetapplicationcontext
#endif


/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void PETSC_STDCALL  taocreate_(MPI_Fint * comm,TaoSolver *newtao, int *__ierr ){
*__ierr = TaoCreate(
	MPI_Comm_f2c( *(comm) ),
	((newtao) ));
}
void PETSC_STDCALL  taosolve_(TaoSolver *tao, int *__ierr ){
*__ierr = TaoSolve(*tao);
}
void PETSC_STDCALL  taosetup_(TaoSolver *tao, int *__ierr ){
*__ierr = TaoSetUp(*tao);
}
void PETSC_STDCALL  taodestroy_(TaoSolver *tao, int *__ierr ){
*__ierr = TaoDestroy(
	((tao) ));
}
void PETSC_STDCALL  taosetfromoptions_(TaoSolver *tao, int *__ierr ){
*__ierr = TaoSetFromOptions(*tao);
}
void PETSC_STDCALL  taosettolerances_(TaoSolver *tao,PetscReal *fatol,PetscReal *frtol,PetscReal *gatol,PetscReal *grtol,PetscReal *gttol, int *__ierr ){
*__ierr = TaoSetTolerances(*tao,*fatol,*frtol,*gatol,*grtol,*gttol);
}
void PETSC_STDCALL  taosetconstrainttolerances_(TaoSolver *tao,PetscReal *catol,PetscReal *crtol, int *__ierr ){
*__ierr = TaoSetConstraintTolerances(*tao,*catol,*crtol);
}
void PETSC_STDCALL  taosetfunctionlowerbound_(TaoSolver *tao,PetscReal *fmin, int *__ierr ){
*__ierr = TaoSetFunctionLowerBound(*tao,*fmin);
}
void PETSC_STDCALL  taogetfunctionlowerbound_(TaoSolver *tao,PetscReal *fmin, int *__ierr ){
*__ierr = TaoGetFunctionLowerBound(*tao,fmin);
}

void PETSC_STDCALL  taosetmaximumfunctionevaluations_(TaoSolver *tao,PetscInt *nfcn, int *__ierr ){
*__ierr = TaoSetMaximumFunctionEvaluations(*tao,*nfcn);
}

void PETSC_STDCALL  taogetmaximumfunctionevaluations_(TaoSolver *tao,PetscInt *nfcn, int *__ierr ){
*__ierr = TaoGetMaximumFunctionEvaluations(*tao,nfcn);
}
void PETSC_STDCALL  taosetmaximumiterations_(TaoSolver *tao,PetscInt *maxits, int *__ierr ){
*__ierr = TaoSetMaximumIterations(*tao,*maxits);
}
void PETSC_STDCALL  taogetmaximumiterations_(TaoSolver *tao,PetscInt *maxits, int *__ierr ){
*__ierr = TaoGetMaximumIterations(*tao,maxits);
}
void PETSC_STDCALL  taosetinitialtrustregionradius_(TaoSolver *tao,PetscReal *radius, int *__ierr ){
*__ierr = TaoSetInitialTrustRegionRadius(*tao,*radius);
}
void PETSC_STDCALL  taogetinitialtrustregionradius_(TaoSolver *tao,PetscReal *radius, int *__ierr ){
*__ierr = TaoGetInitialTrustRegionRadius(*tao,radius);
}
void PETSC_STDCALL  taogetcurrenttrustregionradius_(TaoSolver *tao,PetscReal *radius, int *__ierr ){
*__ierr = TaoGetCurrentTrustRegionRadius(*tao,radius);
}
void PETSC_STDCALL  taogettolerances_(TaoSolver *tao,PetscReal *fatol,PetscReal *frtol,PetscReal *gatol,PetscReal *grtol,PetscReal *gttol, int *__ierr ){
*__ierr = TaoGetTolerances(*tao,fatol,frtol,gatol,grtol,gttol);
}
void PETSC_STDCALL  taogetksp_(TaoSolver *tao,KSP *ksp, int *__ierr ){
*__ierr = TaoGetKSP(*tao,ksp);
}
void PETSC_STDCALL  taogetlinesearch_(TaoSolver *tao,TaoLineSearch *ls, int *__ierr ){
*__ierr = TaoGetLineSearch(*tao,
	((ls) ));
}
void PETSC_STDCALL  taoaddlinesearchcounts_(TaoSolver *tao, int *__ierr ){
*__ierr = TaoAddLineSearchCounts(*tao);
}
void PETSC_STDCALL  taogetsolutionvector_(TaoSolver *tao,Vec *X, int *__ierr ){
*__ierr = TaoGetSolutionVector(*tao,X);
}
void PETSC_STDCALL  taogetgradientvector_(TaoSolver *tao,Vec *G, int *__ierr ){
*__ierr = TaoGetGradientVector(*tao,G);
}
void PETSC_STDCALL  taoresetstatistics_(TaoSolver *tao, int *__ierr ){
*__ierr = TaoResetStatistics(*tao);
}
void PETSC_STDCALL  taocancelmonitors_(TaoSolver *tao, int *__ierr ){
*__ierr = TaoCancelMonitors(*tao);
}
void PETSC_STDCALL  taosetdefaultksptype_(TaoSolver *tao,KSPType *ktype, int *__ierr ){
*__ierr = TaoSetDefaultKSPType(*tao,*ktype);
}
void PETSC_STDCALL  taosetdefaultlinesearchtype_(TaoSolver *tao,TaoLineSearchType *lstype, int *__ierr ){
*__ierr = TaoSetDefaultLineSearchType(*tao,*lstype);
}
void PETSC_STDCALL  taosetdefaultpctype_(TaoSolver *tao,PCType *pctype, int *__ierr ){
*__ierr = TaoSetDefaultPCType(*tao,*pctype);
}
void PETSC_STDCALL  taosetterminationreason_(TaoSolver *tao,TaoSolverTerminationReason *reason, int *__ierr ){
*__ierr = TaoSetTerminationReason(*tao,*reason);
}
void PETSC_STDCALL  taogetterminationreason_(TaoSolver *tao,TaoSolverTerminationReason *reason, int *__ierr ){
*__ierr = TaoGetTerminationReason(*tao,
	((reason) ));
}
void PETSC_STDCALL  taogetsolutionstatus_(TaoSolver *tao,PetscInt *its,PetscReal *f,PetscReal *gnorm,PetscReal *cnorm,PetscReal *xdiff,TaoSolverTerminationReason *reason, int *__ierr ){
*__ierr = TaoGetSolutionStatus(*tao,its,f,gnorm,cnorm,xdiff,
	((reason) ));
}
void PETSC_STDCALL  taosethistory_(TaoSolver *tao,PetscReal *obj,PetscReal *resid,PetscReal *cnorm,PetscInt *na,PetscBool *reset, int *__ierr ){
*__ierr = TaoSetHistory(*tao,obj,resid,cnorm,*na,*reset);
}
void PETSC_STDCALL  taosetapplicationcontext_(TaoSolver *tao,void*usrP, int *__ierr ){
*__ierr = TaoSetApplicationContext(*tao,usrP);
}
void PETSC_STDCALL  taogetapplicationcontext_(TaoSolver *tao,void*usrP, int *__ierr ){
*__ierr = TaoGetApplicationContext(*tao,usrP);
}
#if defined(__cplusplus)
}
#endif
