#include "petsc.h"
#include "petscfix.h"
#include "private/fortranimpl.h"
/* isutil.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void*);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void*);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "tao.h"
#include "tao_util.h"
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecwhichequal_ VECWHICHEQUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecwhichequal_ vecwhichequal
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecwhichlessthan_ VECWHICHLESSTHAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecwhichlessthan_ vecwhichlessthan
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecwhichgreaterthan_ VECWHICHGREATERTHAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecwhichgreaterthan_ vecwhichgreaterthan
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecwhichbetween_ VECWHICHBETWEEN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecwhichbetween_ vecwhichbetween
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecwhichbetweenorequal_ VECWHICHBETWEENOREQUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecwhichbetweenorequal_ vecwhichbetweenorequal
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecgetsubvec_ VECGETSUBVEC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecgetsubvec_ vecgetsubvec
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecreducedxpy_ VECREDUCEDXPY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecreducedxpy_ vecreducedxpy
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define iscreatecomplement_ ISCREATECOMPLEMENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define iscreatecomplement_ iscreatecomplement
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecissettoconstant_ VECISSETTOCONSTANT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecissettoconstant_ vecissettoconstant
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matgetsubmat_ MATGETSUBMAT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matgetsubmat_ matgetsubmat
#endif


/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void PETSC_STDCALL  vecwhichequal_(Vec Vec1,Vec Vec2,IS * S, int *__ierr ){
*__ierr = VecWhichEqual(
	(Vec)PetscToPointer((Vec1) ),
	(Vec)PetscToPointer((Vec2) ),S);
}
void PETSC_STDCALL  vecwhichlessthan_(Vec Vec1,Vec Vec2,IS * S, int *__ierr ){
*__ierr = VecWhichLessThan(
	(Vec)PetscToPointer((Vec1) ),
	(Vec)PetscToPointer((Vec2) ),S);
}
void PETSC_STDCALL  vecwhichgreaterthan_(Vec Vec1,Vec Vec2,IS * S, int *__ierr ){
*__ierr = VecWhichGreaterThan(
	(Vec)PetscToPointer((Vec1) ),
	(Vec)PetscToPointer((Vec2) ),S);
}
void PETSC_STDCALL  vecwhichbetween_(Vec VecLow,Vec V,Vec VecHigh,IS *S, int *__ierr ){
*__ierr = VecWhichBetween(
	(Vec)PetscToPointer((VecLow) ),
	(Vec)PetscToPointer((V) ),
	(Vec)PetscToPointer((VecHigh) ),S);
}

void PETSC_STDCALL  vecwhichbetweenorequal_(Vec VecLow,Vec V,Vec VecHigh,IS * S, int *__ierr ){
*__ierr = VecWhichBetweenOrEqual(
	(Vec)PetscToPointer((VecLow) ),
	(Vec)PetscToPointer((V) ),
	(Vec)PetscToPointer((VecHigh) ),S);
}
void PETSC_STDCALL  vecgetsubvec_(Vec vfull,IS is,PetscInt *reduced_type,PetscReal *maskvalue,Vec *vreduced, int *__ierr ){
*__ierr = VecGetSubVec(
	(Vec)PetscToPointer((vfull) ),
	(IS)PetscToPointer((is) ),*reduced_type,*maskvalue,vreduced);
}
void PETSC_STDCALL  vecreducedxpy_(Vec vfull,Vec vreduced,IS is, int *__ierr ){
*__ierr = VecReducedXPY(
	(Vec)PetscToPointer((vfull) ),
	(Vec)PetscToPointer((vreduced) ),
	(IS)PetscToPointer((is) ));
}
void PETSC_STDCALL  iscreatecomplement_(IS S,Vec V,IS *T, int *__ierr ){
*__ierr = ISCreateComplement(
	(IS)PetscToPointer((S) ),
	(Vec)PetscToPointer((V) ),T);
}
void PETSC_STDCALL  vecissettoconstant_(IS S,PetscReal *c,Vec V, int *__ierr ){
*__ierr = VecISSetToConstant(
	(IS)PetscToPointer((S) ),*c,
	(Vec)PetscToPointer((V) ));
}
void PETSC_STDCALL  matgetsubmat_(Mat M,IS is,Vec v1,TaoSubsetType *subset_type,Mat *Msub, int *__ierr ){
*__ierr = MatGetSubMat(
	(Mat)PetscToPointer((M) ),
	(IS)PetscToPointer((is) ),
	(Vec)PetscToPointer((v1) ),*subset_type,Msub);
}
#if defined(__cplusplus)
}
#endif
