#ifndef __TAOLINESEARCH_H
#define __TAOLINESEARCH_H
#include "petscvec.h"

PETSC_EXTERN_CXX_BEGIN
typedef struct _p_TaoLineSearch* TaoLineSearch;
typedef enum {
    TAOLINESEARCH_FAILED_INFORNAN = -1,
    TAOLINESEARCH_FAILED_BADPARAMETER = -2,
    TAOLINESEARCH_FAILED_ASCENT = -3,
    TAOLINESEARCH_CONTINUE_ITERATING = 0,
    TAOLINESEARCH_SUCCESS = 1,
    TAOLINESEARCH_SUCCESS_USER = 2,
    TAOLINESEARCH_HALTED_OTHER = 3,
    TAOLINESEARCH_HALTED_MAXFCN = 4,
    TAOLINESEARCH_HALTED_UPPERBOUND = 5,
    TAOLINESEARCH_HALTED_LOWERBOUND = 6,
    TAOLINESEARCH_HALTED_RTOL = 7,
    TAOLINESEARCH_HALTED_USER = 8
} TaoLineSearchTerminationReason;
	      

#define TaoLineSearchType  char*
#define TAOLINESEARCH_UNIT "unit"
#define TAOLINESEARCH_MT "more-thuente"
#define TAOLINESEARCH_GPCG "gpcg"
#define TAOLINESEARCH_ARMIJO "armijo"

extern PetscClassId TAOLINESEARCH_CLASSID;

PETSC_EXTERN_CXX_END

#include "taosolver.h"

PETSC_EXTERN_CXX_BEGIN

extern PetscErrorCode TaoLineSearchCreate(MPI_Comm,TaoLineSearch*);
extern PetscErrorCode TaoLineSearchSetFromOptions(TaoLineSearch);
extern PetscErrorCode TaoLineSearchSetUp(TaoLineSearch);
extern PetscErrorCode TaoLineSearchDestroy(TaoLineSearch*);
extern PetscErrorCode TaoLineSearchView(TaoLineSearch,PetscViewer);
extern PetscErrorCode TaoLineSearchSetOptionsPrefix(TaoLineSearch,const char prefix[]);
extern PetscErrorCode TaoLineSearchReset(TaoLineSearch);
extern PetscErrorCode TaoLineSearchAppendOptionsPrefix(TaoLineSearch,const char prefix[]);
extern PetscErrorCode TaoLineSearchGetOptionsPrefix(TaoLineSearch,const char *prefix[]);
extern PetscErrorCode TaoLineSearchApply(TaoLineSearch,Vec,PetscReal *,Vec,Vec, PetscReal *, TaoLineSearchTerminationReason *);
extern PetscErrorCode TaoLineSearchGetStepLength(TaoLineSearch, PetscReal*);
extern PetscErrorCode TaoLineSearchGetStartingVector(TaoLineSearch,Vec*);
extern PetscErrorCode TaoLineSearchGetStepDirection(TaoLineSearch,Vec*);
extern PetscErrorCode TaoLineSearchSetInitialStepLength(TaoLineSearch, PetscReal);
extern PetscErrorCode TaoLineSearchGetSolution(TaoLineSearch, Vec, PetscReal*, Vec, PetscReal*, TaoLineSearchTerminationReason*);
extern PetscErrorCode TaoLineSearchGetFullStepObjective(TaoLineSearch, PetscReal*);
extern PetscErrorCode TaoLineSearchGetNumberFunctionEvaluations(TaoLineSearch, PetscInt*, PetscInt*, PetscInt*);

extern PetscErrorCode TaoLineSearchGetType(TaoLineSearch, const TaoLineSearchType *);
extern PetscErrorCode TaoLineSearchSetType(TaoLineSearch, const TaoLineSearchType);

extern PetscErrorCode TaoLineSearchUseTaoSolverRoutines(TaoLineSearch, TaoSolver);
extern PetscErrorCode TaoLineSearchIsUsingTaoSolverRoutines(TaoLineSearch, PetscBool *);
extern PetscErrorCode TaoLineSearchSetObjectiveAndGTSRoutine(TaoLineSearch, PetscErrorCode(*)(TaoLineSearch, Vec, Vec, PetscReal*, PetscReal*, void*), void*);
extern PetscErrorCode TaoLineSearchSetObjectiveRoutine(TaoLineSearch, PetscErrorCode(*)(TaoLineSearch, Vec, PetscReal*,void*), void*);
extern PetscErrorCode TaoLineSearchSetGradientRoutine(TaoLineSearch, PetscErrorCode(*)(TaoLineSearch, Vec, Vec, void*), void*);
extern PetscErrorCode TaoLineSearchSetObjectiveAndGradientRoutine(TaoLineSearch, PetscErrorCode(*)(TaoLineSearch, Vec, PetscReal*, Vec, void*), void*);

extern PetscErrorCode TaoLineSearchComputeObjective(TaoLineSearch, Vec, PetscReal*);
extern PetscErrorCode TaoLineSearchComputeGradient(TaoLineSearch, Vec, Vec);
extern PetscErrorCode TaoLineSearchComputeObjectiveAndGradient(TaoLineSearch, Vec, PetscReal*, Vec);
extern PetscErrorCode TaoLineSearchComputeObjectiveAndGTS(TaoLineSearch, Vec, PetscReal*, PetscReal*);
extern PetscErrorCode TaoLineSearchSetVariableBounds(TaoLineSearch, Vec, Vec);

extern PetscErrorCode TaoLineSearchInitializePackage(const char path[]); 

extern PetscErrorCode TaoLineSearchRegister(const char[], const char[], const char[], PetscErrorCode (*)(TaoLineSearch));

PETSC_EXTERN_CXX_END
#endif
