function ISSM_TIER=issmtier()
%ISSMTIER - Get ISSM_TIER environment variable contents.
%
%   Usage:
%      ISSM_TIER=issmtier()

if ~ispc, 
	ISSM_TIER =getenv('ISSM_TIER');
else
	ISSM_TIER =getenv('ISSM_TIER_WIN');
	if strcmpi(ISSM_TIER(end),'/') | strcmpi(ISSM_TIER(end),'\'),
		ISSM_TIER = ISSM_TIER(1:end-1); %shave off the last '/'
	end
end

if (isempty(ISSM_TIER)),
	error('issmdir error message: ''ISSM_TIER'' environment variable is empty! You should define ISSM_TIER in your .cshrc or .bashrc!');
end
