/*\file CreateJacobianMatrix.c
 *\brief: build system matrices (stiffness matrix, loads vector)
 */

#include "./CreateJacobianMatrix.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Elements   *elements   = NULL;
	Nodes      *nodes      = NULL;
	Vertices   *vertices   = NULL;
	Loads      *loads      = NULL;
	Materials  *materials  = NULL;
	Parameters *parameters = NULL;
	double kmax;
	
	/* output datasets: */
	Mat    Jff  = NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&CreateJacobianMatrixUsage);

	/*Input datasets: */
	FetchMatlabData((DataSet**)&elements,ELEMENTS);
	FetchMatlabData((DataSet**)&nodes,NODES);
	FetchMatlabData((DataSet**)&vertices,VERTICES);
	FetchMatlabData((DataSet**)&loads,LOADS);
	FetchMatlabData((DataSet**)&materials,MATERIALS);
	FetchMatlabData(&parameters,PARAMETERS);
	FetchMatlabData(&kmax,KMAX);

	/*configure: */
	elements->  Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->     Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->     Configure(elements, loads, nodes,vertices, materials,parameters);
	materials-> Configure(elements, loads, nodes,vertices, materials,parameters);

	/*!Generate internal degree of freedom numbers: */
	CreateJacobianMatrixx(&Jff,elements,nodes,vertices,loads,materials,parameters,kmax);

	/*write output datasets: */
	WriteMatlabData(JFF,Jff);
	
	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;
	MatFree(&Jff);

	/*end module: */
	MODULEEND();
}

void CreateJacobianMatrixUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [Jff] = %s(elements,nodes,vertices,loads,materials,parameters,kmax);\n",__FUNCT__);
	_printf_(true,"\n");
}
