/*!\file: enthalpy_core.cpp
 * \brief: core of the enthalpy solution 
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../include/include.h"
#include "../io/io.h"
#include "../solvers/solvers.h"

void enthalpy_core(FemModel* femmodel){

	int i;

	/*intermediary*/
	double time;
	int    nsteps;
	double final_time;
	double dt;
	double melting_offset;
	bool control_analysis;
	int solution_type;

	//first recover parameters common to all solutions
	femmodel->parameters->FindParam(&final_time,TimesteppingFinalTimeEnum);
	femmodel->parameters->FindParam(&dt,TimesteppingTimeStepEnum);
	femmodel->parameters->FindParam(&control_analysis,InversionIscontrolEnum);
	femmodel->parameters->FindParam(&solution_type,SolutionTypeEnum);

	/*Compute number of time steps: */
	if((dt==0)|| (final_time==0)){
		dt=0;
		nsteps=1;
	}
	else nsteps=(int)(final_time/dt);

	/*Loop through time: */
	for(i=0;i<nsteps;i++){
		
		if(nsteps)_printf_(VerboseSolution(),"time step: %i/%i\n",i+1,nsteps);
		time=(i+1)*dt;

		/*call enthalpy_core_step: */
		enthalpy_core_step(femmodel,i,time);

		if(solution_type==EnthalpySolutionEnum && !control_analysis){
			_printf_(VerboseSolution(),"   saving results\n");
			InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,TemperatureEnum,i+1,time);
			InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,EnthalpyEnum,i+1,time);
			InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,WaterfractionEnum,i+1,time);
		}

	}
}
