/*!\file:  AnalysisConfiguration.cpp
 * \brief: return type of analyses, number of analyses 
 */ 

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../include/include.h"
#include "../solvers/solvers.h"

void AnalysisConfiguration(int** panalyses,int* pnumanalyses, int solutiontype){

	/*output: */
	int  numanalyses;
	int* analyses=NULL;

	/*Analyses lists*/
	switch(solutiontype){
	
		case DiagnosticSolutionEnum:
			numanalyses=5;
			analyses=(int*)xmalloc(numanalyses*sizeof(int));
			analyses[0]=DiagnosticHorizAnalysisEnum;
			analyses[1]=DiagnosticVertAnalysisEnum;
			analyses[2]=DiagnosticHutterAnalysisEnum;
			analyses[3]=SurfaceSlopeAnalysisEnum;
			analyses[4]=BedSlopeAnalysisEnum;
			break;

		case SteadystateSolutionEnum:
			numanalyses=7;
			analyses=(int*)xmalloc(numanalyses*sizeof(int));
			analyses[0]=DiagnosticHorizAnalysisEnum;
			analyses[1]=DiagnosticVertAnalysisEnum;
			analyses[2]=DiagnosticHutterAnalysisEnum;
			analyses[3]=SurfaceSlopeAnalysisEnum;
			analyses[4]=BedSlopeAnalysisEnum;
			analyses[5]=ThermalAnalysisEnum;
			analyses[6]=MeltingAnalysisEnum;
			break;

		case ThermalSolutionEnum:
			numanalyses=2;
			analyses=(int*)xmalloc(numanalyses*sizeof(int));
			analyses[0]=ThermalAnalysisEnum;
			analyses[1]=MeltingAnalysisEnum;
			break;
		
		case EnthalpySolutionEnum:
			numanalyses=1;
			analyses=(int*)xmalloc(numanalyses*sizeof(int));
			analyses[0]=EnthalpyAnalysisEnum;
			break;
		
		case HydrologySolutionEnum:
			numanalyses=3;
			analyses=(int*)xmalloc(numanalyses*sizeof(int));
			analyses[0]=HydrologyAnalysisEnum;
			analyses[1]=SurfaceSlopeAnalysisEnum;
			analyses[2]=BedSlopeAnalysisEnum;
			break;

		case PrognosticSolutionEnum:
			numanalyses=1;
			analyses=(int*)xmalloc(numanalyses*sizeof(int));
			analyses[0]=PrognosticAnalysisEnum;
			break;

		case BalancethicknessSolutionEnum:
			numanalyses=1;
			analyses=(int*)xmalloc(numanalyses*sizeof(int));
			analyses[0]=BalancethicknessAnalysisEnum;
			break;

		case SurfaceSlopeSolutionEnum:
			numanalyses=1;
			analyses=(int*)xmalloc(numanalyses*sizeof(int));
			analyses[0]=SurfaceSlopeAnalysisEnum;
			break;

		case BedSlopeSolutionEnum:
			numanalyses=1;
			analyses=(int*)xmalloc(numanalyses*sizeof(int));
			analyses[0]=BedSlopeAnalysisEnum;
			break;

		case TransientSolutionEnum:
			numanalyses=9;
			analyses=(int*)xmalloc(numanalyses*sizeof(int));
			analyses[0]=DiagnosticHorizAnalysisEnum;
			analyses[1]=DiagnosticVertAnalysisEnum;
			analyses[2]=DiagnosticHutterAnalysisEnum;
			analyses[3]=SurfaceSlopeAnalysisEnum;
			analyses[4]=BedSlopeAnalysisEnum;
			analyses[5]=ThermalAnalysisEnum;
			analyses[6]=MeltingAnalysisEnum;
			analyses[7]=EnthalpyAnalysisEnum;
			analyses[8]=PrognosticAnalysisEnum;
			break;
		
		default:
			_error_("%s%s%s"," solution type: ",EnumToStringx(solutiontype)," not supported yet!");
			break;
	}

	/*Assign output pointers:*/
	if(pnumanalyses) *pnumanalyses=numanalyses;
	if(panalyses)    *panalyses=analyses;
	else              xfree((void**)&analyses);
}
