/*!\file:  Load.h
 * \brief abstract class for Load object
 * This class is a place holder for the Icefront  and the Penpair loads.
 * It is derived from Load, so DataSets can contain them.
 */ 


#ifndef _LOAD_H_
#define _LOAD_H_

/*Headers:*/
/*{{{1*/
class Object;

#include "../Object.h"
#include "../../toolkits/toolkits.h"
#include "../../Container/Container.h"
/*}}}*/

class Load: public Object,public Update{

	public: 

		virtual       ~Load(){};
		
		/*Virtual functions: {{{1*/
		virtual void  Configure(Elements* elements,Loads* loads,Nodes* nodes,Vertices* vertices,Materials* materials,Parameters* parameters)=0;
		virtual void  SetCurrentConfiguration(Elements* elements,Loads* loads,Nodes* nodes,Vertices* vertices,Materials* materials,Parameters* parameters)=0;
		virtual void  CreateKMatrix(Mat Kff, Mat Kfs)=0;
		virtual void  CreatePVector(Vec pf)=0;
		virtual void  CreateJacobianMatrix(Mat Jff)=0;
		virtual void  PenaltyCreateJacobianMatrix(Mat Jff,double kmax)=0;
		virtual void  PenaltyCreateKMatrix(Mat Kff, Mat Kfs, double kmax)=0;
		virtual void  PenaltyCreatePVector(Vec pf, double kmax)=0;
		virtual bool  InAnalysis(int analysis_type)=0;
		/*}}}*/
};
#endif
