/*!\file SetControlInputsFromVectorx
 * \brief retrieve vector from inputs in elements
 */

#include "./SetControlInputsFromVectorx.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void SetControlInputsFromVectorx(Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials, Parameters* parameters,double* vector){

	int  num_controls;
	int *control_type = NULL;

	/*Retrieve some parameters*/
	parameters->FindParam(&num_controls,InversionNumControlParametersEnum);
	parameters->FindParam(&control_type,NULL,InversionControlParametersEnum);

	for(int i=0;i<num_controls;i++){
		for(int j=0;j<elements->Size();j++){
			Element* element=(Element*)elements->GetObjectByOffset(j);
			element->SetControlInputsFromVector(vector,control_type[i],i);
		}
	}

	xfree((void**)&control_type);
}

void SetControlInputsFromVectorx(Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials, Parameters* parameters,Vec vector){
	
	double* serial_vector=NULL;

	VecToMPISerial(&serial_vector,vector);

	SetControlInputsFromVectorx(elements,nodes, vertices, loads, materials, parameters,serial_vector);

	/*Free ressources:*/
	xfree((void**)&serial_vector);
}
