/*! \file  PointCloudFindNeighborsx.c
 */

#include "./PointCloudFindNeighborsx.h"

int PointCloudFindNeighborsx( Vec* pflags,double* x, double* y, int nods, double mindistance,double multithread){

	/*output: */
	Vec flags=NULL;
	flags=NewVec(nods);

	/*threading: */
	PointCloudFindNeighborsThreadStruct gate;
	int num=1;

	#ifdef _MULTITHREADING_
	num=_NUMTHREADS_;
	#endif

	if(!multithread)num=1;

	/*initialize thread parameters: */
	gate.x=x;
	gate.y=y;
	gate.nods=nods;
	gate.mindistance=mindistance;
	gate.flags=flags;

	/*launch the thread manager with InterpFromGridToMeshxt as a core: */
	LaunchThread(PointCloudFindNeighborsxt,(void*)&gate,num);

	/*Assemble vector: */
	VecAssemblyBegin(flags);
	VecAssemblyEnd(flags);

	/*Assign output pointers: */
	*pflags=flags;

	return 1;
}
