/*!\file ControlInputSetGradientx
 * \brief retrieve gradient from inputs in elements
 */

#include "./ControlInputSetGradientx.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void ControlInputSetGradientx(Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials, Parameters* parameters,double* gradient){

	/*Intermediaries*/
	int  num_controls;
	int *control_type = NULL;

	/*Retrieve some parameters*/
	parameters->FindParam(&num_controls,InversionNumControlParametersEnum);
	parameters->FindParam(&control_type,NULL,InversionControlParametersEnum);

	for(int i=0;i<num_controls;i++){
		for(int j=0;j<elements->Size();j++){
			Element* element=(Element*)elements->GetObjectByOffset(j);
			element->ControlInputSetGradient(gradient,control_type[i],i);
		}
	}

	/*Clean up and return*/
	xfree((void**)&control_type);

}
void ControlInputSetGradientx(Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials, Parameters* parameters,Vec gradient){

	/*Serialize gradient*/
	double* serial_gradient=NULL;
	VecToMPISerial(&serial_gradient,gradient);

	ControlInputSetGradientx(elements,nodes,vertices, loads, materials, parameters,serial_gradient);

	/*Clean up and return*/
	xfree((void**)&serial_gradient);
}
