#/bin/bash
#Generate a document record for a range of files in the ISSM svn directory (trunk). 

#Some functions
function parselog() #{{{1
{
cat $1 | while read line
do
	if [ "$line" ==  "" ]
	then
		#empty line, keep going
		continue
	fi
	if [ "$line" ==  "------------------------------------------------------------------------" ] 
	then
		#print previous log if not empty
		if [ "$RELEASE" != "" ]
		then
			echo "$RELEASE $USER  $DATE $TIME"
		fi

		#new log coming up!
		NEWLOG=1
		LOG=""
		continue
	fi

	if [ "$NEWLOG" == "1" ] 
	then
		
		#r2714 | morlighe | 2009-12-09 11:48:20 -0800 (Wed, 09 Dec 2009) | 1 line
		RELEASE=$(echo $line | awk '{print $1}')
		USER=$(   echo $line | awk '{print $3}')
		DATE=$(   echo $line | awk '{print $5}')
		TIME=$(   echo $line | awk '{print $6}')

		NEWLOG=0
		continue
	else
		LOG=$(echo "$LOG $line")
	fi
done
} #}}}
function parselogchangedpaths() #{{{1
{
cat $1 | while read line
do
	if [ "$line" ==  "" ]
	then
		svnlog=1
		continue
		#empty line, we are done!
	fi
	if [ "$line" ==  "------------------------------------------------------------------------" ] 
	then
		#print previous log if not empty
		if [ "$RELEASE" != "" ]
		then
			echo $LOG
		fi

		#new log coming up!
		NEWLOG=1
		LOG=""
		continue
	fi

	if [ "$NEWLOG" == "1" ] 
	then
		
		#r2714 | morlighe | 2009-12-09 11:48:20 -0800 (Wed, 09 Dec 2009) | 1 line
		RELEASE=$(echo $line | awk '{print $1}')
		USER=$(   echo $line | awk '{print $3}')
		DATE=$(   echo $line | awk '{print $5}')
		TIME=$(   echo $line | awk '{print $6}')

		NEWLOG=0
		continue
	else
		if [ "$svnlog" == "1" ] 
		then
			continue
		else
			line=`echo $line | grep -v "Changed paths:"`
			LOG=$(echo "$LOG $line")
		fi
	fi
done
} #}}}
function parselogmessages() #{{{1
{
cat $1 | while read line
do
	if [ "$line" ==  "" ]
	then
		svnlog=1
		continue
		#empty line, we are done!
	fi
	if [ "$line" ==  "------------------------------------------------------------------------" ] 
	then
		#print previous log if not empty
		if [ "$RELEASE" != "" ]
		then
			echo $LOG
		fi

		#new log coming up!
		NEWLOG=1
		LOG=""
		continue
	fi

	if [ "$NEWLOG" == "1" ] 
	then
		
		#r2714 | morlighe | 2009-12-09 11:48:20 -0800 (Wed, 09 Dec 2009) | 1 line
		RELEASE=$(echo $line | awk '{print $1}')
		USER=$(   echo $line | awk '{print $3}')
		DATE=$(   echo $line | awk '{print $5}')
		TIME=$(   echo $line | awk '{print $6}')

		NEWLOG=0
		continue
	else
		if [ "$svnlog" == "1" ] 
		then
			line=`echo $line | grep -v "Changed paths:"`
			LOG=$(echo "$LOG $line")
		else
			continue
		fi
	fi
done
} #}}}
function todaydate() #{{{1
{
	suffix=`date | awk '{printf("%s-%s-%s",$2,$3,$6);}'`			 
	echo $suffix;			 
} #}}}

#Only keep pdf file generated? 
keeppdf=1;

#today's date
TODAY=$(todaydate);

#Archive location: 
archiveroot=$ISSM_DIR_UCI/oecreview/Archive
templatedir=$ISSM_DIR_UCI/oecreview/Template
trunk=$ISSM_DIR_UCI/trunk-jpl

#Range 
if test $# -ne 2
then
echo "oecreview.sh needs 2 arguments specifying the svn range on which to apply the review" 
exit 1
fi

r1=$1;
r2=$2;

#Name of archive  directory: 
archivedir="$archiveroot/$r1-$r2"

#Create archive subdirectory for this batch of changes
rm -rf  $archivedir &&  mkdir $archivedir


#start log template
cat > $archivedir/log.tex << EOF
EOF

#create log number
echo "$r1-$r2"  > $archivedir/LogNumber.tex

#create date tex
echo $TODAY  > $archivedir/Date.tex

#create revision texs
echo $r1 > $archivedir/r1.tex
echo $r2 > $archivedir/r2.tex

#copy template
cp  $templatedir/docreview.tex $archivedir/ISSM-DocReview-$r1-$r2.tex
cp  $templatedir/signature.eps $archivedir/
cat $templatedir/Makefile  | sed "s/name=docreview/name=ISSM-DocReview-$r1-$r2/g" > $archivedir/Makefile

counter=0
for (( i=$r1; i<$r2; i++ ))
do
	j=$(($i+1));

	#get svn log for this commit
	log=`svn log  -v -r $i:$j  $trunk | parselog`

	#retrieve info from the log
	release=`echo $log | awk '{printf("%s\n",$1);}'`
	user=`echo $log | awk '{printf("%s\n",$2);}'`
	date=`echo $log | awk '{printf("%s\n",$3);}'`
	time=`echo $log | awk '{printf("%s\n",$4);}'`

	if test -z $user 
	then 
		#empty user, nothing was changed on the trunk/, skip
		continue 
	fi
	
	counter=$(($counter+1))

	#retrieve files affected
	changedpath=`svn log  -v -r $i:$j  $trunk | parselogchangedpaths `
	logmessage=`svn log  -v -r $i:$j  $trunk | parselogmessages `

	#create diff file
	svn diff  -r $i:$j  $trunk > $archivedir/ISSM-$i-$j.diff
	
	#add lines to explain the logs
	cat $archivedir/log.tex && echo "\\noindent \\textbf{Change \#$counter} with diff file ISSM-$i-$j.diff: \\\\ Function name: \\\\$changedpath \\\\ Export determination: 6. \\\\Rationale: $logmessage \\\\\\\\" >> $archivedir/log.tex 
done
	
#Make this latex compatible: 
cat $archivedir/log.tex | sed 's/_/\\_/g' > $archivedir/log.tex.bak
mv $archivedir/log.tex.bak $archivedir/log.tex

#create pdf file
cd $archivedir
make

#copy pdf file in Archive directory:  
cp $archivedir/ISSM-DocReview-$r1-$r2.pdf $archiveroot

#conclude
cd $archivedir

