#include "petsc.h"
#include "petscfix.h"
#include "private/fortranimpl.h"
/* taosolver_fg.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void*);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void*);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "taosolver.h"
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taosetinitialvector_ TAOSETINITIALVECTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taosetinitialvector_ taosetinitialvector
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taocomputegradient_ TAOCOMPUTEGRADIENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taocomputegradient_ taocomputegradient
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taocomputeobjective_ TAOCOMPUTEOBJECTIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taocomputeobjective_ taocomputeobjective
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taocomputeobjectiveandgradient_ TAOCOMPUTEOBJECTIVEANDGRADIENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taocomputeobjectiveandgradient_ taocomputeobjectiveandgradient
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taocomputeseparableobjective_ TAOCOMPUTESEPARABLEOBJECTIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taocomputeseparableobjective_ taocomputeseparableobjective
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taoisobjectivedefined_ TAOISOBJECTIVEDEFINED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taoisobjectivedefined_ taoisobjectivedefined
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taoisgradientdefined_ TAOISGRADIENTDEFINED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taoisgradientdefined_ taoisgradientdefined
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define taoisobjectiveandgradientdefined_ TAOISOBJECTIVEANDGRADIENTDEFINED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define taoisobjectiveandgradientdefined_ taoisobjectiveandgradientdefined
#endif


/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif

void PETSC_STDCALL  taosetinitialvector_(TaoSolver *tao,Vec x0, int *__ierr ){
*__ierr = TaoSetInitialVector(*tao,
	(Vec)PetscToPointer((x0) ));
}
void PETSC_STDCALL  taocomputegradient_(TaoSolver *tao,Vec X,Vec G, int *__ierr ){
*__ierr = TaoComputeGradient(*tao,
	(Vec)PetscToPointer((X) ),
	(Vec)PetscToPointer((G) ));
}
void PETSC_STDCALL  taocomputeobjective_(TaoSolver *tao,Vec X,PetscReal *f, int *__ierr ){
*__ierr = TaoComputeObjective(*tao,
	(Vec)PetscToPointer((X) ),f);
}
void PETSC_STDCALL  taocomputeobjectiveandgradient_(TaoSolver *tao,Vec X,PetscReal *f,Vec G, int *__ierr ){
*__ierr = TaoComputeObjectiveAndGradient(*tao,
	(Vec)PetscToPointer((X) ),f,
	(Vec)PetscToPointer((G) ));
}
void PETSC_STDCALL  taocomputeseparableobjective_(TaoSolver *tao,Vec X,Vec F, int *__ierr ){
*__ierr = TaoComputeSeparableObjective(*tao,
	(Vec)PetscToPointer((X) ),
	(Vec)PetscToPointer((F) ));
}
void PETSC_STDCALL  taoisobjectivedefined_(TaoSolver *tao,PetscBool *flg, int *__ierr ){
*__ierr = TaoIsObjectiveDefined(*tao,flg);
}
void PETSC_STDCALL  taoisgradientdefined_(TaoSolver *tao,PetscBool *flg, int *__ierr ){
*__ierr = TaoIsGradientDefined(*tao,flg);
}
void PETSC_STDCALL  taoisobjectiveandgradientdefined_(TaoSolver *tao,PetscBool *flg, int *__ierr ){
*__ierr = TaoIsObjectiveAndGradientDefined(*tao,flg);
}
#if defined(__cplusplus)
}
#endif
