% This file can be run to update the velocity archives  of the test1.
% This test deals with an icesheet without icefront for a 2d model. The geometry 
% is square. Just run this file in Matlab, with a properly setup Ice code. 

% The archive files will be saved in this directory but will not commited to ice1. 
% Just commit the result if you want to.

%packages and solutions to be tested
packages={'macayeal','ice','cielo_serial','cielo_parallel'};

%go through the solutions requested
for i=1:length(packages),
	package=packages{i};

	%initialize model
	md=model;
	md=mesh(md,'DomainOutline.exp',50000);
	md=geography(md,'','');
	md=parameterize(md,'Square.par');
	md=setelementstype(md,'macayeal','all');

	%Compute solution using requested package
	if strcmpi(package,'macayeal'),

		%DIAGNOSTIC
		md=solve(md,'diagnostic','macayeal');
		%save archive
		ArchiveMacAyealDiag=md.vel;
		save ArchiveMacAyealDiag ArchiveMacAyealDiag

	elseif strcmpi(package,'ice'),

		%DIAGNOSTIC
		md=solve(md,'diagnostic','ice');
		%save archive
		ArchiveIceDiag=md.vel;
		save ArchiveIceDiag ArchiveIceDiag

	elseif strcmpi(package,'cielo_serial'),

		%DIAGNOSTIC
		md=solve(md,'diagnostic','cielo');
		%save archive
		ArchiveCieloSerialDiag=md.vel;
		save ArchiveCieloSerialDiag ArchiveCieloSerialDiag

	elseif strcmpi(package,'cielo_parallel'),

		%DIAGNOSTIC
		md.cluster='wilkes';
		md=solve(md,'diagnostic_horiz','cielo');
		%save archive
		ArchiveCieloParallelDiag=md.vel;
		save ArchiveCieloParallelDiag ArchiveCieloParallelDiag

	else
		disp(sprintf(['\npackage ' package  ' not supported yet.\n']));
	end
end
