function varargout=updatearchive(varargin)
%updatearchive - test deck for ISSM nightly runs
%
%   Usage:
%      varargout=updatearchive(varargin);
%
%   Examples:
%      updatearchive;
%      updatearchive({'ice'});
%      updatearchive({'ice','cielo_serial'},{'diagnostic'});
%      md=updatearchive({'cielo_parallel'});
%
%   See also: RUNME

% This file can be run to update the velocity archives  of the test1.
% This test deals with an icesheet with icefront for a 3d model. The geometry 
% is square. Just run this file in Matlab, with a properly setup Ice code. 

% The archive files will be saved in this directory but will not commited to ice1. 
% Just commit the result if you want to.

%check arguments
if (nargin>2 | nargout>1)
	help updatearchive
	error('updatearchive error message: bad usage');
end

%packages and analysis_types to be tested
if nargin==2,
	solutions=varargin{2};
else
	solutions={'diagnostic','thermalsteady','thermaltransient','prognostic','transient'};
end
if nargin,
	packages=varargin{1};
else
	packages={'macayeal','ice','cielo_serial','cielo_parallel'};
end

%go through the solutions requested
testname='IceSheetNoIceFrontH3d_13';
for i=1:length(packages),
	package=packages{i};

	for j=1:length(solutions),
		solution=solutions{j};

		%check solution requested
		if (strcmpi(package,'macayeal')...
				| strcmpi(solution,'transient')),
			disp(sprintf(['\nsolution: ' solution  ', with package: ' package  ', in test: ' testname  ', not supported yet.\n']));
			continue
		end

		%initialize model
		md=model;
		md=mesh(md,'DomainOutline.exp',100000);
		md=geography(md,'','');
		md=parameterize(md,'Square.par');
		md=extrude(md,8,4);
		md=setelementstype(md,'hutter','all');
		if md.numberofgrids==728
			load Velocities; md.vx=0.5*vx; md.vy=0.5*vy; md.vz=0.5*vz; md.temperature=temperature-1; md.pressure=pressure;
		end

		%compute solution
		[analysis_type sub_analysis_type]=testsgetanalysis(solution);
		[md packagefinal]=testsgetpackage(md,package);
		if ~testschecksolution(md.type,solution), continue; end
		md=solve(md,'analysis_type',analysis_type,'sub_analysis_type',sub_analysis_type,'package',packagefinal);

		%compute fields to be checked
		fields=testsgetfields(md.type,solution);

		%save new archive
		for k=1:length(fields),
			field=fields{k};
			eval(['Archive' package solution '_field' num2str(k) '=md.results. ' field  ';']);
		end
		eval(['save Archive' package solution ' Archive' package solution '_field*']);
	end
end
if nargout==1, 
	varargout{1}=md; 
end
