#!/bin/bash

#get brand new project: 
rm -rf ISSM.aip  ISSM-SetupFiles ISSM.msi
cp ISSM.initial.aip ISSM.aip

#build list of files to put into the installer: 
rm -rf ISSM.aic 
cat << END > ISSM.aic
;aic
SetVersion "1.0"
SetPackageName "ISSM.msi"
END

ls $ISSM_TIER_WIN/bin/*.m $ISSM_TIER_WIN/bin/*.mexw64 $ISSM_TIER_WIN/bin/*.h $ISSM_TIER_WIN/bin/*.exe | awk '{printf("AddFile APPDIR %s\n",$1);}' | sed 's/\//\\/g' >> ISSM.aic


cat << END >> ISSM.aic
AddFolder PersonalFolder $ISSM_TIER_WIN\test
AddFolder APPDIR $ISSM_TIER_WIN\bin\@modellist
AddFolder APPDIR $ISSM_TIER_WIN\bin\@pairoptions
SetPackageType x64 
DelEnvironment ISSM_TESTS
NewEnvironment -name ISSM_TESTS -value [test_Dir]
DelEnvironment ISSM_TIER
NewEnvironment -name ISSM_TIER -value [APPDIR]
DelEnvironment ISSM_TIER_WIN
NewEnvironment -name ISSM_TIER_WIN -value [APPDIR]
Save
Rebuild
END

#Run installer: 
"C:/Program Files (x86)/Caphyon/Advanced Installer 8.9/bin/x86/AdvancedInstaller.com" /execute  ./ISSM.aip ./ISSM.aic

#Get rid of temporary files: 
cp ISSM-SetupFiles/ISSM.msi ./
rm -rf ISSM.aip ISSM-SetupFiles
