/*! \file Tria.h 
 *  \brief: header file for tria object
 */

#ifndef _TRIA_H_
#define _TRIA_H_

/*Headers:*/
/*{{{1*/
#include "./Element.h"
#include "./TriaHook.h"
#include "./TriaRef.h"
class Parameters;
class Inputs;
class IoModel;
class Node;
class Matice;
class Matpar;
class ElementMatrix;
class ElementVector;

#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
/*}}}*/

class Tria: public Element,public TriaHook,public TriaRef{

	public:

		int  id;
		int  sid;

		Node   **nodes;    // 3 nodes
		Matice  *matice;   // 1 material ice
		Matpar  *matpar;   // 1 material parameter
		int      horizontalneighborsids[3];

		Parameters *parameters;   //pointer to solution parameters
		Inputs     *inputs;
		Results    *results;

		/*Tria constructors, destructors {{{1*/
		Tria();
		Tria(int tria_id,int tria_sid,int i, IoModel* iomodel,int nummodels);
		~Tria();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		#ifdef _SERIAL_
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		#endif
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*Update virtual functions resolution: {{{1*/
		void  InputUpdateFromSolution(double* solutiong);
		void  InputUpdateFromVector(double* vector, int name, int type);
		void  InputUpdateFromVector(int* vector, int name, int type);
		void  InputUpdateFromVector(bool* vector, int name, int type);
		#ifdef _HAVE_DAKOTA_
		void  InputUpdateFromVectorDakota(double* vector, int name, int type);
		void  InputUpdateFromVectorDakota(int* vector, int name, int type);
		void  InputUpdateFromVectorDakota(bool* vector, int name, int type);
		void  InputUpdateFromMatrixDakota(double* matrix, int nows, int ncols, int name, int type);
		#endif
		void  InputUpdateFromConstant(double constant, int name);
		void  InputUpdateFromConstant(int constant, int name);
		void  InputUpdateFromConstant(bool constant, int name);
		void  InputUpdateFromIoModel(int index, IoModel* iomodel);
		/*}}}*/
		/*Element virtual functions definitions: {{{1*/
		void   AverageOntoPartition(Vec partition_contributions,Vec partition_areas,double* vertex_response,double* qmu_part);
		void   ComputeBasalStress(Vec sigma_b);
		void   ComputeStrainRate(Vec eps);
		void   ComputeStressTensor();
		void   Configure(Elements* elements,Loads* loads,DataSet* nodes,Materials* materials,Parameters* parameters);
		void   SetCurrentConfiguration(Elements* elements,Loads* loads,DataSet* nodes,Materials* materials,Parameters* parameters);
		void   CreateKMatrix(Mat Kff, Mat Kfs,Vec df);
		void   CreatePVector(Vec pf);
		void   CreateJacobianMatrix(Mat Jff);
		int    GetNodeIndex(Node* node);
		int    Sid();
		bool   IsOnBed();
		bool   IsFloating(); 
		bool   IsNodeOnShelf(); 
		bool   IsNodeOnShelfFromFlags(double* flags);
		bool   IsOnWater(); 
		void   GetSolutionFromInputs(Vec solution);
		void   GetVectorFromInputs(Vec vector, int name_enum);
		void   GetVectorFromResults(Vec vector,int offset,int interp);
		void   InputArtificialNoise(int enum_type,double min, double max);
		bool   InputConvergence(double* eps, int* enums,int num_enums,int* criterionenums,double* criterionvalues,int num_criterionenums);
		void   InputCreate(double scalar,int name,int code);
		void   InputCreate(double* vector, int index,IoModel* iomodel,int M,int N,int vector_type,int vector_enum,int code);
		void   InputDepthAverageAtBase(int enum_type,int average_enum_type,int object_enum=MeshElementsEnum);
		void   InputDuplicate(int original_enum,int new_enum);
		void   InputScale(int enum_type,double scale_factor);
		void   InputToResult(int enum_type,int step,double time);
		void   DeleteResults(void);
		void   MaterialUpdateFromTemperature(void){_error_("not implemented yet");};
		void   MigrateGroundingLine(double* oldfloating,double* sheet_ungrounding);
		void   PotentialSheetUngrounding(Vec potential_sheet_ungrounding);
		void   RequestedOutput(int output_enum,int step,double time);
		void   ListResultsInfo(int** results_enums,int** results_size,double** results_times,int** results_steps,int* num_results);
		void   PatchFill(int* pcount, Patch* patch);
		void   PatchSize(int* pnumrows, int* pnumvertices,int* pnumnodes);
		void   ProcessResultsUnits(void);
		void   ResetCoordinateSystem(void){_error_("not implemented yet");};
		double SurfaceArea(void);
		void   Update(int index, IoModel* iomodel,int analysis_counter,int analysis_type);
		int    UpdatePotentialSheetUngrounding(double* vertices_potentially_ungrounding,Vec vec_nodes_on_iceshelf,double* nodes_on_iceshelf);
		double TimeAdapt();
		int*   GetHorizontalNeighboorSids(void);
		void   SmearFunction(Vec smearedvector,double (*WeightFunction)(double distance,double radius),double radius);

		#ifdef _HAVE_RESPONSES_
		double IceVolume(void);
		void   MinVel(double* pminvel, bool process_units);
		void   MinVx(double* pminvx, bool process_units);
		void   MinVy(double* pminvy, bool process_units);
		void   MinVz(double* pminvz, bool process_units);
		int    NodalValue(double* pvalue, int index, int natureofdataenum,bool process_units);
		double MassFlux(double* segment,bool process_units);
		void   MaxAbsVx(double* pmaxabsvx, bool process_units);
		void   MaxAbsVy(double* pmaxabsvy, bool process_units);
		void   MaxAbsVz(double* pmaxabsvz, bool process_units);
		void   ElementResponse(double* presponse,int response_enum,bool process_units);
		void   MaxVel(double* pmaxvel, bool process_units);
		void   MaxVx(double* pmaxvx, bool process_units);
		void   MaxVy(double* pmaxvy, bool process_units);
		void   MaxVz(double* pmaxvz, bool process_units);
		#endif


		#ifdef _HAVE_CONTROL_
		double DragCoefficientAbsGradient(bool process_units,int weight_index);
		void   GradientIndexing(int* indexing,int control_index);
		void   Gradj(Vec gradient,int control_type,int control_index);
		void   GradjBGradient(Vec gradient,int weight_index,int control_index);
		void   GradjBMacAyeal(Vec gradient,int control_index);
		void   GradjDragMacAyeal(Vec gradient,int control_index);
		void   GradjDragStokes(Vec gradient,int control_index);
		void   GradjDragGradient(Vec gradient,int weight_index,int control_index);
		void   GradjDhDtBalancedthickness(Vec gradient,int control_index);
		void   GradjVxBalancedthickness(Vec gradient,int control_index);
		void   GradjVyBalancedthickness(Vec gradient,int control_index);
		void   GetVectorFromControlInputs(Vec gradient,int control_enum,int control_index,const char* data);
		void   SetControlInputsFromVector(double* vector,int control_enum,int control_index);
		void   ControlInputGetGradient(Vec gradient,int enum_type,int control_index);
		void   ControlInputScaleGradient(int enum_type,double scale);
		void   ControlInputSetGradient(double* gradient,int enum_type,int control_index);
		double RheologyBbarAbsGradient(bool process_units,int weight_index);
		double ThicknessAbsMisfit(     bool process_units,int weight_index);
		double SurfaceAbsVelMisfit(    bool process_units,int weight_index);
		double ThicknessAbsGradient(bool process_units,int weight_index);
		double SurfaceRelVelMisfit(    bool process_units,int weight_index);
		double SurfaceLogVelMisfit(    bool process_units,int weight_index);
		double SurfaceLogVxVyMisfit(   bool process_units,int weight_index);
		double SurfaceAverageVelMisfit(bool process_units,int weight_index);
		void   InputControlUpdate(double scalar,bool save_parameter);
		#endif

		/*}}}*/
		/*Tria specific routines:{{{1*/
		ElementMatrix* CreateKMatrixBalancethickness(void);
		ElementMatrix* CreateKMatrixBalancethickness_DG(void);
		ElementMatrix* CreateKMatrixBalancethickness_CG(void);
		ElementMatrix* CreateKMatrixMelting(void);
		ElementMatrix* CreateKMatrixPrognostic(void);
		ElementMatrix* CreateKMatrixPrognostic_CG(void);
		ElementMatrix* CreateKMatrixPrognostic_DG(void);
		ElementMatrix* CreateKMatrixSlope(void);
		ElementVector* CreatePVectorBalancethickness(void);
		ElementVector* CreatePVectorBalancethickness_DG(void);
		ElementVector* CreatePVectorBalancethickness_CG(void);
		ElementVector* CreatePVectorPrognostic(void);
		ElementVector* CreatePVectorPrognostic_CG(void);
		ElementVector* CreatePVectorPrognostic_DG(void);
		ElementVector* CreatePVectorSlope(void);
		double         GetArea(void);
		int            GetElementType(void);
		void	         GetDofList(int** pdoflist,int approximation_enum,int setenum);
		void	         GetDofList1(int* doflist);
		void           GetSidList(int* sidlist);
		void           GetConnectivityList(int* connectivity);
		void           GetInputListOnVertices(double* pvalue,int enumtype);
		void           GetInputListOnVertices(double* pvalue,int enumtype,double defaultvalue);
		void           GetInputListOnVertices(double* pvalue,int enumtype,double defaultvalue,int index); //TO BE REMOVED
		void           GetInputValue(double* pvalue,Node* node,int enumtype);
		void           GetStrainRate2d(double* epsilon,double* xyz_list, GaussTria* gauss, Input* vx_input, Input* vy_input);
		void	         InputUpdateFromSolutionOneDof(double* solution,int enum_type);
		void	         InputUpdateFromSolutionPrognostic(double* solution);
		bool	         IsInput(int name);
		void	         SetClone(int* minranks);
		void	         SurfaceNormal(double* surface_normal, double xyz_list[3][3]);
		
		#ifdef _HAVE_DIAGNOSTIC_
		ElementMatrix* CreateKMatrixDiagnosticMacAyeal(void);
		ElementMatrix* CreateKMatrixDiagnosticMacAyealViscous(void);
		ElementMatrix* CreateKMatrixDiagnosticMacAyealFriction(void);
		ElementMatrix* CreateKMatrixDiagnosticHutter(void);
		ElementVector* CreatePVectorDiagnosticMacAyeal(void);
		ElementVector* CreatePVectorDiagnosticHutter(void);
		ElementMatrix* CreateJacobianDiagnosticMacayeal(void);
		void	  GetSolutionFromInputsDiagnosticHoriz(Vec solution);
		void	  GetSolutionFromInputsDiagnosticHutter(Vec solution);
		void	  InputUpdateFromSolutionDiagnosticHoriz( double* solution);
		void	  InputUpdateFromSolutionDiagnosticHutter( double* solution);
		#endif

		#ifdef _HAVE_CONTROL_
		ElementMatrix* CreateKMatrixAdjointBalancethickness(void);
		ElementMatrix* CreateKMatrixAdjointMacAyeal(void);
		ElementVector* CreatePVectorAdjointHoriz(void);
		ElementVector* CreatePVectorAdjointStokes(void);
		ElementVector* CreatePVectorAdjointBalancethickness(void);
		void	  InputUpdateFromSolutionAdjointBalancethickness( double* solution);
		void	  InputUpdateFromSolutionAdjointHoriz( double* solution);
		#endif

		#ifdef _HAVE_HYDROLOGY_
		ElementMatrix* CreateKMatrixHydrology(void);
		ElementVector* CreatePVectorHydrology(void);
		void      CreateHydrologyWaterVelocityInput(void);
		void	  GetSolutionFromInputsHydrology(Vec solution);
		void	  InputUpdateFromSolutionHydrology(double* solution);
		#endif
		#ifdef _HAVE_BALANCED_
		#endif

		/*}}}*/

};
#endif  /* _TRIA_H */
