/*!\file KML_File.cpp
 * \brief: implementation of the kml_file object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../io/io.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION KML_File::KML_File(){{{1*/
KML_File::KML_File(){

	;

}
/*}}}*/
/*FUNCTION KML_File::~KML_File(){{{1*/
KML_File::~KML_File(){

	;

}
/*}}}*/

/*Other*/
/*FUNCTION KML_File::Echo {{{1*/
void  KML_File::Echo(){

	bool  flag=true;

	_printf_(flag,"KML_File:\n");
	KML_Object::Echo();

	return;
}
/*}}}*/
/*FUNCTION KML_File::DeepEcho {{{1*/
void  KML_File::DeepEcho(){

	char  indent[81]="";

	KML_File::DeepEcho(indent);

	return;
}
/*}}}*/
/*FUNCTION KML_File::DeepEcho {{{1*/
void  KML_File::DeepEcho(const char* indent){

	bool  flag=true;

	_printf_(flag,"%sKML_File:\n",indent);
	KML_Object::DeepEcho(indent);

/*  loop over the kml objects for the file  */

	memcpy(indent2,indent,(strlen(indent)+1)*sizeof(char));

	strcat(indent2,"  ");

	if (kmlobj->Size())
		for (i=0; i<kmlobj->Size(); i++) {
			_printf_(flag,"%s        kmlobj: -------- begin [%d] --------\n" ,indent,i);
			((KML_Object *)kmlobj->GetObjectByOffset(i))->DeepEcho(indent2);
			_printf_(flag,"%s        kmlobj: --------  end  [%d] --------\n" ,indent,i);
		}
	else
		_printf_(flag,"%s        kmlobj: [empty]\n"    ,indent);

	return;
}
/*}}}*/
/*FUNCTION KML_File::Write {{{1*/
void  KML_File::Write(FILE* filout,const char* indent){

	fprintf(filout,"%s<kml",indent);
	WriteAttrib(filout," ");
	fprintf(filout,">\n");
	WriteCommnt(filout,indent);

	KML_Object::Write(filout,indent);

	fprintf(filout,"%s</kml>\n",indent);

	return;
}
/*}}}*/
/*FUNCTION KML_File::Read {{{1*/
void  KML_File::Read(FILE* fid,char* kstr){

	char*        kstri;
	int          ncom=0;
	char**       pcom=NULL;
	KML_Object*  kobj;

/*  get object attributes and check for solo tag  */

	if (KMLFileTagAttrib(this,
						 kstr))
		return;

/*  loop over and process fields within opening and closing tags  */

	while (kstri=KMLFileToken(fid,
							  &ncom,&pcom)) {
		if      (!strncmp(kstri,"</kml", 5)) {
			xfree((void**)&kstri);
			break;
		}
		else if (!strncmp(kstri,"</",2))
			_error_("KML_File::Read -- Unexpected closing tag %s.\n",kstri);
		else if (strncmp(kstri,"<",1))
			_error_("KML_File::Read -- Unexpected field \"%s\".\n",kstri);

		else if (!strncmp(kstri,"<",1))
			KML_Object::Read(fid,kstri);

		xfree((void**)&kstri);
	}

	this->AddCommnt(ncom,pcom);

	for (ncom; ncom>0; ncom--)
		xfree((void**)&(pcom[ncom-1]));
	xfree((void**)&pcom);

	return;
}
/*}}}*/
/*FUNCTION KML_File::WriteExp {{{1*/
void  KML_File::WriteExp(FILE* fid,const char* nstr,int sgn,double cm,double sp){

	int   i;

/*  loop over the kml objects for the file  */

	for (i=0; i<kmlobj->Size(); i++)
		((KML_Object *)kmlobj->GetObjectByOffset(i))->WriteExp(fid,nstr,sgn,cm,sp);

	return;
}
/*}}}*/
