#!/bin/bash

#Some cleanup
rm -rf install petsc-3.2-p3 src
mkdir install src

#Untar and move petsc to install directory
tar -zxvf  petsc-3.2-p3.tar.gz
mv petsc-3.2-p3/* src/
rm -rf petsc-3.2-p3

#configure
cd src
./config/configure.py \
	--prefix="$ISSM_TIER/externalpackages/petsc/install" \
	--PETSC_DIR="$ISSM_TIER/externalpackages/petsc/src" \
	--PETSC_ARCH="$ISSM_ARCH" \
	--with-batch=1 \
	--with-debugging=0 \
	--with-shared-libraries=0 \
	--known-mpi-shared-libraries=1 \
	--with-mpi-dir=/sopt/mpi/openmpi-1.5.4_psm/intel/ \
	--with-blas-lapack-dir=/opt/intel/mkl/10.2.4.032/ \
	--download-mumps=yes \
	--download-scalapack=yes \
	--download-blacs=yes \
	--download-plapack=yes \
	--download-parmetis=yes \
	--with-pic=1

echo "== Follow PETSc's instructions"
