#!/bin/bash

#Some cleanup
rm -rf install petsc-3.2-p3 src
mkdir install src

#Untar and move petsc to install directory
tar -zxvf  petsc-3.2-p3.tar.gz
mv petsc-3.2-p3/* src/
rm -rf petsc-3.2-p3

#configure
cd src
./config/configure.py \
	--prefix="$ISSM_TIER/externalpackages/petsc/install" \
	--PETSC_DIR="$ISSM_TIER/externalpackages/petsc/src" \
	--with-debugging=0 \
	--with-shared-libraries=0 \
	--known-mpi-shared-libraries=1 \
	--with-mpi-lib=/usr/mpi/intel/mvapich2-1.4.1-qlc/lib/libmpi.so \
	--with-mpi-include=/usr/mpi/intel/mvapich2-1.4.1-qlc/include/ \
	--download-mumps=yes \
	--download-scalapack=yes \
	--download-blacs=yes \
	--download-blas=yes \
	--download-f-blas-lapack=yes \
	--download-plapack=yes \
	--download-parmetis=yes \
	--with-pic=1

#Compile petsc and install it
make
make install
