// tps (01/14/2010) : Switching from rose.h to sage3.
#include "sage3basic.h"
#ifdef _MSC_VER
#include "buildMangledNameMap.h"
#endif
#include "buildReplacementMap.h"
#include "buildMangledNameMap.h"
#include "fixupTraversal.h"
#include "collectAssociateNodes.h"
#include "test_support.h"
using namespace std;

MangledNameMapTraversal::MangledNameMapTraversal ( MangledNameMapType & m, SetOfNodesType & deleteSet )
   : mangledNameMap(m), setOfNodesToDelete(deleteSet) 
   {
     numberOfNodes                         = 0;
     numberOfNodesSharable                 = 0;
     numberOfNodesEvaluated                = 0;
     numberOfNodesAddedToManagledNameMap   = 0;
     numberOfNodesAlreadyInManagledNameMap = 0;

  // Initialized the mangled name map with the default types that are held as static data.
  // Note that when merging two files, each file will have a static type, plus there will be 
  // a null static pointer to each type.  We want to have the merge take place using the
  // static pointer value in each type (e.g SgTypeInt).  So we have to check if there
  // are such types in use and then make sure that the static pointer is initialized (calling
  // the TYPE::createType() function is enough to do this). We also want to force the the 
  // static type is used in the mangled map for consistancy. Having the static pointer to
  // each type in the mangled map will force all replacements to use it instead of any other
  // (which makes the AST consistant).

  // Use a simple macro to simplify the generation of the correct code.
     #define MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(TYPE) if (TYPE::numberOfNodes() > 0) { TYPE* t = TYPE::createType(); addToMap(SageInterface::generateUniqueName(t,false),t); }
 
  // DQ (7/10/2010): This is a test of the AST merge to investigate robustness.
#if 1
  // Note that this will cause any required types to be built which can 
  // then be used to as references to those types via the p_builtin_type 
  // static data member.

  // Call the macro for every kind of type used in ROSE.
  // Note that this should later be a function generated by ROSETTA.
     MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(SgTypeUnknown)
     MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(SgTypeChar)
     MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(SgTypeSignedChar)
     MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(SgTypeUnsignedChar)
     MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(SgTypeShort)
     MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(SgTypeSignedShort)
     MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(SgTypeUnsignedShort)
     MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(SgTypeInt)
     MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(SgTypeSignedInt)
     MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(SgTypeUnsignedInt)
     MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(SgTypeLong)
     MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(SgTypeSignedLong)
     MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(SgTypeUnsignedLong)
     MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(SgTypeVoid)
     MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(SgTypeGlobalVoid)
     MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(SgTypeWchar)
     MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(SgTypeFloat)
     MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(SgTypeDouble)
     MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(SgTypeLongLong)
     MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(SgTypeSignedLongLong)
     MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(SgTypeUnsignedLongLong)
     MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(SgTypeLongDouble)
  // MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(SgTypeString)
     MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(SgTypeBool)
     MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(SgNamedType)
     MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(SgPartialFunctionModifierType)
     MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(SgTypeEllipse)
     MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(SgTypeDefault)
     MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(SgAsmTypeByte)
     MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(SgAsmTypeWord)
     MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(SgAsmTypeDoubleWord)
     MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(SgAsmTypeQuadWord)
     MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(SgAsmTypeDoubleQuadWord)
     MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(SgAsmType80bitFloat)
     MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(SgAsmType128bitFloat)
     MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(SgAsmTypeSingleFloat)
     MACRO_ADD_STATIC_TYPE_TO_MANGLED_MAP(SgAsmTypeDoubleFloat)
#endif

#if 0
  // DQ (7/4/2010): Since we have maybe added some new types, they will not have consistant SgTypedefSequence list so sync them to be consistant.
     printf ("Normalize the SgTypedefSeq IR nodes to be consistant across the same kind of types in the AST. \n");
     normalizeTypedefSequenceLists();
     printf ("DONE: Normalize the SgTypedefSeq IR nodes to be consistant across the same kind of types in the AST. \n");
#endif

#if 0
  // If there are not IR nodes of this type in the AST, there is not need to support merge 
  // by adding an associated entry in the mangled name map.
     if (SgTypeInt::numberOfNodes() > 0)
        {
          printf ("Generating a SgTypeInt and adding it to the mangled name map. \n");
          SgTypeInt* intType = SgTypeInt::createType();
          bool ignoreDifferenceBetweenDefiningAndNondefiningDeclarations = false;
          string key = SageInterface::generateUniqueName(intType,ignoreDifferenceBetweenDefiningAndNondefiningDeclarations);
          ROSE_ASSERT(key.empty() == false);
          addToMap(key,intType);

          printf ("Exiting as a test after adding SgTypeInt to the mangled name map. \n");
          ROSE_ASSERT(false);
        }
#endif
   }

bool
MangledNameMapTraversal::shareableIRnode ( const SgNode* node )
   {
  // At least for now we will likely share all possible IR nodes (except a few)
  // In the visit function we get more specific (we are mostly interested in declarations).
     bool returnValue = true;

  // These are not sharable IR nodes (could all these dynamic casts might be a performance issue?)
     const SgProject* project                         = isSgProject(node);
     const SgFile* file                               = isSgFile(node);
     const SgSymbolTable* symbolTable                 = isSgSymbolTable(node);
     const SgCtorInitializerList* ctorInitializerList = isSgCtorInitializerList(node);
     const SgBasicBlock* block                        = isSgBasicBlock(node);

  // DQ (2/9/2007): Adding this IR node decreased the number of tested IR nodes by 30%.
     const Sg_File_Info* fileInfo                     = isSg_File_Info(node);

  // DQ (2/9/2007): Added this case, but it makes less than a 1% difference (e.g. 14 out of 8412)
     const SgExpression* expression                   = isSgExpression(node);

     if ( project != NULL || file != NULL || symbolTable != NULL || ctorInitializerList != NULL || block != NULL || fileInfo != NULL || expression != NULL )
        {
          returnValue = false;
        }
#if 0
     const SgTypedefDeclaration* typedefDeclaration   = isSgTypedefDeclaration(node);

  // Added to test use of sharing only for global scope declarations!
     if ( typedefDeclaration != NULL )
        {
          returnValue = false;
        }
#endif

#if 0
  // I can't make this work, and I think it is because there are nested IR nodes that
  // can have a representation in global scope or a namespace scope such that all are required.
  // Further limit sharable IR nodes to declarations appearing in global scope!
     if ( returnValue == true )
        {
          const SgDeclarationStatement* declaration = isSgDeclarationStatement(node);
          if (declaration != NULL)
             {
            // Ignore IR nodes that not in either a SgGlobal or SgNamespaceDefinitionStatement
            // if (declaration->get_scope()->variantT() != V_SgGlobal && declaration->get_scope()->variantT() != V_SgNamespaceDefinitionStatement ) 
               if (declaration->get_scope()->variantT() == V_SgClassDefinition )
                  {
                    returnValue = false;
                  }
             }
        }
#endif

  // This is likely not required and will be a performance bottleneck as well.
  // DQ (7/4/2010): Make sure that if we don't share an IR node then it is should NOT one of these types (which should be shared).
     if (returnValue == false)
        {
          ROSE_ASSERT(isSgTypeUnknown(node) == NULL);
          ROSE_ASSERT(isSgTypeChar(node) == NULL);
          ROSE_ASSERT(isSgTypeSignedChar(node) == NULL);
          ROSE_ASSERT(isSgTypeUnsignedChar(node) == NULL);
          ROSE_ASSERT(isSgTypeShort(node) == NULL);
          ROSE_ASSERT(isSgTypeSignedShort(node) == NULL);
          ROSE_ASSERT(isSgTypeUnsignedShort(node) == NULL);
          ROSE_ASSERT(isSgTypeInt(node) == NULL);
          ROSE_ASSERT(isSgTypeSignedInt(node) == NULL);
          ROSE_ASSERT(isSgTypeUnsignedInt(node) == NULL);
          ROSE_ASSERT(isSgTypeLong(node) == NULL);
          ROSE_ASSERT(isSgTypeSignedLong(node) == NULL);
          ROSE_ASSERT(isSgTypeUnsignedLong(node) == NULL);
          ROSE_ASSERT(isSgTypeVoid(node) == NULL);
          ROSE_ASSERT(isSgTypeGlobalVoid(node) == NULL);
          ROSE_ASSERT(isSgTypeWchar(node) == NULL);
          ROSE_ASSERT(isSgTypeFloat(node) == NULL);
          ROSE_ASSERT(isSgTypeDouble(node) == NULL);
          ROSE_ASSERT(isSgTypeLongLong(node) == NULL);
          ROSE_ASSERT(isSgTypeSignedLongLong(node) == NULL);
          ROSE_ASSERT(isSgTypeUnsignedLongLong(node) == NULL);
          ROSE_ASSERT(isSgTypeLongDouble(node) == NULL);
          ROSE_ASSERT(isSgTypeString(node) == NULL);
          ROSE_ASSERT(isSgTypeBool(node) == NULL);
          ROSE_ASSERT(isSgNamedType(node) == NULL);
          ROSE_ASSERT(isSgPartialFunctionModifierType(node) == NULL);
          ROSE_ASSERT(isSgTypeEllipse(node) == NULL);
          ROSE_ASSERT(isSgTypeDefault(node) == NULL);
          ROSE_ASSERT(isSgAsmTypeByte(node) == NULL);
          ROSE_ASSERT(isSgAsmTypeWord(node) == NULL);
          ROSE_ASSERT(isSgAsmTypeDoubleWord(node) == NULL);
          ROSE_ASSERT(isSgAsmTypeQuadWord(node) == NULL);
          ROSE_ASSERT(isSgAsmTypeDoubleQuadWord(node) == NULL);
          ROSE_ASSERT(isSgAsmType80bitFloat(node) == NULL);
          ROSE_ASSERT(isSgAsmType128bitFloat(node) == NULL);
          ROSE_ASSERT(isSgAsmTypeSingleFloat(node) == NULL);
          ROSE_ASSERT(isSgAsmTypeDoubleFloat(node) == NULL);
        }

     return returnValue;
   }

void
MangledNameMapTraversal::displayMagledNameMap ( MangledNameMapTraversal::MangledNameMapType & m )
   {
     printf ("In MangledNameMapTraversal::displayMagledNameMap(): size() = %zu \n",m.size());
     MangledNameMapType::iterator i = m.begin();
     while (i != m.end())
        {
          string  s    = i->first;
          SgNode* node = i->second;
          ROSE_ASSERT(node != NULL);
          printf ("node = %p = %s  generated unique name = %s \n",node,node->class_name().c_str(),s.c_str());

          i++;
        }
   }


set<SgNode*>
MangledNameMapTraversal::buildSetFromMangleNameMap ( MangledNameMapTraversal::MangledNameMapType & m )
   {
  // This function support the set_defference to remove any nodes used as reference point in the 
  // mangled name map from the delete list that is generated.  IR nodes in the mangled name map
  // will be the IR nodes used to share IR nodes in the merged AST.  This is an issue for un-named
  // types which appear multiple times and need to be handled precisely.

  // printf ("In MangledNameMapTraversal::buildSetFromMangleNameMap(): size() = %ld \n",m.size());
      set<SgNode*> returnSet;
     MangledNameMapType::iterator i = m.begin();
     while (i != m.end())
        {
          ROSE_ASSERT(i->second != NULL);
          returnSet.insert(i->second);
          i++;
        }

     return returnSet;
   }


// Forward function declaration
// void buildDeleteList ( set<SgNode*> & listToDelete );
// void addAssociatedNodes ( SgNode* node, set<SgNode*> & setOfNodesToDelete, SgNode* matchingNodeInMergedAST );

void
MangledNameMapTraversal::addToMap ( string key, SgNode* node)
   {
     ROSE_ASSERT(node != NULL);

  // Note that "foo(); foo();" (repeated forward declarations of a global function is legal C and this
  // would cause the first entry in the mangledNameMap to be over written.  We have to handle this as 
  // a special case.
  // Difficult issues will be:
  //    1) extern declarations
  //    2) repeated global function declarations
  // if (mangledNameMap.find(key) == mangledNameMap.end())

     MangledNameMapType::iterator key_iterator = mangledNameMap.find(key);
  // bool matchingMangledNameIsNew = matchingMangledNameIsNew = (key_iterator == mangledNameMap.end());
     bool matchingMangledNameIsNew = key_iterator == mangledNameMap.end();

#define IMPLEMENT_MERGE 1
#if IMPLEMENT_MERGE
     if (matchingMangledNameIsNew == true)
        {
       // Build a new entry in the map!
#if 0
          printf ("Adding unique key to map for node = %p = %s (key = %s) \n",node,node->class_name().c_str(),key.c_str());
#endif

       // Need the more uniform syntax when using hash_map
       // mangledNameMap[key] = node;
          mangledNameMap.insert(pair<string,SgNode*>(key,node));

       // Keep track of the number of IR nodes that were evaluated for mangled name matching
          numberOfNodesAddedToManagledNameMap++;
        }
       else
        {
       // This key already exists in the mangledNameMap (so we can delete any remaining occurances to it.

       // Keep track of the number of IR nodes that were evaluated for mangled name matching
          numberOfNodesAlreadyInManagledNameMap++;

#if 0
          printf ("Note: This node = %p has a key = %s that already exists in the mangledNameMap, adding to the deleteList! node = %p = %s \n",node,key.c_str(),node,node->class_name().c_str());
#endif
       // Make sure this is never this IR node
          ROSE_ASSERT(isSgTypedefSeq(node) == NULL);

          setOfNodesToDelete.insert(node);

       // Use the matchingNodeInMergedAST so that we can reset the entries in the symbol tables where required
          SgNode* matchingNodeInMergedAST = key_iterator->second;
          ROSE_ASSERT(matchingNodeInMergedAST != NULL);

       // DQ (7/12/2010): Comment this out as a test to build a restricted form of AST merge (that we can more easily debug).
#if 0
          addAssociatedNodes(node,setOfNodesToDelete,false,matchingNodeInMergedAST);
#else
#ifndef _MSC_VER
   #warning "Skipping call to addAssociatedNodes()"
#endif
		  // printf ("Skipping call to addAssociatedNodes() \n");
#endif
        }
#else
     printf ("Skipping implementation of AST merge \n");
#endif

  // printf ("In MangledNameMapTraversal::addToMap(): setOfNodesToDelete.size() = %ld \n",setOfNodesToDelete.size());
   }

void
MangledNameMapTraversal::visit ( SgNode* node)
   {
     ROSE_ASSERT(node != NULL);
  // printf ("MangledNameMapTraversal::visit: node = %s \n",node->class_name().c_str());

  // Keep track of the number of IR nodes visited
     numberOfNodes++;

  // DQ (7/4/2010): Optimizations:
  //   1) Only process each IR node once
  //   2) Only process declarations that we want to share (can we be selective?).

  // DQ (7/4/2010): To optimize performance, build a set of previously visited IR nodes
  // so that we only test IR nodes once to add them into the mangled name map. This 
  // should be especially important where the AST is sharing nodes since shared nodes 
  // are visited multiple times (as if they were not shared).
  // We need to tet if this actually optimizes the performance.
     if (setOfNodesPreviouslyVisited.find(node) == setOfNodesPreviouslyVisited.end())
        {
          setOfNodesPreviouslyVisited.insert(node);
        }
       else
        {
          return;
        }

     bool sharable = shareableIRnode(node);

  // DQ (7/10/2010): This is a test of the AST merge to investigate robustness.
#if 1

     if (sharable == true)
        {
       // Initially we will only merge things in global scope!  Then
       // we will operate on namespaces! Then I think we are done!
       // Basically we can simplify the problem by skipping merging of things in 
       // function definitions since if the function definitions are the same they 
       // will be merged directly.

       // Keep track of the number of IR nodes that were considered sharable
          numberOfNodesSharable++;

       // Here is where we get much more specific about what is sharable!
          switch (node->variantT())
             {
            // Since we abstract out the generation of the key we can simplify this code!
#if 1
            // DQ (7/11/2010): This fails for tests/CompileTests/mergeAST_tests/mergeTest_06.C, I don't know why!
               case V_SgFunctionDeclaration:
#endif
#if 1
            // DQ (7/20/2010): Testing this case...
               case V_SgVariableDeclaration:
               case V_SgClassDeclaration:

            // DQ (2/10/2007): These need to be shared (but I still see "xxxxx____Lnnnn" based names)
               case V_SgTemplateInstantiationDecl:

            // DQ (2/10/2007): These should be shared
               case V_SgPragmaDeclaration:
               case V_SgTemplateInstantiationDirectiveStatement:

               case V_SgTypedefDeclaration:
               case V_SgEnumDeclaration:
               case V_SgTemplateDeclaration:
               case V_SgUsingDeclarationStatement:
               case V_SgUsingDirectiveStatement:

            // DQ (2/3/2007): Added additional declarations that we should share
               case V_SgMemberFunctionDeclaration:
               case V_SgTemplateInstantiationFunctionDecl:
               case V_SgTemplateInstantiationMemberFunctionDecl:
#endif
#if 1
            // DQ (2/3/2007): Added support for symbols
               case V_SgClassSymbol:
               case V_SgEnumFieldSymbol:
               case V_SgEnumSymbol:
               case V_SgFunctionSymbol:
               case V_SgMemberFunctionSymbol:
               case V_SgLabelSymbol:
               case V_SgNamespaceSymbol:

            // DQ (2/10/2007): This case has been a problem previously
               case V_SgTemplateSymbol:

               case V_SgTypedefSymbol:
               case V_SgVariableSymbol:

#endif
#if 0
            // DQ (7/20/2010): These nodes are a problem to merge, but also not important to merge 
            // since they are contained within associated declarations.

            // DQ (2/20/2007): Added to list so that it could be process to build the delete list
            // statement fo the SgBasicBlock have to be considerd for the delete list. However,
            // it is still not meaningful since we don't generate a unique name for the SgBasicBlock
            // so it will never be shared.
            // case V_SgBasicBlock:

               case V_SgClassDefinition:
               case V_SgTemplateInstantiationDefn:
               case V_SgFunctionDefinition:
               case V_SgVariableDefinition:
#endif
#if 1
            // DQ (5/29/2006): Added support for types
               case V_SgFunctionType:
               case V_SgMemberFunctionType:
               case V_SgModifierType:
               case V_SgPointerType:

            // DQ (5/29/2006): Added support for types
               case V_SgClassType:
               case V_SgEnumType:
               case V_SgTypedefType:

            // DQ (2/10/2007): Add this case
               case V_SgTemplateArgument:

            // DQ (3/17/2007): These should be shared, I think!
               case V_SgPragma:
            // DQ (5/20/2006): Initialized names are held in SgVariableDeclaration IR
            // nodes or other sharable structures so we don't have to share these.
            // But we have to permit them all to be shared because all pointers to 
            // them need to be reset they all need to be reset.
               case V_SgInitializedName:
#endif
#if 1
                  {
                 // DQ (7/4/2010): To improve the performance avoid regenerating the unique name for the same IR nodes when it is revisited!

                 // Make the use of false in generateUniqueName() more clear.  We need to 
                 // distinguish between defining and non-defining declarations in the generation 
                 // of unique names for the AST merge.
                 // string key = generateUniqueName(node,false);
                    bool ignoreDifferenceBetweenDefiningAndNondefiningDeclarations = false;
                    string key = SageInterface::generateUniqueName(node,ignoreDifferenceBetweenDefiningAndNondefiningDeclarations);
                    ROSE_ASSERT(key.empty() == false);
#if 1
                    SgDeclarationStatement* declaration = isSgDeclarationStatement(node);
                    if (declaration != NULL)
                       {
                      // ROSE_ASSERT(declaration->get_symbol_from_symbol_table() != NULL);

                      // DQ (7/4/2007): Some SgDeclarationStatement IR nodes don't have a representation 
                      // in the symbol table (the list of SgInitializedName object have them instead).
                         if (isSgVariableDeclaration(declaration) == NULL && 
                             isSgVariableDefinition(declaration) == NULL && 
                             isSgUsingDeclarationStatement(declaration) == NULL && 
                             isSgUsingDirectiveStatement(declaration) == NULL && 
                             isSgTemplateInstantiationDirectiveStatement(declaration) == NULL && 
                             isSgPragmaDeclaration(declaration) == NULL)
                            {
                           // DQ (6/8/2010): Only do this test for non compiler generated variable...(e.g. __default_member_function_pointer_name 
                           // is compiler generated to handle function pointers where no member function id specified).
                              if (declaration->get_startOfConstruct()->isCompilerGenerated() == false)
                                 {
                                   SgSymbol* symbol = declaration->search_for_symbol_from_symbol_table();
                                   if (symbol == NULL)
                                      {
                                     // Output more information to support debugging!
                                        printf ("declaration = %p = %s = %s \n",declaration,declaration->class_name().c_str(),SageInterface::get_name(declaration).c_str());
                                        SgScopeStatement* scope = declaration->get_scope();
                                        ROSE_ASSERT(scope != NULL);
                                        printf ("     scope = %p = %s = %s \n",scope,scope->class_name().c_str(),SageInterface::get_name(scope).c_str());
                                        declaration->get_startOfConstruct()->display("declaration->search_for_symbol_from_symbol_table() == NULL");
                                      }
                                   ROSE_ASSERT(symbol != NULL);
                                 }
                            }
#if 0
                      // DQ (6/23/2010): Added the base type of the typedef
                         SgTypedefDeclaration* typedefDeclaration = isSgTypedefDeclaration(declaration);
                         if (typedefDeclaration != NULL)
                            {
                            }
#endif 
                       }
#endif

                    addToMap(key,node);

                 // Keep track of the number of IR nodes that were evaluated for mangled name matching
                    numberOfNodesEvaluated++;
                    break;
                  }
#endif
               default:
                  {
                 // Nothing to do here
                  }
             }
        }
#endif
   }

// MangledNameMapTraversal::MangledNameMapType getMangledNameMap()
void
generateMangledNameMap (MangledNameMapTraversal::MangledNameMapType & mangledMap, MangledNameMapTraversal::SetOfNodesType & setOfIRnodesToDelete )
   {
  // DQ (2/2/2007): Introduce tracking of performance of within AST merge
     TimingPerformance timer ("Build the STL map of mangled names:");

     MangledNameMapTraversal traversal(mangledMap,setOfIRnodesToDelete);
     traversal.traverseMemoryPool();

#if 0
     printf ("Check what the intersetion is between the merged list and the delete list before doing set_difference \n");
     displaySet(computeSetIntersection(MangledNameMapTraversal::buildSetFromMangleNameMap(mangledMap),setOfIRnodesToDelete),"intersectionSet of merged map IR nodes and delete list IR nodes");
#endif

  // Remove any elements in intermediateDeleteSet that are used in the mangledMap
  // These are the reference IR nodes that will be shared and they should not be deleted
  // this is required for processing "struct { int x; } a;" since in two files the merge of
  // the SgClassType IR nodes (there will be 4) will be built and the one is used as a 
  // reference and three are added to the delete list.
     set<SgNode*> mangledNameReferenceSet = MangledNameMapTraversal::buildSetFromMangleNameMap(mangledMap);
     setOfIRnodesToDelete = computeSetDifference(setOfIRnodesToDelete,mangledNameReferenceSet);

     if (SgProject::get_verbose() > 0)
        {
          printf ("numberOfNodes                         = %d \n",traversal.numberOfNodes);
          printf ("numberOfNodesSharable                 = %d \n",traversal.numberOfNodesSharable);
          printf ("numberOfNodesEvaluated                = %d \n",traversal.numberOfNodesEvaluated);
          printf ("numberOfNodesAddedToManagledNameMap   = %d \n",traversal.numberOfNodesAddedToManagledNameMap);
          printf ("numberOfNodesAlreadyInManagledNameMap = %d \n",traversal.numberOfNodesAlreadyInManagledNameMap);
        }
   }
