//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                       D O   N O T   E D I T                                                      //
//------------------------------------------------------------------------------------------------------------------//
//                                                                                                                  //
// This file was generated automatically from Intel PDF documentation. Its purpose is to intialize the ROSE x86     //
// assembler with information about how to encode each x86 instruction.                                             //
//                                                                                                                  //
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#include "sage3basic.h"
#include "AssemblerX86.h"

/* Generated by ./IntelAssemblyBuilder from 
 * x86-InstructionSetReference-AM.pdf 
 * x86-InstructionSetReference-NZ.pdf 
 * ExtraInstructions.txt */
void AssemblerX86::initAssemblyRules_part3() {
    AssemblerX86::InsnDefn *defn = NULL;
    defn = new InsnDefn("fninit", x86_fninit,  0x03, 0xdbe3, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-372");
    define(defn);

    //--- page 3-372 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // DF /2            FIST m16int       Valid       Valid         Store ST(0) in m16int.
    defn = new InsnDefn("fist",   x86_fist,    0x03, 0xdf, od_e2, od_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-372");
    define(defn);
    // DB /2            FIST m32int       Valid       Valid         Store ST(0) in m32int.
    defn = new InsnDefn("fist",   x86_fist,    0x03, 0xdb, od_e2, od_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-372");
    define(defn);
    // DF /3            FISTP m16int      Valid       Valid         Store ST(0) in m16int and pop
    //                                                              register stack.
    defn = new InsnDefn("fistp",  x86_fistp,   0x03, 0xdf, od_e3, od_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-372");
    define(defn);
    // DB /3            FISTP m32int      Valid       Valid         Store ST(0) in m32int and pop
    //                                                              register stack.
    defn = new InsnDefn("fistp",  x86_fistp,   0x03, 0xdb, od_e3, od_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-372");
    define(defn);
    // DF /7            FISTP m64int      Valid       Valid         Store ST(0) in m64int and pop
    //                                                              register stack.
    defn = new InsnDefn("fistp",  x86_fistp,   0x03, 0xdf, od_e7, od_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-376");
    define(defn);

    //--- page 3-376 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // DF /1           FISTTP m16int      Valid          Valid          Store ST(0) in m16int with
    //                                                                  truncation.
    defn = new InsnDefn("fisttp", x86_fisttp,  0x03, 0xdf, od_e1, od_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-376");
    define(defn);
    // DB /1           FISTTP m32int      Valid          Valid          Store ST(0) in m32int with
    //                                                                  truncation.
    defn = new InsnDefn("fisttp", x86_fisttp,  0x03, 0xdb, od_e1, od_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-376");
    define(defn);
    // DD /1           FISTTP m64int      Valid          Valid          Store ST(0) in m64int with
    //                                                                  truncation.
    defn = new InsnDefn("fisttp", x86_fisttp,  0x03, 0xdd, od_e1, od_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-379");
    define(defn);

    //--- page 3-379 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  D9 /0           FLD m32fp      Valid    Valid      Push m32fp onto the FPU register stack.
    defn = new InsnDefn("fld",    x86_fld,     0x03, 0xd9, od_e0, od_m32fp);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-379");
    define(defn);
    //  DD /0           FLD m64fp      Valid    Valid      Push m64fp onto the FPU register stack.
    defn = new InsnDefn("fld",    x86_fld,     0x03, 0xdd, od_e0, od_m64fp);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-379");
    define(defn);
    //  DB /5           FLD m80fp      Valid    Valid      Push m80fp onto the FPU register stack.
    defn = new InsnDefn("fld",    x86_fld,     0x03, 0xdb, od_e5, od_m80fp);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-379");
    define(defn);
    //  D9 C0+i         FLD ST(i)      Valid    Valid      Push ST(i) onto the FPU register stack.
    defn = new InsnDefn("fld",    x86_fld,     0x03, 0xd9c0, od_i, od_sti);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-382");
    define(defn);

    //--- page 3-382 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // D9 E8           FLD1           Valid     Valid          Push +1.0 onto the FPU register stack.
    defn = new InsnDefn("fld1",   x86_fld1,    0x03, 0xd9e8, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-382");
    define(defn);
    // D9 E9           FLDL2T         Valid     Valid          Push log210 onto the FPU register stack.
    defn = new InsnDefn("fldl2t", x86_fldl2t,  0x03, 0xd9e9, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-382");
    define(defn);
    // D9 EA           FLDL2E         Valid     Valid          Push log2e onto the FPU register stack.
    defn = new InsnDefn("fldl2e", x86_fldl2e,  0x03, 0xd9ea, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-382");
    define(defn);
    // D9 EB           FLDPI          Valid     Valid          Push  onto the FPU register stack.
    defn = new InsnDefn("fldpi",  x86_fldpi,   0x03, 0xd9eb, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-382");
    define(defn);
    // D9 EC           FLDLG2         Valid     Valid          Push log102 onto the FPU register stack.
    defn = new InsnDefn("fldlg2", x86_fldlg2,  0x03, 0xd9ec, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-382");
    define(defn);
    // D9 ED           FLDLN2         Valid     Valid          Push loge2 onto the FPU register stack.
    defn = new InsnDefn("fldln2", x86_fldln2,  0x03, 0xd9ed, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-382");
    define(defn);
    // D9 EE           FLDZ           Valid     Valid          Push +0.0 onto the FPU register stack.
    defn = new InsnDefn("fldz",   x86_fldz,    0x03, 0xd9ee, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-384");
    define(defn);

    //--- page 3-384 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // D9 /5             FLDCW m2byte     Valid    Valid      Load FPU control word from m2byte.
    defn = new InsnDefn("fldcw",  x86_fldcw,   0x03, 0xd9, od_e5, od_m2byte);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-386");
    define(defn);

    //--- page 3-386 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // D9 /4           FLDENV m14/28byte   Valid    Valid          Load FPU environment from
    //                                                             m14byte or m28byte.
    defn = new InsnDefn("fldenv", x86_fldenv,  0x03, 0xd9, od_e4, od_m14_28byte);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-389");
    define(defn);

    //--- page 3-389 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  D8 /1        FMUL m32fp           Valid    Valid      Multiply ST(0) by m32fp and store
    //                                                        result in ST(0).
    defn = new InsnDefn("fmul",   x86_fmul,    0x03, 0xd8, od_e1, od_m32fp);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-389");
    define(defn);
    //  DC /1        FMUL m64fp           Valid    Valid      Multiply ST(0) by m64fp and store
    //                                                        result in ST(0).
    defn = new InsnDefn("fmul",   x86_fmul,    0x03, 0xdc, od_e1, od_m64fp);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-389");
    define(defn);
    //  D8 C8+i      FMUL ST(0), ST(i)    Valid    Valid      Multiply ST(0) by ST(i) and store result
    //                                                        in ST(0).
    defn = new InsnDefn("fmul",   x86_fmul,    0x03, 0xd8c8, od_i, od_st0, od_sti);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-389");
    define(defn);
    //  DC C8+i      FMUL ST(i), ST(0)    Valid    Valid      Multiply ST(i) by ST(0) and store result
    //                                                        in ST(i).
    defn = new InsnDefn("fmul",   x86_fmul,    0x03, 0xdcc8, od_i, od_sti, od_st0);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-389");
    define(defn);
    //  DE C8+i      FMULP ST(i), ST(0)   Valid    Valid      Multiply ST(i) by ST(0), store result in
    //                                                        ST(i), and pop the register stack.
    defn = new InsnDefn("fmulp",  x86_fmulp,   0x03, 0xdec8, od_i, od_sti, od_st0);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-389");
    define(defn);
    //  DE C9        FMULP                Valid    Valid      Multiply ST(1) by ST(0), store result in
    //                                                        ST(1), and pop the register stack.
    defn = new InsnDefn("fmulp",  x86_fmulp,   0x03, 0xdec9, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-389");
    define(defn);
    //  DA /1        FIMUL m32int         Valid    Valid      Multiply ST(0) by m32int and store
    //                                                        result in ST(0).
    defn = new InsnDefn("fimul",  x86_fimul,   0x03, 0xda, od_e1, od_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-389");
    define(defn);
    //  DE /1        FIMUL m16int         Valid    Valid      Multiply ST(0) by m16int and store
    //                                                        result in ST(0).
    defn = new InsnDefn("fimul",  x86_fimul,   0x03, 0xde, od_e1, od_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-393");
    define(defn);

    //--- page 3-393 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  D9 D0              FNOP          Valid    Valid       No operation is performed.
    defn = new InsnDefn("fnop",   x86_fnop,    0x03, 0xd9d0, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-394");
    define(defn);

    //--- page 3-394 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // D9 F3       FPATAN        Valid     Valid         Replace ST(1) with arctan(ST(1)ST(0)) and pop
    //                                                   the register stack.
    defn = new InsnDefn("fpatan", x86_fpatan,  0x03, 0xd9f3, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-397");
    define(defn);

    //--- page 3-397 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  D9 F8        FPREM              Valid          Valid             Replace ST(0) with the remainder obtained
    //                                                                   from dividing ST(0) by ST(1).
    defn = new InsnDefn("fprem",  x86_fprem,   0x03, 0xd9f8, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-400");
    define(defn);

    //--- page 3-400 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // D9 F5           FPREM1             Valid          Valid           Replace ST(0) with the IEEE remainder
    //                                                                   obtained from dividing ST(0) by ST(1).
    defn = new InsnDefn("fprem1", x86_fprem1,  0x03, 0xd9f5, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-403");
    define(defn);

    //--- page 3-403 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  D9 F2          FPTAN            Valid        Valid          Replace ST(0) with its tangent and
    //                                                              push 1 onto the FPU stack.
    defn = new InsnDefn("fptan",  x86_fptan,   0x03, 0xd9f2, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-406");
    define(defn);

    //--- page 3-406 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // D9 FC           FRNDINT       Valid      Valid        Round ST(0) to an integer.
    defn = new InsnDefn("frndint", x86_frndint, 0x03, 0xd9fc, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-408");
    define(defn);

    //--- page 3-408 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // DD /4           FRSTOR m94/108byte Valid        Valid       Load FPU state from
    //                                                             m94byte or m108byte.
    defn = new InsnDefn("frstor", x86_frstor,  0x03, 0xdd, od_e4, od_m94_108byte);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-411");
    define(defn);

    //--- page 3-411 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  9B DD /6    FSAVE m94/108byte         Valid      Valid        Store FPU state to m94byte or
    //                                                                m108byte after checking for
    //                                                                pending unmasked floating-
    //                                                                point exceptions. Then re-
    //                                                                initialize the FPU.
    // See WAIT instead.
    // defn = new InsnDefn("fsave",  x86_fsave,   0x03, 0x9bdd, od_e6, od_m94_108byte);
    // defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-411");
    // define(defn);
    //  DD /6       FNSAVE* m94/108byte       Valid      Valid        Store FPU environment to
    //                                                                m94byte or m108byte without
    //                                                                checking for pending unmasked
    //                                                                floating-point exceptions. Then
    //                                                                re-initialize the FPU.
    defn = new InsnDefn("fnsave", x86_fnsave,  0x03, 0xdd, od_e6, od_m94_108byte);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-415");
    define(defn);

    //--- page 3-415 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  D9 FD            FSCALE         Valid        Valid            Scale ST(0) by ST(1).
    defn = new InsnDefn("fscale", x86_fscale,  0x03, 0xd9fd, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-417");
    define(defn);

    //--- page 3-417 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  D9 FE          FSIN             Valid        Valid           Replace ST(0) with its sine.
    defn = new InsnDefn("fsin",   x86_fsin,    0x03, 0xd9fe, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-419");
    define(defn);

    //--- page 3-419 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  D9 FB          FSINCOS        Valid      Valid           Compute the sine and cosine of ST(0);
    //                                                           replace ST(0) with the sine, and push the
    //                                                           cosine onto the register stack.
    defn = new InsnDefn("fsincos", x86_fsincos, 0x03, 0xd9fb, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-422");
    define(defn);

    //--- page 3-422 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // D9 FA           FSQRT         Valid     Valid         Computes square root of ST(0) and stores
    //                                                       the result in ST(0).
    defn = new InsnDefn("fsqrt",  x86_fsqrt,   0x03, 0xd9fa, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-424");
    define(defn);

    //--- page 3-424 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // D9 /2           FST m32fp     Valid    Valid        Copy ST(0) to m32fp.
    defn = new InsnDefn("fst",    x86_fst,     0x03, 0xd9, od_e2, od_m32fp);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-424");
    define(defn);
    // DD /2           FST m64fp     Valid    Valid        Copy ST(0) to m64fp.
    defn = new InsnDefn("fst",    x86_fst,     0x03, 0xdd, od_e2, od_m64fp);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-424");
    define(defn);
    // DD D0+i         FST ST(i)     Valid    Valid        Copy ST(0) to ST(i).
    defn = new InsnDefn("fst",    x86_fst,     0x03, 0xddd0, od_i, od_sti);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-424");
    define(defn);
    // D9 /3           FSTP m32fp    Valid    Valid        Copy ST(0) to m32fp and pop register
    //                                                     stack.
    defn = new InsnDefn("fstp",   x86_fstp,    0x03, 0xd9, od_e3, od_m32fp);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-424");
    define(defn);
    // DD /3           FSTP m64fp    Valid    Valid        Copy ST(0) to m64fp and pop register
    //                                                     stack.
    defn = new InsnDefn("fstp",   x86_fstp,    0x03, 0xdd, od_e3, od_m64fp);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-424");
    define(defn);
    // DB /7           FSTP m80fp    Valid    Valid        Copy ST(0) to m80fp and pop register
    //                                                     stack.
    defn = new InsnDefn("fstp",   x86_fstp,    0x03, 0xdb, od_e7, od_m80fp);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-424");
    define(defn);
    // DD D8+i         FSTP ST(i)    Valid    Valid        Copy ST(0) to ST(i) and pop register
    //                                                     stack.
    defn = new InsnDefn("fstp",   x86_fstp,    0x03, 0xddd8, od_i, od_sti);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-427");
    define(defn);

    //--- page 3-427 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  9B D9 /7      FSTCW m2byte         Valid     Valid      Store FPU control word to m2byte
    //                                                          after checking for pending unmasked
    //                                                          floating-point exceptions.
    // See WAIT instead.
    // defn = new InsnDefn("fstcw",  x86_fstcw,   0x03, 0x9bd9, od_e7, od_m2byte);
    // defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-427");
    // define(defn);
    //  D9 /7         FNSTCW* m2byte       Valid     Valid      Store FPU control word to m2byte
    //                                                          without checking for pending
    //                                                          unmasked floating-point exceptions.
    defn = new InsnDefn("fnstcw", x86_fnstcw,  0x03, 0xd9, od_e7, od_m2byte);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-430");
    define(defn);

    //--- page 3-430 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 9B D9 /6        FSTENV m14/28byte Valid        Valid         Store FPU environment to m14byte
    //                                                              or m28byte after checking for
    //                                                              pending unmasked floating-point
    //                                                              exceptions. Then mask all floating-
    //                                                              point exceptions.
    // See WAIT instead.
    // defn = new InsnDefn("fstenv", x86_fstenv,  0x03, 0x9bd9, od_e6, od_m14_28byte);
    // defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-430");
    // define(defn);
    // D9 /6           FNSTENV*             Valid     Valid         Store FPU environment to m14byte
    //                 m14/28byte                                   or m28byte without checking for
    //                                                              pending unmasked floating-point
    //                                                              exceptions. Then mask all floating-
    //                                                              point exceptions.
    defn = new InsnDefn("fnstenv", x86_fnstenv, 0x03, 0xd9, od_e6, od_m14_28byte);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-433");
    define(defn);

    //--- page 3-433 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  9B DD /7      FSTSW m2byte          Valid        Valid        Store FPU status word at
    //                                                                m2byte after checking for
    //                                                                pending unmasked floating-
    //                                                                point exceptions.
    // See WAIT instead.
    // defn = new InsnDefn("fstsw",  x86_fstsw,   0x03, 0x9bdd, od_e7, od_m2byte);
    // defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-433");
    // define(defn);
    //  9B DF E0      FSTSW AX              Valid        Valid        Store FPU status word in AX
    //                                                                register after checking for
    //                                                                pending unmasked floating-
    //                                                                point exceptions.
    // See WAIT instead.
    // defn = new InsnDefn("fstsw",  x86_fstsw,   0x03, 0x9bdfe0, od_none, od_AX);
    // defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-433");
    // define(defn);
    //  DD /7         FNSTSW* m2byte        Valid        Valid        Store FPU status word at
    //                                                                m2byte without checking for
    //                                                                pending unmasked floating-
    //                                                                point exceptions.
    defn = new InsnDefn("fnstsw", x86_fnstsw,  0x03, 0xdd, od_e7, od_m2byte);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-433");
    define(defn);
    //  DF E0         FNSTSW* AX            Valid        Valid        Store FPU status word in AX
    //                                                                register without checking for
    //                                                                pending unmasked floating-
    //                                                                point exceptions.
    defn = new InsnDefn("fnstsw", x86_fnstsw,  0x03, 0xdfe0, od_none, od_AX);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-436");
    define(defn);

    //--- page 3-436 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // D8 /4           FSUB m32fp           Valid    Valid        Subtract m32fp from ST(0)
    //                                                            and store result in ST(0).
    defn = new InsnDefn("fsub",   x86_fsub,    0x03, 0xd8, od_e4, od_m32fp);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-436");
    define(defn);
    // DC /4           FSUB m64fp           Valid    Valid        Subtract m64fp from ST(0)
    //                                                            and store result in ST(0).
    defn = new InsnDefn("fsub",   x86_fsub,    0x03, 0xdc, od_e4, od_m64fp);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-436");
    define(defn);
    // D8 E0+i         FSUB ST(0), ST(i)    Valid    Valid        Subtract ST(i) from ST(0) and
    //                                                            store result in ST(0).
    defn = new InsnDefn("fsub",   x86_fsub,    0x03, 0xd8e0, od_i, od_st0, od_sti);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-436");
    define(defn);
    // DC E8+i         FSUB ST(i), ST(0)    Valid    Valid        Subtract ST(0) from ST(i) and
    //                                                            store result in ST(i).
    defn = new InsnDefn("fsub",   x86_fsub,    0x03, 0xdce8, od_i, od_sti, od_st0);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-436");
    define(defn);
    // DE E8+i         FSUBP ST(i), ST(0)   Valid    Valid        Subtract ST(0) from ST(i),
    //                                                            store result in ST(i), and pop
    //                                                            register stack.
    defn = new InsnDefn("fsubp",  x86_fsubp,   0x03, 0xdee8, od_i, od_sti, od_st0);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-436");
    define(defn);
    // DE E9           FSUBP                Valid    Valid        Subtract ST(0) from ST(1),
    //                                                            store result in ST(1), and pop
    //                                                            register stack.
    defn = new InsnDefn("fsubp",  x86_fsubp,   0x03, 0xdee9, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-436");
    define(defn);
    // DA /4           FISUB m32int         Valid    Valid        Subtract m32int from ST(0)
    //                                                            and store result in ST(0).
    defn = new InsnDefn("fisub",  x86_fisub,   0x03, 0xda, od_e4, od_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-436");
    define(defn);
    // DE /4           FISUB m16int         Valid    Valid        Subtract m16int from ST(0)
    //                                                            and store result in ST(0).
    defn = new InsnDefn("fisub",  x86_fisub,   0x03, 0xde, od_e4, od_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-440");
    define(defn);

    //--- page 3-440 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // D8 /5           FSUBR m32fp           Valid    Valid        Subtract ST(0) from m32fp and
    //                                                             store result in ST(0).
    defn = new InsnDefn("fsubr",  x86_fsubr,   0x03, 0xd8, od_e5, od_m32fp);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-440");
    define(defn);
    // DC /5           FSUBR m64fp           Valid    Valid        Subtract ST(0) from m64fp and
    //                                                             store result in ST(0).
    defn = new InsnDefn("fsubr",  x86_fsubr,   0x03, 0xdc, od_e5, od_m64fp);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-440");
    define(defn);
    // D8 E8+i         FSUBR ST(0), ST(i)    Valid    Valid        Subtract ST(0) from ST(i) and
    //                                                             store result in ST(0).
    defn = new InsnDefn("fsubr",  x86_fsubr,   0x03, 0xd8e8, od_i, od_st0, od_sti);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-440");
    define(defn);
    // DC E0+i         FSUBR ST(i), ST(0)    Valid    Valid        Subtract ST(i) from ST(0)and
    //                                                             store result in ST(i).
    defn = new InsnDefn("fsubr",  x86_fsubr,   0x03, 0xdce0, od_i, od_sti, od_st0);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-440");
    define(defn);
    // DE E0+i         FSUBRP ST(i), ST(0)   Valid    Valid        Subtract ST(i) from ST(0), store
    //                                                             result in ST(i), and pop register
    //                                                             stack.
    defn = new InsnDefn("fsubrp", x86_fsubrp,  0x03, 0xdee0, od_i, od_sti, od_st0);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-440");
    define(defn);
    // DE E1           FSUBRP                Valid    Valid        Subtract ST(1) from ST(0),
    //                                                             store result in ST(1), and pop
    //                                                             register stack.
    defn = new InsnDefn("fsubrp", x86_fsubrp,  0x03, 0xdee1, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-440");
    define(defn);
    // DA /5           FISUBR m32int         Valid    Valid        Subtract ST(0) from m32int and
    //                                                             store result in ST(0).
    defn = new InsnDefn("fisubr", x86_fisubr,  0x03, 0xda, od_e5, od_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-440");
    define(defn);
    // DE /5           FISUBR m16int         Valid    Valid        Subtract ST(0) from m16int and
    //                                                             store result in ST(0).
    defn = new InsnDefn("fisubr", x86_fisubr,  0x03, 0xde, od_e5, od_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-444");
    define(defn);

    //--- page 3-444 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // D9 E4              FTST             Valid      Valid          Compare ST(0) with 0.0.
    defn = new InsnDefn("ftst",   x86_ftst,    0x03, 0xd9e4, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-446");
    define(defn);

    //--- page 3-446 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // DD E0+i         FUCOM ST(i)     Valid          Valid          Compare ST(0) with ST(i).
    defn = new InsnDefn("fucom",  x86_fucom,   0x03, 0xdde0, od_i, od_sti);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-446");
    define(defn);
    // DD E1           FUCOM           Valid          Valid          Compare ST(0) with ST(1).
    defn = new InsnDefn("fucom",  x86_fucom,   0x03, 0xdde1, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-446");
    define(defn);
    // DD E8+i         FUCOMP ST(i)    Valid          Valid          Compare ST(0) with ST(i) and pop
    //                                                               register stack.
    defn = new InsnDefn("fucomp", x86_fucomp,  0x03, 0xdde8, od_i, od_sti);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-446");
    define(defn);
    // DD E9           FUCOMP          Valid          Valid          Compare ST(0) with ST(1) and pop
    //                                                               register stack.
    defn = new InsnDefn("fucomp", x86_fucomp,  0x03, 0xdde9, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-446");
    define(defn);
    // DA E9           FUCOMPP         Valid          Valid          Compare ST(0) with ST(1) and pop
    //                                                               register stack twice.
    defn = new InsnDefn("fucompp", x86_fucompp, 0x03, 0xdae9, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-449");
    define(defn);

    //--- page 3-449 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //     D9 E5         FXAM             Valid          Valid       Classify value or number in ST(0).
    defn = new InsnDefn("fxam",   x86_fxam,    0x03, 0xd9e5, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-451");
    define(defn);

    //--- page 3-451 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  D9 C8+i           FXCH ST(i)     Valid    Valid          Exchange the contents of ST(0) and
    //                                                           ST(i).
    defn = new InsnDefn("fxch",   x86_fxch,    0x03, 0xd9c8, od_i, od_sti);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-451");
    define(defn);
    //  D9 C9             FXCH           Valid    Valid          Exchange the contents of ST(0) and
    //                                                           ST(1).
    defn = new InsnDefn("fxch",   x86_fxch,    0x03, 0xd9c9, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-453");
    define(defn);

    //--- page 3-453 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  0F AE /1   FXRSTOR m512byte       Valid     Valid      Restore the x87 FPU, MMX, XMM,
    //                                                         and MXCSR register state from
    //                                                         m512byte.
    defn = new InsnDefn("fxrstor", x86_fxrstor, 0x03, 0x0fae, od_e1, od_m512byte);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-456");
    define(defn);

    //--- page 3-456 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 0F AE /0        FXSAVE m512byte    Valid           Valid                Save the x87 FPU, MMX, XMM,
    //                                                                         and MXCSR register state to
    //                                                                         m512byte.
    defn = new InsnDefn("fxsave", x86_fxsave,  0x03, 0x0fae, od_e0, od_m512byte);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-467");
    define(defn);

    //--- page 3-467 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  D9 F4          FXTRACT         Valid      Valid      Separate value in ST(0) into exponent and
    //                                                       significand, store exponent in ST(0), and
    //                                                       push the significand onto the register
    //                                                       stack.
    defn = new InsnDefn("fxtract", x86_fxtract, 0x03, 0xd9f4, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-469");
    define(defn);

    //--- page 3-469 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  D9 F1         FYL2X            Valid           Valid             Replace ST(1) with (ST(1) log2ST(0))
    //                                                                   and pop the register stack.
    defn = new InsnDefn("fyl2x",  x86_fyl2x,   0x03, 0xd9f1, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-471");
    define(defn);

    //--- page 3-471 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  D9 F9           FYL2XP1         Valid           Valid               Replace ST(1) with ST(1) log2(ST(0) +
    //                                                                      1.0) and pop the register stack.
    defn = new InsnDefn("fyl2xp1", x86_fyl2xp1, 0x03, 0xd9f9, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-473");
    define(defn);

    //--- page 3-473 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  66 0F 7C /r    HADDPD xmm1,         Valid     Valid           Horizontal add packed double-
    //                 xmm2/m128                                      precision floating-point values
    //                                                                from xmm2/m128 to xmm1.
    defn = new InsnDefn("haddpd", x86_haddpd,  0x03, 0x660f7c, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-477");
    define(defn);

    //--- page 3-477 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  F2 0F 7C /r    HADDPS xmm1,        Valid         Valid             Horizontal add packed single-
    //                 xmm2/m128                                           precision floating-point values from
    //                                                                     xmm2/m128 to xmm1.
    defn = new InsnDefn("haddps", x86_haddps,  0x03, 0xf20f7c, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-481");
    define(defn);

    //--- page 3-481 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  F4           HLT           Valid       Valid          Halt
    defn = new InsnDefn("hlt",    x86_hlt,     0x03, 0xf4, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-483");
    define(defn);

    //--- page 3-483 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  66 0F 7D /r    HSUBPD xmm1,          Valid     Valid         Horizontal subtract packed double-
    //                 xmm2/m128                                     precision floating-point values from
    //                                                               xmm2/m128 to xmm1.
    defn = new InsnDefn("hsubpd", x86_hsubpd,  0x03, 0x660f7d, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-487");
    define(defn);

    //--- page 3-487 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  F2 0F 7D /r     HSUBPS xmm1,        Valid    Valid      Horizontal subtract packed single-
    //                  xmm2/m128                               precision floating-point values from
    //                                                          xmm2/m128 to xmm1.
    defn = new InsnDefn("hsubps", x86_hsubps,  0x03, 0xf20f7d, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-491");
    define(defn);

    //--- page 3-491 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  F6 /7               IDIV r/m8     Valid      Valid          Signed divide AX by r/m8, with result
    //                                                              stored in: AL  Quotient, AH
    //                                                              Remainder.
    defn = new InsnDefn("idiv",   x86_idiv,    0x03, 0xf6, od_e7, od_r_m8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-491");
    define(defn);
    //  REX + F6 /7         IDIV r/m8*    Valid      N.E.           Signed divide AX by r/m8, with result
    //                                                              stored in AL  Quotient, AH
    //                                                              Remainder.
    defn = new InsnDefn("idiv",   x86_idiv,    0x02, 0xf6, od_rex|od_e7, od_r_m8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-491");
    define(defn);
    //  F7 /7               IDIV r/m16    Valid      Valid          Signed divide DX:AX by r/m16, with
    //                                                              result stored in AX  Quotient, DX
    //                                                              Remainder.
    defn = new InsnDefn("idiv",   x86_idiv,    0x03, 0xf7, od_e7, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-491");
    define(defn);
    //  F7 /7               IDIV r/m32    Valid      Valid          Signed divide EDX:EAX by r/m32, with
    //                                                              result stored in EAX  Quotient, EDX
    //                                                               Remainder.
    defn = new InsnDefn("idiv",   x86_idiv,    0x03, 0xf7, od_e7, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-491");
    define(defn);
    //  REX.W + F7 /7       IDIV r/m64    Valid      N.E.           Signed divide RDX:RAX by r/m64, with
    //                                                              result stored in RAX  Quotient, RDX
    //                                                               Remainder.
    defn = new InsnDefn("idiv",   x86_idiv,    0x02, 0xf7, od_rexw|od_e7, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-495");
    define(defn);

    //--- page 3-495 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  F6 /5                 IMUL r/m8*         Valid    Valid       AX AL  r/m byte.
    defn = new InsnDefn("imul",   x86_imul,    0x03, 0xf6, od_e5, od_r_m8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-495");
    define(defn);
    //  F7 /5                 IMUL r/m16         Valid    Valid       DX:AX  AX  r/m word.
    defn = new InsnDefn("imul",   x86_imul,    0x03, 0xf7, od_e5, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-495");
    define(defn);
    //  F7 /5                 IMUL r/m32         Valid    Valid       EDX:EAX  EAX  r/m32.
    defn = new InsnDefn("imul",   x86_imul,    0x03, 0xf7, od_e5, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-495");
    define(defn);
    //  REX.W + F7 /5         IMUL r/m64         Valid    N.E.        RDX:RAX  RAX  r/m64.
    defn = new InsnDefn("imul",   x86_imul,    0x02, 0xf7, od_rexw|od_e5, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-495");
    define(defn);
    //  0F AF /r              IMUL r16, r/m16    Valid    Valid       word register  word register
    //                                                                r/m16.
    defn = new InsnDefn("imul",   x86_imul,    0x03, 0x0faf, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-495");
    define(defn);
    //  0F AF /r              IMUL r32, r/m32    Valid    Valid       doubleword register
    //                                                                doubleword register  r/m32.
    defn = new InsnDefn("imul",   x86_imul,    0x03, 0x0faf, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-495");
    define(defn);
    //  REX.W + 0F AF /r      IMUL r64, r/m64    Valid    N.E.        Quadword register  Quadword
    //                                                                register  r/m64.
    defn = new InsnDefn("imul",   x86_imul,    0x02, 0x0faf, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-495");
    define(defn);
    //  6B /r ib              IMUL r16, r/m16,   Valid    Valid       word register  r/m16  sign-
    //                        imm8                                    extended immediate byte.
    defn = new InsnDefn("imul",   x86_imul,    0x03, 0x6b, od_modrm|od_ib, od_r16, od_r_m16, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-495");
    define(defn);
    //  6B /r ib              IMUL r32, r/m32,   Valid    Valid       doubleword register  r/m32
    //                        imm8                                    sign-extended immediate byte.
    defn = new InsnDefn("imul",   x86_imul,    0x03, 0x6b, od_modrm|od_ib, od_r32, od_r_m32, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-495");
    define(defn);
    //  REX.W + 6B /r ib      IMUL r64, r/m64,   Valid    N.E.        Quadword register  r/m64
    //                        imm8                                    sign-extended immediate byte.
    defn = new InsnDefn("imul",   x86_imul,    0x02, 0x6b, od_rexw|od_modrm|od_ib, od_r64, od_r_m64, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-495");
    define(defn);
    //  6B /r ib              IMUL r16, imm8     Valid    Valid       word register  word register
    //                                                                sign-extended immediate byte.
    defn = new InsnDefn("imul",   x86_imul,    0x03, 0x6b, od_modrm|od_ib, od_r16, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-495");
    define(defn);
    //  6B /r ib              IMUL r32, imm8     Valid    Valid       doubleword register
    //                                                                doubleword register  sign-
    //                                                                extended immediate byte.
    defn = new InsnDefn("imul",   x86_imul,    0x03, 0x6b, od_modrm|od_ib, od_r32, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-495");
    define(defn);
    //  REX.W + 6B /r ib      IMUL r64, imm8     Valid    N.E.        Quadword register  Quadword
    //                                                                register  sign-extended
    //                                                                immediate byte.
    defn = new InsnDefn("imul",   x86_imul,    0x02, 0x6b, od_rexw|od_modrm|od_ib, od_r64, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-495");
    define(defn);
    //  69 /r iw              IMUL r16, r/m16,   Valid    Valid       word register  r/m16
    //                        imm16                                   immediate word.
    defn = new InsnDefn("imul",   x86_imul,    0x03, 0x69, od_modrm|od_iw, od_r16, od_r_m16, od_imm16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-495");
    define(defn);
    //  69 /r id              IMUL r32, r/m32,   Valid    Valid       doubleword register  r/m32
    //                        imm32                                   immediate doubleword.
    defn = new InsnDefn("imul",   x86_imul,    0x03, 0x69, od_modrm|od_id, od_r32, od_r_m32, od_imm32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-495");
    define(defn);
    //  REX.W + 69 /r id      IMUL r64, r/m64,   Valid    N.E.        Quadword register  r/m64
    //                        imm32                                   immediate doubleword.
    defn = new InsnDefn("imul",   x86_imul,    0x02, 0x69, od_rexw|od_modrm|od_id, od_r64, od_r_m64, od_imm32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-495");
    define(defn);
    //  69 /r iw              IMUL r16, imm16    Valid    Valid       word register  r/m16
    //                                                                immediate word.
    defn = new InsnDefn("imul",   x86_imul,    0x03, 0x69, od_modrm|od_iw, od_r16, od_imm16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-496");
    define(defn);
    // 69 /r id            IMUL r32, imm32     Valid      Valid         doubleword register  r/m32
    //                                                                  immediate doubleword.
    defn = new InsnDefn("imul",   x86_imul,    0x03, 0x69, od_modrm|od_id, od_r32, od_imm32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-496");
    define(defn);
    // REX.W + 69 /r id    IMUL r64, imm32     Valid      N.E.          Quadword register  r/m64
    //                                                                  immediate doubleword.
    defn = new InsnDefn("imul",   x86_imul,    0x02, 0x69, od_rexw|od_modrm|od_id, od_r64, od_imm32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-500");
    define(defn);

    //--- page 3-500 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // E4 ib       IN AL, imm8     Valid      Valid         Input byte from imm8 I/O port address into
    //                                                      AL.
    defn = new InsnDefn("in",     x86_in,      0x03, 0xe4, od_ib, od_AL, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-500");
    define(defn);
    // E5 ib       IN AX, imm8     Valid      Valid         Input word from imm8 I/O port address into
    //                                                      AX.
    defn = new InsnDefn("in",     x86_in,      0x03, 0xe5, od_ib, od_AX, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-500");
    define(defn);
    // E5 ib       IN EAX, imm8    Valid      Valid         Input dword from imm8 I/O port address into
    //                                                      EAX.
    defn = new InsnDefn("in",     x86_in,      0x03, 0xe5, od_ib, od_EAX, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-500");
    define(defn);
    // EC          IN AL,DX        Valid      Valid         Input byte from I/O port in DX into AL.
    defn = new InsnDefn("in",     x86_in,      0x03, 0xec, od_none, od_AL, od_DX);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-500");
    define(defn);
    // ED          IN AX,DX        Valid      Valid         Input word from I/O port in DX into AX.
    defn = new InsnDefn("in",     x86_in,      0x03, 0xed, od_none, od_AX, od_DX);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-500");
    define(defn);
    // ED          IN EAX,DX       Valid      Valid         Input doubleword from I/O port in DX into
    //                                                      EAX.
    defn = new InsnDefn("in",     x86_in,      0x03, 0xed, od_none, od_EAX, od_DX);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-502");
    define(defn);

    //--- page 3-502 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // FE /0              INC r/m8      Valid      Valid           Increment r/m byte by 1.
    defn = new InsnDefn("inc",    x86_inc,     0x03, 0xfe, od_e0, od_r_m8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-502");
    define(defn);
    // REX + FE /0        INC r/m8*     Valid      N.E.            Increment r/m byte by 1.
    defn = new InsnDefn("inc",    x86_inc,     0x02, 0xfe, od_rex|od_e0, od_r_m8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-502");
    define(defn);
    // FF /0              INC r/m16     Valid      Valid           Increment r/m word by 1.
    defn = new InsnDefn("inc",    x86_inc,     0x03, 0xff, od_e0, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-502");
    define(defn);
    // FF /0              INC r/m32     Valid      Valid           Increment r/m doubleword by 1.
    defn = new InsnDefn("inc",    x86_inc,     0x03, 0xff, od_e0, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-502");
    define(defn);
    // REX.W + FF /0      INC r/m64     Valid      N.E.            Increment r/m quadword by 1.
    defn = new InsnDefn("inc",    x86_inc,     0x02, 0xff, od_rexw|od_e0, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-502");
    define(defn);
    // 40+ rw**           INC r16       N.E.       Valid           Increment word register by 1.
    defn = new InsnDefn("inc",    x86_inc,     0x01, 0x40, od_rw, od_r16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-502");
    define(defn);
    // 40+ rd             INC r32       N.E.       Valid           Increment doubleword register by 1.
    defn = new InsnDefn("inc",    x86_inc,     0x01, 0x40, od_rd, od_r32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-505");
    define(defn);

    //--- page 3-505 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  6C              INS m8, DX       Valid        Valid      Input byte from I/O port specified in DX
    //                                                           into memory location specified in ES:(E)DI
    //                                                           or RDI.*
    // See INSB, INSW, or INSD instead.
    // defn = new InsnDefn("ins",    x86_ins,     0x03, 0x6c, od_none, od_m8, od_DX);
    // defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-505");
    // define(defn);
    //  6D              INS m16, DX      Valid        Valid      Input word from I/O port specified in DX
    //                                                           into memory location specified in ES:(E)DI
    //                                                           or RDI.1
    // See INSB, INSW, or INSD instead.
    // defn = new InsnDefn("ins",    x86_ins,     0x03, 0x6d, od_none, od_m16, od_DX);
    // defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-505");
    // define(defn);
    //  6D              INS m32, DX      Valid        Valid      Input doubleword from I/O port specified
    //                                                           in DX into memory location specified in
    //                                                           ES:(E)DI or RDI.1
    // See INSB, INSW, or INSD instead.
    // defn = new InsnDefn("ins",    x86_ins,     0x03, 0x6d, od_none, od_m32, od_DX);
    // defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-505");
    // define(defn);
    //  6C              INSB             Valid        Valid      Input byte from I/O port specified in DX
    //                                                           into memory location specified with
    //                                                           ES:(E)DI or RDI.1
    defn = new InsnDefn("insb",   x86_insb,    0x03, 0x6c, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-505");
    define(defn);
    //  6D              INSW             Valid        Valid      Input word from I/O port specified in DX
    //                                                           into memory location specified in ES:(E)DI
    //                                                           or RDI.1
    defn = new InsnDefn("insw",   x86_insw,    0x03, 0x6d, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-505");
    define(defn);
    //  6D              INSD             Valid        Valid      Input doubleword from I/O port specified
    //                                                           in DX into memory location specified in
    //                                                           ES:(E)DI or RDI.1
    defn = new InsnDefn("insd",   x86_insd,    0x03, 0x6d, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-509");
    define(defn);

    //--- page 3-509 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  66 0F 3A       INSERTPS xmm1,        Valid    Valid         Insert a single precision floating-point
    //  21 /r ib       xmm2/m32,                                    value selected by imm8 from xmm2/m32
    //                 imm8                                         into xmm1 at the specified destination
    //                                                              element specified by imm8 and zero out
    //                                                              destination elements in xmm1 as indicated
    //                                                              in imm8.
    defn = new InsnDefn("insertps", x86_insertps, 0x03, 0x660f3a21, od_modrm|od_ib, od_xmm, od_xmm_m32, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-512");
    define(defn);

    //--- page 3-512 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // CC              INT 3         Valid     Valid        Interrupt 3trap to debugger.
    defn = new InsnDefn("int3",   x86_int3,    0x03, 0xcc, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-512");
    define(defn);
    // CD ib           INT imm8      Valid     Valid        Interrupt vector number specified by
    //                                                      immediate byte.
    defn = new InsnDefn("int",    x86_int,     0x03, 0xcd, od_ib, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-512");
    define(defn);
    // CE              INTO          Invalid   Valid        Interrupt 4if overflow flag is 1.
    defn = new InsnDefn("into",   x86_into,    0x01, 0xce, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-527");
    define(defn);

    //--- page 3-527 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  0F 08           INVD             Valid    Valid      Flush internal caches; initiate flushing of
    //                                                       external caches.
    defn = new InsnDefn("invd",   x86_invd,    0x03, 0x0f08, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-529");
    define(defn);

    //--- page 3-529 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  0F 01/7       INVLPG m        Valid      Valid          Invalidate TLB Entry for page that
    //                                                          contains m.
    defn = new InsnDefn("invlpg", x86_invlpg,  0x03, 0x0f01, od_e7, od_m);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-531");
    define(defn);

    //--- page 3-531 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  CF              IRET          Valid    Valid         Interrupt return (16-bit operand
    //                                                       size).
    defn = new InsnDefn("iret",   x86_iret,    0x03, 0xcf, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-531");
    define(defn);
    //  CF              IRETD         Valid    Valid         Interrupt return (32-bit operand
    //                                                       size).
    defn = new InsnDefn("iret",   x86_iret,    0x03, 0xcf, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-531");
    define(defn);
    //  REX.W + CF      IRETQ         Valid    N.E.          Interrupt return (64-bit operand
    //                                                       size).
    defn = new InsnDefn("iret",   x86_iret,    0x02, 0xcf, od_rexw);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-542");
    define(defn);

    //--- page 3-542 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 77 cb           JA rel8       Valid    Valid      Jump short if above (CF=0 and ZF=0).
    defn = new InsnDefn("ja",     x86_ja,      0x03, 0x77, od_cb, od_rel8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-542");
    define(defn);
    // 73 cb           JAE rel8      Valid    Valid      Jump short if above or equal (CF=0).
    defn = new InsnDefn("jae",    x86_jae,     0x03, 0x73, od_cb, od_rel8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-542");
    define(defn);
    // 72 cb           JB rel8       Valid    Valid      Jump short if below (CF=1).
    defn = new InsnDefn("jb",     x86_jb,      0x03, 0x72, od_cb, od_rel8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-542");
    define(defn);
    // 76 cb           JBE rel8      Valid    Valid      Jump short if below or equal (CF=1 or
    //                                                   ZF=1).
    defn = new InsnDefn("jbe",    x86_jbe,     0x03, 0x76, od_cb, od_rel8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-542");
    define(defn);
    // 72 cb           JC rel8       Valid    Valid      Jump short if carry (CF=1).
    defn = new InsnDefn("jb",     x86_jb,      0x03, 0x72, od_cb, od_rel8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-542");
    define(defn);
    // E3 cb           JCXZ rel8     N.E.     Valid      Jump short if CX register is 0.
    defn = new InsnDefn("jcxz",   x86_jcxz,    0x01, 0xe3, od_cb, od_rel8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-542");
    define(defn);
    // E3 cb           JECXZ rel8    Valid    Valid      Jump short if ECX register is 0.
    defn = new InsnDefn("jecxz",  x86_jecxz,   0x03, 0xe3, od_cb, od_rel8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-542");
    define(defn);
    // E3 cb           JRCXZ rel8    Valid    N.E.       Jump short if RCX register is 0.
    defn = new InsnDefn("jrcxz",  x86_jrcxz,   0x02, 0xe3, od_cb, od_rel8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-542");
    define(defn);
    // 74 cb           JE rel8       Valid    Valid      Jump short if equal (ZF=1).
    defn = new InsnDefn("je",     x86_je,      0x03, 0x74, od_cb, od_rel8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-542");
    define(defn);
    // 7F cb           JG rel8       Valid    Valid      Jump short if greater (ZF=0 and SF=OF).
    defn = new InsnDefn("jg",     x86_jg,      0x03, 0x7f, od_cb, od_rel8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-542");
    define(defn);
    // 7D cb           JGE rel8      Valid    Valid      Jump short if greater or equal (SF=OF).
    defn = new InsnDefn("jge",    x86_jge,     0x03, 0x7d, od_cb, od_rel8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-542");
    define(defn);
    // 7C cb           JL rel8       Valid    Valid      Jump short if less (SF OF).
    defn = new InsnDefn("jl",     x86_jl,      0x03, 0x7c, od_cb, od_rel8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-542");
    define(defn);
    // 7E cb           JLE rel8      Valid    Valid      Jump short if less or equal (ZF=1 or SF
    //                                                   OF).
    defn = new InsnDefn("jle",    x86_jle,     0x03, 0x7e, od_cb, od_rel8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-542");
    define(defn);
    // 76 cb           JNA rel8      Valid    Valid      Jump short if not above (CF=1 or ZF=1).
    defn = new InsnDefn("jbe",    x86_jbe,     0x03, 0x76, od_cb, od_rel8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-542");
    define(defn);
    // 72 cb           JNAE rel8     Valid    Valid      Jump short if not above or equal (CF=1).
    defn = new InsnDefn("jb",     x86_jb,      0x03, 0x72, od_cb, od_rel8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-542");
    define(defn);
    // 73 cb           JNB rel8      Valid    Valid      Jump short if not below (CF=0).
    defn = new InsnDefn("jae",    x86_jae,     0x03, 0x73, od_cb, od_rel8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-542");
    define(defn);
    // 77 cb           JNBE rel8     Valid    Valid      Jump short if not below or equal (CF=0
    //                                                   and ZF=0).
    defn = new InsnDefn("ja",     x86_ja,      0x03, 0x77, od_cb, od_rel8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-542");
    define(defn);
    // 73 cb           JNC rel8      Valid    Valid      Jump short if not carry (CF=0).
    defn = new InsnDefn("jae",    x86_jae,     0x03, 0x73, od_cb, od_rel8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-542");
    define(defn);
    // 75 cb           JNE rel8      Valid    Valid      Jump short if not equal (ZF=0).
    defn = new InsnDefn("jne",    x86_jne,     0x03, 0x75, od_cb, od_rel8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-542");
    define(defn);
    // 7E cb           JNG rel8      Valid    Valid      Jump short if not greater (ZF=1 or SF
    //                                                   OF).
    defn = new InsnDefn("jle",    x86_jle,     0x03, 0x7e, od_cb, od_rel8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-542");
    define(defn);
    // 7C cb           JNGE rel8     Valid    Valid      Jump short if not greater or equal (SF
    //                                                   OF).
    defn = new InsnDefn("jl",     x86_jl,      0x03, 0x7c, od_cb, od_rel8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-542");
    define(defn);
    // 7D cb           JNL rel8      Valid    Valid      Jump short if not less (SF=OF).
    defn = new InsnDefn("jge",    x86_jge,     0x03, 0x7d, od_cb, od_rel8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-542");
    define(defn);
    // 7F cb           JNLE rel8     Valid    Valid      Jump short if not less or equal (ZF=0 and
    //                                                   SF=OF).
    defn = new InsnDefn("jg",     x86_jg,      0x03, 0x7f, od_cb, od_rel8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-542");
    define(defn);
    // 71 cb           JNO rel8      Valid    Valid      Jump short if not overflow (OF=0).
    defn = new InsnDefn("jno",    x86_jno,     0x03, 0x71, od_cb, od_rel8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-542");
    define(defn);
    // 7B cb           JNP rel8      Valid    Valid      Jump short if not parity (PF=0).
    defn = new InsnDefn("jpo",    x86_jpo,     0x03, 0x7b, od_cb, od_rel8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-542");
    define(defn);
    // 79 cb           JNS rel8      Valid    Valid      Jump short if not sign (SF=0).
    defn = new InsnDefn("jns",    x86_jns,     0x03, 0x79, od_cb, od_rel8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-543");
    define(defn);
    //  75 cb            JNZ rel8      Valid    Valid      Jump short if not zero (ZF=0).
    defn = new InsnDefn("jne",    x86_jne,     0x03, 0x75, od_cb, od_rel8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-543");
    define(defn);
    //  70 cb            JO rel8       Valid    Valid      Jump short if overflow (OF=1).
    defn = new InsnDefn("jo",     x86_jo,      0x03, 0x70, od_cb, od_rel8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-543");
    define(defn);
    //  7A cb            JP rel8       Valid    Valid      Jump short if parity (PF=1).
    defn = new InsnDefn("jpe",    x86_jpe,     0x03, 0x7a, od_cb, od_rel8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-543");
    define(defn);
    //  7A cb            JPE rel8      Valid    Valid      Jump short if parity even (PF=1).
    defn = new InsnDefn("jpe",    x86_jpe,     0x03, 0x7a, od_cb, od_rel8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-543");
    define(defn);
    //  7B cb            JPO rel8      Valid    Valid      Jump short if parity odd (PF=0).
    defn = new InsnDefn("jpo",    x86_jpo,     0x03, 0x7b, od_cb, od_rel8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-543");
    define(defn);
    //  78 cb            JS rel8       Valid    Valid      Jump short if sign (SF=1).
    defn = new InsnDefn("js",     x86_js,      0x03, 0x78, od_cb, od_rel8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-543");
    define(defn);
    //  74 cb            JZ rel8       Valid    Valid      Jump short if zero (ZF  1).
    defn = new InsnDefn("je",     x86_je,      0x03, 0x74, od_cb, od_rel8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-543");
    define(defn);
    //  0F 87 cw         JA rel16      N.S.     Valid      Jump near if above (CF=0 and ZF=0). Not
    //                                                     supported in 64-bit mode.
    defn = new InsnDefn("ja",     x86_ja,      0x01, 0x0f87, od_cw, od_rel16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-543");
    define(defn);
    //  0F 87 cd         JA rel32      Valid    Valid      Jump near if above (CF=0 and ZF=0).
    defn = new InsnDefn("ja",     x86_ja,      0x03, 0x0f87, od_cd, od_rel32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-543");
    define(defn);
    //  0F 83 cw         JAE rel16     N.S.     Valid      Jump near if above or equal (CF=0). Not
    //                                                     supported in 64-bit mode.
    defn = new InsnDefn("jae",    x86_jae,     0x01, 0x0f83, od_cw, od_rel16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-543");
    define(defn);
    //  0F 83 cd         JAE rel32     Valid    Valid      Jump near if above or equal (CF=0).
    defn = new InsnDefn("jae",    x86_jae,     0x03, 0x0f83, od_cd, od_rel32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-543");
    define(defn);
    //  0F 82 cw         JB rel16      N.S.     Valid      Jump near if below (CF=1). Not supported
    //                                                     in 64-bit mode.
    defn = new InsnDefn("jb",     x86_jb,      0x01, 0x0f82, od_cw, od_rel16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-543");
    define(defn);
    //  0F 82 cd         JB rel32      Valid    Valid      Jump near if below (CF=1).
    defn = new InsnDefn("jb",     x86_jb,      0x03, 0x0f82, od_cd, od_rel32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-543");
    define(defn);
    //  0F 86 cw         JBE rel16     N.S.     Valid      Jump near if below or equal (CF=1 or
    //                                                     ZF=1). Not supported in 64-bit mode.
    defn = new InsnDefn("jbe",    x86_jbe,     0x01, 0x0f86, od_cw, od_rel16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-543");
    define(defn);
    //  0F 86 cd         JBE rel32     Valid    Valid      Jump near if below or equal (CF=1 or
    //                                                     ZF=1).
    defn = new InsnDefn("jbe",    x86_jbe,     0x03, 0x0f86, od_cd, od_rel32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-543");
    define(defn);
    //  0F 82 cw         JC rel16      N.S.     Valid      Jump near if carry (CF=1). Not supported
    //                                                     in 64-bit mode.
    defn = new InsnDefn("jb",     x86_jb,      0x01, 0x0f82, od_cw, od_rel16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-543");
    define(defn);
    //  0F 82 cd         JC rel32      Valid    Valid      Jump near if carry (CF=1).
    defn = new InsnDefn("jb",     x86_jb,      0x03, 0x0f82, od_cd, od_rel32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-543");
    define(defn);
    //  0F 84 cw         JE rel16      N.S.     Valid      Jump near if equal (ZF=1). Not supported
    //                                                     in 64-bit mode.
    defn = new InsnDefn("je",     x86_je,      0x01, 0x0f84, od_cw, od_rel16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-543");
    define(defn);
    //  0F 84 cd         JE rel32      Valid    Valid      Jump near if equal (ZF=1).
    defn = new InsnDefn("je",     x86_je,      0x03, 0x0f84, od_cd, od_rel32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-543");
    define(defn);
    //  0F 84 cw         JZ rel16      N.S.     Valid      Jump near if 0 (ZF=1). Not supported in
    //                                                     64-bit mode.
    defn = new InsnDefn("je",     x86_je,      0x01, 0x0f84, od_cw, od_rel16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-543");
    define(defn);
    //  0F 84 cd         JZ rel32      Valid    Valid      Jump near if 0 (ZF=1).
    defn = new InsnDefn("je",     x86_je,      0x03, 0x0f84, od_cd, od_rel32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-543");
    define(defn);
    //  0F 8F cw         JG rel16      N.S.     Valid      Jump near if greater (ZF=0 and SF=OF).
    //                                                     Not supported in 64-bit mode.
    defn = new InsnDefn("jg",     x86_jg,      0x01, 0x0f8f, od_cw, od_rel16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-543");
    define(defn);
    //  0F 8F cd         JG rel32      Valid    Valid      Jump near if greater (ZF=0 and SF=OF).
    defn = new InsnDefn("jg",     x86_jg,      0x03, 0x0f8f, od_cd, od_rel32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-543");
    define(defn);
    //  0F 8D cw         JGE rel16     N.S.     Valid      Jump near if greater or equal (SF=OF).
    //                                                     Not supported in 64-bit mode.
    defn = new InsnDefn("jge",    x86_jge,     0x01, 0x0f8d, od_cw, od_rel16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-543");
    define(defn);
    //  0F 8D cd         JGE rel32     Valid    Valid      Jump near if greater or equal (SF=OF).
    defn = new InsnDefn("jge",    x86_jge,     0x03, 0x0f8d, od_cd, od_rel32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-544");
    define(defn);
    // 0F 8C cw        JL rel16      N.S.     Valid      Jump near if less (SF OF). Not supported
    //                                                   in 64-bit mode.
    defn = new InsnDefn("jl",     x86_jl,      0x01, 0x0f8c, od_cw, od_rel16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-544");
    define(defn);
    // 0F 8C cd        JL rel32      Valid    Valid      Jump near if less (SF OF).
    defn = new InsnDefn("jl",     x86_jl,      0x03, 0x0f8c, od_cd, od_rel32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-544");
    define(defn);
    // 0F 8E cw        JLE rel16     N.S.     Valid      Jump near if less or equal (ZF=1 or SF
    //                                                   OF). Not supported in 64-bit mode.
    defn = new InsnDefn("jle",    x86_jle,     0x01, 0x0f8e, od_cw, od_rel16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-544");
    define(defn);
    // 0F 8E cd        JLE rel32     Valid    Valid      Jump near if less or equal (ZF=1 or SF
    //                                                   OF).
    defn = new InsnDefn("jle",    x86_jle,     0x03, 0x0f8e, od_cd, od_rel32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-544");
    define(defn);
    // 0F 86 cw        JNA rel16     N.S.     Valid      Jump near if not above (CF=1 or ZF=1).
    //                                                   Not supported in 64-bit mode.
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                       D O   N O T   E D I T                                                      //
//------------------------------------------------------------------------------------------------------------------//
//                                                                                                                  //
// This file was generated automatically from Intel PDF documentation. Its purpose is to intialize the ROSE x86     //
// assembler with information about how to encode each x86 instruction.                                             //
//                                                                                                                  //
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
