// tps (01/14/2010) : Switching from rose.h to sage3.
#include "sage3basic.h"

/* Class definition for SgAsmInterpretation is generated by Rosetta and appears in src/ROSETTA/src/binaryInstruction.C */

/** Finish constructing. */
void SgAsmInterpretation::ctor() {
    ROSE_ASSERT(p_headers==NULL);
    p_headers = new SgAsmGenericHeaderList();
    p_headers->set_parent(this);
}

/** Returns a list of all files referenced by an interpretation.  It does this by looking at the file headers referenced by
 *  the interpretation, following their parent pointers up to an SgAsmGenericFile node, and returning a vector of those nodes
 *  with duplicate files removed. */
SgAsmGenericFilePtrList
SgAsmInterpretation::get_files() const
{

    const SgAsmGenericHeaderPtrList &headers = get_headers()->get_headers();
    std::set<SgAsmGenericFile*> files;
    for (size_t i=0; i<headers.size(); i++) {
        SgAsmGenericHeader *header = headers[i];
        SgAsmGenericFile *file = NULL;
        for (SgNode *node=header; node && !file; node=node->get_parent())
            file = isSgAsmGenericFile(node);
        ROSE_ASSERT(file!=NULL);
        files.insert(file);
    }

    return SgAsmGenericFilePtrList(files.begin(), files.end());
}

    
