:- template "basic".
:- include "arith.P".
:- include "io.P".

:- declare quadraticSolveNeeded(double, double, double).
:- declare quadraticSolve(double, double, double, double).

quadraticSolve(A, B, C, X) :-
  quadraticSolveNeeded(A, B, C),
  Disc is B^2 - 4.0*A*C,
  X is (-B + sqrtOne * sqrt(Disc)) / (2.0 * A).

quadraticSolveNeeded(1.0, 2.0, 0.0).
?- quadraticSolve(1.0, 2.0, 0.0, X), printnl(X).
