% vim: syn=prolog


:- template "compass".
:- include "rose.P".

:- declare anyAssignOperator(node, node, node).
anyAssignOperator(N, LHS, RHS) :- addAssignOperator(N, LHS, RHS).
anyAssignOperator(N, LHS, RHS) :- bitwiseAndAssignOperator(N, LHS, RHS).
anyAssignOperator(N, LHS, RHS) :- assignOperator(N, LHS, RHS).
anyAssignOperator(N, LHS, RHS) :- multiplyAssignOperator(N, LHS, RHS).
anyAssignOperator(N, LHS, RHS) :- bitwiseOrAssignOperator(N, LHS, RHS).
anyAssignOperator(N, LHS, RHS) :- bitwiseXorAssignOperator(N, LHS, RHS).

% node is a potential null dereference
:- declare null_deref(node, node).

% expression may have null value
:- declare maybe_null_e(node, node).

% variable may be null at target node
:- declare maybe_null_var(node, node).

% path from s to t without having v in a conditional
:- declare cfg_path_nocheck(cfgNode, cfgNode, node).

% symbol v is used in node c
:- declare varDeclUsed(node, node).

maybe_null_e(E, From) :- functionCall(From, _, _), E = From,
                         expression(From, T), pointerType(T, _).
maybe_null_e(E, From) :- maybe_null_e(S, From), castOperator(E,S).
maybe_null_e(E, From) :- maybe_null_var(E, From).
maybe_null_e(E, From) :- maybe_null_e(L, From), addOperator(E,L,_).
maybe_null_e(E, From) :- maybe_null_e(R, From), anyAssignOperator(E,_,R).

:- declare maybe_null_var_at_assignment(node, cfgNode, node).
maybe_null_var_at_assignment(VarDecl, SCfg, Assignment) :-
    maybe_null_e(Assignment, _),
    anyAssignOperator(S,L,Assignment),
    variableReference(L,V), variableSymbol(V, VarDecl),
    splitCfgNode(SCfg, S, 0).

% variable v might be null at target node, and came from assignment
maybe_null_var(T, Assignment) :-
    maybe_null_var_at_assignment(Decl, SCfg, Assignment),
    cfg_path_nocheck(SCfg, TCfg, Decl),
    splitCfgNode(TCfg, T, 0),
    variableReference(T,V), variableSymbol(V, Decl).

:- declare check(node, node).

check(T, VarDecl) :-
    ifStatement(T,C,_,_),
    varDeclUsed(VarDecl, C).

cfg_path_nocheck(S, T, VarDecl) :-
    maybe_null_var_at_assignment(VarDecl, S, _),
    S=T.

cfg_path_nocheck(S, T, Decl) :-
    cfg_path_nocheck(S, M, Decl),
    cfgNext(M, T),
    splitCfgNode(T, TNode, _),
    \+check(TNode, Decl).

varDeclUsed(Decl, C) :- variableReference(C, V), variableSymbol(V, Decl).
varDeclUsed(Decl, C) :- varDeclUsed(Decl, C2), parent(C, C2), expression(C, _).
varDeclUsed(Decl, C) :- varDeclUsed(Decl, C2), expressionStatement(C, C2).
 
null_deref(M, From) :- dereferenceOperator(M, E), maybe_null_e(E, From).
null_deref(M, From) :- arrayIndexOperator(M, E, _), maybe_null_e(E, From).
null_deref(M, From) :- arrowOperator(M, E, _), maybe_null_e(E, From).

?- null_deref(N, From),
   compassError(N, "NullDereference", "This dereference uses a pointer which might be NULL"),
   compassError(From, "NullDereference", "This is the source of the possibly NULL pointer").
