:- prim((+), 2,
        [rule([+(double), -(double)],
              [let(double, $1, "+ $0")]),
         rule([-(double), +(double)],
              [let(double, $0, "+ $1")]),
         rule([+(int), -(int)],
              [let(int, $1, "+ $0")]),
         rule([-(int), +(int)],
              [let(int, $0, "+ $1")])]).
:- prim((-), 2,
        [rule([+(double), -(double)],
              [let(double, $1, "- $0")]),
         rule([-(double), +(double)],
              [let(double, $0, "- $1")]),
         rule([+(int), -(int)],
              [let(int, $1, "- $0")]),
         rule([-(int), +(int)],
              [let(int, $0, "- $1")])]).

:- prim((+), 3,
        [rule([+(double), +(double), -(double)],
              [let(double, $2, "$0 + $1")]),
         rule([-(double), +(double), +(double)],
              [let(double, $0, "$2 - $1")]),
         rule([+(double), -(double), +(double)],
              [let(double, $1, "$2 - $0")]),
         rule([+(int), +(int), -(int)],
              [let(int, $2, "$0 + $1")]),
         rule([-(int), +(int), +(int)],
              [let(int, $0, "$2 - $1")]),
         rule([+(int), -(int), +(int)],
              [let(int, $1, "$2 - $0")])]).
:- prim((-), 3,
        [rule([+(double), +(double), -(double)],
              [let(double, $2, "$0 - $1")]),
         rule([-(double), +(double), +(double)],
              [let(double, $0, "$1 + $2")]),
         rule([+(double), -(double), +(double)],
              [let(double, $1, "$0 - $2")]),
         rule([+(int), +(int), -(int)],
              [let(int, $2, "$0 - $1")]),
         rule([-(int), +(int), +(int)],
              [let(int, $0, "$1 + $2")]),
         rule([+(int), -(int), +(int)],
              [let(int, $1, "$0 - $2")])]).

:- prim(*, 3,
        [rule([+(double), +(double), -(double)],
              [let(double, $2, "$0 * $1")]),
         rule([-(double), +(double), +(double)],
              [cond("$1 != 0."), let(double, $0, "$2 / $1")]),
         rule([+(double), -(double), +(double)],
              [cond("$0 != 0."), let(double, $1, "$2 / $0")]),
         rule([+(int), +(int), -(int)],
              [let(int, $2, "$0 * $1")]),
         rule([-(int), +(int), +(int)],
              [cond("$1 != 0."), let(int, $0, "$2 / $1"), rescan]),
         rule([+(int), -(int), +(int)],
              [cond("$0 != 0."), let(int, $1, "$2 / $0"), rescan])]).
:- prim(/, 3,
        [rule([+(double), +(double), -(double)],
              [cond("$1 != 0."), let(double, $2, "$0 / $1")]),
         rule([-(double), +(double), +(double)],
              [let(double, $0, "$1 * $2")]),
         rule([+(double), -(double), +(double)],
              [cond("$2 != 0."), let(double, $1, "$0 / $2")]),
         rule([+(int), +(int), -(int)],
              [cond("$1 != 0."),
	       let(int, $2, "$0 / $1"),
	       cond("$1 * $2 == $0")]),
         rule([-(int), +(int), +(int)],
              [let(int, $0, "$1 * $2")]),
         rule([+(int), -(int), +(int)],
              [cond("$2 != 0."),
	       let(int, $1, "$0 / $2"),
	       cond("$1 * $2 == $0")])]).
:- prim(div, 3,
        [rule([+(int), +(int), -(int)],
              [cond("$1 != 0."),
	       let(int, $2, "$0 / $1")]),
         rule([-(int), +(int), +(int)],
              [iterRange($0, "$1 * $2", "($1 + 1) * $2")])]).
:- prim(//, 3,
        [rule([+(int), +(int), -(int)],
              [cond("$1 != 0."),
	       let(int, $2, "$0 / $1")]),
         rule([-(int), +(int), +(int)],
              [iterRange($0, "$1 * $2", "($1 + 1) * $2")])]).
:- prim(mod, 3,
        [rule([+(int), +(int), -(int)],
              [cond("$1 != 0."),
	       let(int, $2, "$0 % $1")])]).
	

:- prim(^, 3,
        [rule([+(double), +(double), -(double)],
              [let(double, $2, "std::pow($0, $1)")]),
         rule([+(double), +(int), -(double)],
              [let(double, $2, "std::pow($0, $1)")]),
         rule([+(int), +(int), -(int)],
              [let(int, $2, "(int)std::pow($0, $1)")]),
         rule([-(double), +(double), +(double)],
              [cond("$1 != 0."),
               let(double, $0, "std::pow($2, 1. / $1)")]),
         rule([-(double), +(int), +(double)],
              [cond("$1 != 0."),
               let(double, $0, "std::pow($2, 1. / $1)")]),
         rule([+(double), -(double), +(double)],
              [cond("$0 > 0."),
               let(double, $1, "std::log($2) / std::log($0)")])]).

:- prim(sqrt, 2,
        [rule([+(double), -(double)],
              [cond("$0 >= 0."), let(double, $1, "std::sqrt($0)")]),
         rule([-(double), +(double)],
              [let(double, $0, "($1 * $1)")])]).

:- declare sqrtOne(double).
sqrtOne(1.0).
sqrtOne(-1.0).

:- op(500, yfx, [+, -]).
:- op(500, fx, [+, -]).
:- op(400, yfx, [*, /, //, div]).
:- op(300, xfx, mod).
:- op(200, xfy, (^)).

% Examples:

% ?- X is 1.0 + 2.0 * 3.0, printnl(X).
% ?- newline.
% ?- 5.0 is 2.0 * Y, printnl(Y).
% ?- newline.
% ?- 3.14159 is Z ^ 2, printnl(Z).
% ?- newline.
% ?- 3.14159 is 2 ^ W, printnl(W).
% ?- newline.
% ?- 3.14159 is (1.3 * 2.7) ^ W, printnl(W).
% ?- newline.
% ?- T is (5 + sqrtOne / 2.0) ^ (3 * sqrtOne), printnl(T).
% ?- newline.
