/* $Header: /home/cvs/bp/oofem/oofemlib/src/element.h,v 1.27 2003/04/06 14:08:24 bp Exp $ */
/*
 *
 *                 #####    #####   ######  ######  ###   ###
 *               ##   ##  ##   ##  ##      ##      ## ### ##
 *              ##   ##  ##   ##  ####    ####    ##  #  ##
 *             ##   ##  ##   ##  ##      ##      ##     ##
 *            ##   ##  ##   ##  ##      ##      ##     ##
 *            #####    #####   ##      ######  ##     ##
 *
 *
 *             OOFEM : Object Oriented Finite Element Code
 *
 *               Copyright (C) 1993 - 2008   Borek Patzak
 *
 *
 *
 *       Czech Technical University, Faculty of Civil Engineering,
 *   Department of Structural Mechanics, 166 29 Prague, Czech Republic
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "planestresselementevaluator.h"
#include "flotarry.h"
#include "flotmtrx.h"
#include "domain.h"
#include "node.h"
#include "element.h"
#include "gausspnt.h"
#include "gaussintegrationrule.h"
#include "matresponsemode.h"
#include "crosssection.h"
#include "structuralcrosssection.h"
#include "mathfem.h"
#include "iga.h"

namespace oofem {

void PlaneStressStructuralElementEvaluator :: computeNMatrixAt(FloatMatrix &answer, GaussPoint *gp) {
    int i, nDofMan;
    FloatArray N;
    FEInterpolation *interp = gp->giveElement()->giveInterpolation();

    interp->evalN(N, * gp->giveCoordinates(), FEIIGAElementGeometryWrapper( gp->giveElement(), gp->giveIntegrationRule()->giveKnotSpan() ), 0.0);

    if ( ( nDofMan = interp->giveNumberOfKnotSpanBasisFunctions( * ( gp->giveIntegrationRule()->giveKnotSpan() ) ) ) == 0 ) { // HUHU
        nDofMan = gp->giveElement()->giveNumberOfDofManagers();
    }

    answer.resize(2, nDofMan * 2);
    answer.zero();

    for ( i = 1; i <= nDofMan; i++ ) {
        answer.at(1, i * 2 - 1) = N.at(i);
        answer.at(2, i * 2 - 0)   = N.at(i);
    }
}

void PlaneStressStructuralElementEvaluator :: computeBMatrixAt(FloatMatrix &answer, GaussPoint *gp) {
    int i, nDofMan;
    //IntArray dofmanSubElementMask;
    FloatMatrix d;

    FEInterpolation *interp = gp->giveElement()->giveInterpolation();
    // this uses FEIInterpolation::nodes2coords - quite inefficient in this case (large num of dofmans)
    interp->evaldNdx(d, * gp->giveCoordinates(),
                     FEIIGAElementGeometryWrapper( gp->giveElement(), gp->giveIntegrationRule()->giveKnotSpan() ), 0.0);

    if ( ( nDofMan = interp->giveNumberOfKnotSpanBasisFunctions( * ( gp->giveIntegrationRule()->giveKnotSpan() ) ) ) == 0 ) { // HUHU
        nDofMan = gp->giveElement()->giveNumberOfDofManagers();
    }

    answer.resize(3, nDofMan * 2);
    answer.zero();

    for ( i = 1; i <= nDofMan; i++ ) {
        answer.at(1, i * 2 - 1) = d.at(i, 1);
        answer.at(2, i * 2 - 0)   = d.at(i, 2);

        answer.at(3, 2 * i - 1) = d.at(i, 2);
        answer.at(3, 2 * i - 0) = d.at(i, 1);
    }
}



double PlaneStressStructuralElementEvaluator :: computeVolumeAround(GaussPoint *gp) {
    double determinant, weight, thickness, volume;
    determinant = fabs( this->giveElement()->giveInterpolation()
                       ->giveTransformationJacobian(* gp->giveCoordinates(),
                                                    FEIIGAElementGeometryWrapper( this->giveElement(),
                                                                                 gp->giveIntegrationRule()->giveKnotSpan() ),
                                                    0.0) );
    weight      = gp->giveWeight();
    thickness   = this->giveElement()->giveCrossSection()->give('t');
    volume      = determinant * weight * thickness;

    return volume;
}

} // end namespace oofem
