/*  _______________________________________________________________________

    DAKOTA: Design Analysis Kit for Optimization and Terascale Applications
    Copyright (c) 2006, Sandia National Laboratories.
    This software is distributed under the GNU General Public License.
    For more information, see the README file in the top Dakota directory.
    _______________________________________________________________________ */

//- Class:        OrthogonalPolynomial
//- Description:  Class implementation of base class for orthogonal polynomials
//-               
//- Owner:        Mike Eldred, Sandia National Laboratories

#include "OrthogonalPolynomial.H"
#include "ProblemDescDB.H"


namespace Dakota {

void OrthogonalPolynomial::gauss_check(unsigned short order)
{
  // Check that Gauss points are roots of corresponding polynomial and
  // that Gauss weights sum to inner product of weight function
  Cout << "\nUnit test for Gauss points/weights for order " << order << '\n';
  const RealVector& x = gauss_points(order);
  const RealVector& w = gauss_weights(order);
  Real sum = 0.;
  for (size_t i=0; i<order; i++) {
    Cout << "Root x = " << x[i] << " Poly(x) = " << get_value(x[i], order)
	 << '\n';
    sum += w[i];
  }
  Cout << "Weights sum to " << sum << "\n\n";
}

} // namespace Dakota
