/*  _______________________________________________________________________

    DAKOTA: Design Analysis Kit for Optimization and Terascale Applications
    Copyright (c) 2006, Sandia National Laboratories.
    This software is distributed under the GNU General Public License.
    For more information, see the README file in the top Dakota directory.
    _______________________________________________________________________ */

//- Class:        CommandShell
//- Description:  Class implementation
//- Owner:        Bill Bohnhoff

#include "system_defs.h"
#include "CommandShell.H"


static const char rcsId[]="@(#) $Id: CommandShell.C 3989 2006-09-27 13:59:30Z slbrow $";


namespace Dakota {

CommandShell::CommandShell(): asynchFlag(false), suppressOutputFlag(false)  
{ }


CommandShell::~CommandShell()
{ }


CommandShell& CommandShell::operator<<(CommandShell& (*f)(CommandShell&))
{ return (*f)(*this); }


CommandShell& CommandShell::operator<<(const char* string)
{
  unixCommand += string;
  return *this;
}


/** Executes the unixCommand by passing it to system().  Appends an
    "&" if asynchFlag is set (background system call) and echos the
    unixCommand to Cout if suppressOutputFlag is not set. */
CommandShell& CommandShell::flush()
{
  if (asynchFlag)
    unixCommand += " &";

  if (!suppressOutputFlag)
    Cout << unixCommand << endl;  // output the command string for verification

#ifndef HAVE_SYSTEM
  Cout << "ERROR: attempting to use a system call on a system that does"
       << " NOT support system calls" << endl;
  abort_handler(-1);
#else
  system(unixCommand);
#endif

#ifdef HAVE_STRING_CLEAR
  unixCommand.clear();
#else
  unixCommand.resize(0);
#endif
  return *this;
}


/** global convenience function for manipulating the shell; invokes
    the class member flush function. */
CommandShell& flush(CommandShell& shell)
{
  shell.flush();
  return shell;
}

} // namespace Dakota
