# include "sandia_rules.H"

# include <cstdlib>
# include <iomanip>
# include <iostream>
# include <cmath>

int main ( );
void test01 ( );
void test02 ( );
void test03 ( );
void test04 ( );
void test05 ( );
void test06 ( );
void test07 ( );
void test08 ( );
void test09 ( );
void test10 ( );
void test11 ( );
void test12 ( );
void test13 ( );
void test14 ( );
void test15 ( );
void test16 ( );
void test17 ( );
void test18 ( );
void test19 ( );
void test20 ( );
void test21 ( );
void test22 ( );

//****************************************************************************80

int main ( )

//****************************************************************************80
//
//  Purpose:
//
//    MAIN is the main program for SANDIA_RULES_PRB.
//
//  Discussion:
//
//    SANDIA_RULES_PRB calls a set of tests for the SANDIA_RULES library.
//
//  Licensing:
//
//    This code is distributed under the GNU LGPL license. 
//
//  Modified:
//
//    19 March 2009
//
//  Author:
//
//    John Burkardt
//
{
  webbur::timestamp ( );

  std::cout << "\n";
  std::cout << "SANDIA_RULES_PRB\n";
  std::cout << "  C++ version\n";
  std::cout << "\n";
  std::cout << "  Test the routines in the SANDIA_RULES library.\n";

  test01 ( );
  test02 ( );
  test03 ( );
  test04 ( );
  test05 ( );
  test06 ( );
  test07 ( );
  test08 ( );
  test09 ( );
  test10 ( );
  test11 ( );
  test12 ( );
  test13 ( );
  test14 ( );
  test15 ( );
  test16 ( );
  test17 ( );
  test18 ( );
  test19 ( );

  test20 ( );
  test21 ( );
  test22 ( );

  std::cout << "\n";
  std::cout << "SANDIA_RULES_PRB\n";
  std::cout << "  Normal end of execution.\n";

  std::cout << "\n";
  webbur::timestamp ( );
 
  return 0;
}
//****************************************************************************80

void test01 ( )

//****************************************************************************80
//
//  Purpose:
//
//    TEST01 tests CHEBYSHEV1_COMPUTE against CHEBYSHEV1_INTEGRAL.
//
//  Licensing:
//
//    This code is distributed under the GNU LGPL license. 
//
//  Modified:
//
//    19 March 2009
//
//  Author:
//
//    John Burkardt
//
{
  double alpha = 0.0;
  double beta = 0.0;
  double error;
  double estimate;
  double exact;
  double *f;
  int i;
  int n;
  int order;
  int order_max = 10;
  double *w;
  double *x;

  std::cout << "\n";
  std::cout << "TEST01\n";
  std::cout << "  CHEBYSHEV1_COMPUTE computes a Gauss-Chebyshev type 1 rule\n";
  std::cout << "  which is appropriate for integrands of the form\n";
  std::cout << "    Integral ( -1 <= x <= +1 ) f(x) / sqrt ( 1 - x^2 ) dx.\n";
  std::cout << "\n";
  std::cout << "  CHEBYSHEV1_INTEGRAL determines the exact value of\n";
  std::cout << "  this integal when f(x) = x^n.\n";
  std::cout << "\n";
  std::cout << "  A rule of order ORDER should be exact for monomials X^N\n";
  std::cout << "  up to N = 2*ORDER-1\n";
  std::cout << "\n";
  std::cout << "  In the following table, for each order, the LAST THREE estimates\n";
  std::cout << "  are made on monomials that exceed the exactness limit for the rule.\n";
  std::cout << "\n";
  std::cout << "     Order         N       Estimate       Exact            Error\n";

  for ( order = 1; order <= order_max; order++ )
  {
    std::cout << "\n";

    f = new double[order];
    w = new double[order];
    x = new double[order];

    webbur::chebyshev1_compute ( order, alpha, beta, x, w );

    for ( n = 0; n <= 2 * order + 2; n = n + 1 )
    {
      exact = webbur::chebyshev1_integral ( n );

      if ( n == 0 )
      {
        for ( i = 0; i < order; i++ )
        {
          f[i] = 1.0;
        }
      }
      else
      {
        for ( i = 0; i < order; i++ )
        {
          f[i] = std::pow ( x[i], n );
        }
      }
      estimate = 0.0;
      for ( i = 0; i < order; i++ )
      {
        estimate = estimate + w[i] * f[i];
      }

      error = webbur::r8_abs ( exact - estimate );
  
      std::cout << "  " << std::setw(8)  << order
           << "  " << std::setw(8)  << n
           << "  " << std::setprecision(6) << std::setw(14) << estimate
           << "  " << std::setprecision(6) << std::setw(14) << exact
           << "  " << std::setprecision(6) << std::setw(14) << error << "\n";
    }
    delete [] f;
    delete [] w;
    delete [] x;
  }
  return;
}
//****************************************************************************80

void test02 ( )

//****************************************************************************80
//
//  Purpose:
//
//    TEST02 tests CHEBYSHEV1_COMPUTE.
//
//  Licensing:
//
//    This code is distributed under the GNU LGPL license. 
//
//  Modified:
//
//    19 March 2009
//
//  Author:
//
//    John Burkardt
//
{
  double alpha = 0.0;
  double beta = 0.0;
  int i;
  int order;
  int order_max = 10;
  int test;
  double *w;
  double *x;

  std::cout << "\n";
  std::cout << "TEST02\n";
  std::cout << "  CHEBYSHEV1_COMPUTE computes a Gauss-Chebyshev type 1 rule\n";
  std::cout << "  which is appropriate for integrands of the form\n";
  std::cout << "    Integral ( -1 <= x <= +1 ) f(x) / sqrt(1-x^2) dx.\n";

  for ( order = 1; order <= order_max; order++ )
  {
    std::cout << "\n";
    std::cout << "  Order = " << order << "\n";

    w = new double[order];
    x = new double[order];

    webbur::chebyshev1_compute ( order, alpha, beta, x, w );
 
    for ( i = 0; i < order; i =i + 1 )
    {
      std::cout << "  " << std::setw(8) << i
           << "  " << std::setprecision(16) << std::setw(24) << x[i]
           << "  " << std::setprecision(16) << std::setw(24) << w[i] << "\n";
    }
    delete [] w;
    delete [] x;
  }
 
  return;
}
//****************************************************************************80

void test03 ( )

//****************************************************************************80
//
//  Purpose:
//
//    TEST03 tests CHEBYSHEV2_COMPUTE against CHEBYSHEV2_INTEGRAL.
//
//  Licensing:
//
//    This code is distributed under the GNU LGPL license. 
//
//  Modified:
//
//    19 March 2009
//
//  Author:
//
//    John Burkardt
//
{
  double alpha = 0.0;
  double beta = 0.0;
  double error;
  double estimate;
  double exact;
  double *f;
  int i;
  int n;
  int order;
  int order_max = 10;
  double *w;
  double *x;

  std::cout << "\n";
  std::cout << "TEST03\n";
  std::cout << "  CHEBYSHEV2_COMPUTE computes a Gauss-Chebyshev type 2 rule\n";
  std::cout << "  which is appropriate for integrands of the form\n";
  std::cout << "    Integral ( -1 <= x <= +1 ) f(x) * sqrt ( 1 - x^2 ) dx.\n";
  std::cout << "\n";
  std::cout << "  CHEBYSHEV2_INTEGRAL determines the exact value of\n";
  std::cout << "  this integal when f(x) = x^n.\n";
  std::cout << "\n";
  std::cout << "  A rule of order ORDER should be exact for monomials X^N\n";
  std::cout << "  up to N = 2*ORDER-1\n";
  std::cout << "\n";
  std::cout << "  In the following table, for each order, the LAST THREE estimates\n";
  std::cout << "  are made on monomials that exceed the exactness limit for the rule.\n";
  std::cout << "\n";
  std::cout << "     Order         N       Estimate       Exact            Error\n";

  for ( order = 1; order <= order_max; order++ )
  {
    std::cout << "\n";

    f = new double[order];
    w = new double[order];
    x = new double[order];

    webbur::chebyshev2_compute ( order, alpha, beta, x, w );

    for ( n = 0; n <= 2 * order + 2; n = n + 1 )
    {
      exact = webbur::chebyshev2_integral ( n );

      if ( n == 0 )
      {
        for ( i = 0; i < order; i++ )
        {
          f[i] = 1.0;
        }
      }
      else
      {
        for ( i = 0; i < order; i++ )
        {
          f[i] = std::pow ( x[i], n );
        }
      }
      estimate = 0.0;
      for ( i = 0; i < order; i++ )
      {
        estimate = estimate + w[i] * f[i];
      }

      error = webbur::r8_abs ( exact - estimate );
  
      std::cout << "  " << std::setw(8)  << order
           << "  " << std::setw(8)  << n
           << "  " << std::setprecision(6) << std::setw(14) << estimate
           << "  " << std::setprecision(6) << std::setw(14) << exact
           << "  " << std::setprecision(6) << std::setw(14) << error << "\n";
    }
    delete [] f;
    delete [] w;
    delete [] x;
  }
  return;
}
//****************************************************************************80

void test04 ( )

//****************************************************************************80
//
//  Purpose:
//
//    TEST04 tests CHEBYSHEV2_COMPUTE.
//
//  Licensing:
//
//    This code is distributed under the GNU LGPL license. 
//
//  Modified:
//
//    19 March 2009
//
//  Author:
//
//    John Burkardt
//
{
  double alpha = 0.0;
  double beta = 0.0;
  int i;
  int order;
  int order_max = 10;
  int test;
  double *w;
  double *x;

  std::cout << "\n";
  std::cout << "TEST04\n";
  std::cout << "  CHEBYSHEV2_COMPUTE computes a Gauss-Chebyshev type 2 rule\n";
  std::cout << "  which is appropriate for integrands of the form\n";
  std::cout << "    Integral ( -1 <= x <= +1 ) f(x) * sqrt(1-x^2) dx.\n";

  for ( order = 1; order <= order_max; order++ )
  {
    std::cout << "\n";
    std::cout << "  Order = " << order << "\n";

    w = new double[order];
    x = new double[order];

    webbur::chebyshev2_compute ( order, alpha, beta, x, w );
 
    for ( i = 0; i < order; i =i + 1 )
    {
      std::cout << "  " << std::setw(8) << i
           << "  " << std::setprecision(16) << std::setw(24) << x[i]
           << "  " << std::setprecision(16) << std::setw(24) << w[i] << "\n";
    }
    delete [] w;
    delete [] x;
  }
 
  return;
}
//****************************************************************************80

void test05 ( )

//****************************************************************************80
//
//  Purpose:
//
//    TEST05 tests CLENSHAW_CURTIS_COMPUTE against LEGENDRE_INTEGRAL.
//
//  Licensing:
//
//    This code is distributed under the GNU LGPL license. 
//
//  Modified:
//
//    19 March 2009
//
//  Author:
//
//    John Burkardt
//
{
  double alpha = 0.0;
  double beta = 0.0;
  double error;
  double estimate;
  double exact;
  double *f;
  int i;
  int n;
  int n_hi;
  int order;
  int order_max = 10;
  double *w;
  double *x;

  std::cout << "\n";
  std::cout << "TEST05\n";
  std::cout << "  CLENSHAW_CURTIS_COMPUTE computes a Clenshaw Curtis rule\n";
  std::cout << "  which is appropriate for integrands of the form\n";
  std::cout << "    Integral ( -1 <= x <= +1 ) f(x)  dx.\n";
  std::cout << "\n";
  std::cout << "  LEGENDRE_INTEGRAL determines the exact value of\n";
  std::cout << "  this integal when f(x) = x^n.\n";
  std::cout << "\n";
  std::cout << "  A rule of order ORDER should be exact for monomials X^N up to\n";
  std::cout << "    N = ORDER+1 if ORDER is odd, or\n";
  std::cout << "    N = ORDER   if ORDER is even\n";
  std::cout << "\n";
  std::cout << "  In the following table, for each order, the LAST THREE estimates\n";
  std::cout << "  are made on monomials that exceed the exactness limit for the rule.\n";
  std::cout << "\n";
  std::cout << "     Order         N       Estimate       Exact            Error\n";

  for ( order = 1; order <= order_max; order++ )
  {
    std::cout << "\n";

    f = new double[order];
    w = new double[order];
    x = new double[order];

    webbur::clenshaw_curtis_compute ( order, alpha, beta, x, w );

    if ( ( order % 2 ) == 0 )
    {
      n_hi = order + 2;
    }
    else
    {
      n_hi = order + 3;
    }

    for ( n = 0; n <= n_hi; n = n + 1 )
    {
      exact = webbur::legendre_integral ( n );

      if ( n == 0 )
      {
        for ( i = 0; i < order; i++ )
        {
          f[i] = 1.0;
        }
      }
      else
      {
        for ( i = 0; i < order; i++ )
        {
          f[i] = std::pow ( x[i], n );
        }
      }
      estimate = 0.0;
      for ( i = 0; i < order; i++ )
      {
        estimate = estimate + w[i] * f[i];
      }

      error = webbur::r8_abs ( exact - estimate );
  
      std::cout << "  " << std::setw(8)  << order
           << "  " << std::setw(8)  << n
           << "  " << std::setprecision(6) << std::setw(14) << estimate
           << "  " << std::setprecision(6) << std::setw(14) << exact
           << "  " << std::setprecision(6) << std::setw(14) << error << "\n";
    }
    delete [] f;
    delete [] w;
    delete [] x;
  }
  return;
}
//****************************************************************************80

void test06 ( )

//****************************************************************************80
//
//  Purpose:
//
//    TEST06 tests CLENSHAW_CURTIS_COMPUTE.
//
//  Licensing:
//
//    This code is distributed under the GNU LGPL license. 
//
//  Modified:
//
//    19 March 2009
//
//  Author:
//
//    John Burkardt
//
{
  double alpha = 0.0;
  double beta = 0.0;
  int i;
  int order;
  int order_max = 10;
  int test;
  double *w;
  double *x;

  std::cout << "\n";
  std::cout << "TEST06\n";
  std::cout << "  CLENSHAW_CURTIS_COMPUTE computes a Clenshaw Curtis rule\n";
  std::cout << "  which is appropriate for integrands of the form\n";
  std::cout << "    Integral ( -1 <= x <= +1 ) f(x) dx.\n";

  for ( order = 1; order <= order_max; order++ )
  {
    std::cout << "\n";
    std::cout << "  Order = " << order << "\n";

    w = new double[order];
    x = new double[order];

    webbur::clenshaw_curtis_compute ( order, alpha, beta, x, w );
 
    for ( i = 0; i < order; i =i + 1 )
    {
      std::cout << "  " << std::setw(8) << i
           << "  " << std::setprecision(16) << std::setw(24) << x[i]
           << "  " << std::setprecision(16) << std::setw(24) << w[i] << "\n";
    }
    delete [] w;
    delete [] x;
  }
 
  return;
}
//****************************************************************************80

void test07 ( )

//****************************************************************************80
//
//  Purpose:
//
//    TEST07 tests FEJER2_COMPUTE against LEGENDRE_INTEGRAL.
//
//  Licensing:
//
//    This code is distributed under the GNU LGPL license. 
//
//  Modified:
//
//    19 March 2009
//
//  Author:
//
//    John Burkardt
//
{
  double alpha = 0.0;
  double beta = 0.0;
  double error;
  double estimate;
  double exact;
  double *f;
  int i;
  int n;
  int n_hi;
  int order;
  int order_max = 10;
  double *w;
  double *x;

  std::cout << "\n";
  std::cout << "TEST07\n";
  std::cout << "  FEJER2_COMPUTE computes a Fejer Type 2 rule\n";
  std::cout << "  which is appropriate for integrands of the form\n";
  std::cout << "    Integral ( -1 <= x <= +1 ) f(x)  dx.\n";
  std::cout << "\n";
  std::cout << "  LEGENDRE_INTEGRAL determines the exact value of\n";
  std::cout << "  this integal when f(x) = x^n.\n";
  std::cout << "\n";
  std::cout << "  A rule of order ORDER should be exact for monomials X^N up to\n";
  std::cout << "    N = ORDER+1 if ORDER is odd, or\n";
  std::cout << "    N = ORDER   if ORDER is even\n";
  std::cout << "\n";
  std::cout << "  In the following table, for each order, the LAST THREE estimates\n";
  std::cout << "  are made on monomials that exceed the exactness limit for the rule.\n";
  std::cout << "\n";
  std::cout << "     Order         N       Estimate       Exact            Error\n";

  for ( order = 1; order <= order_max; order++ )
  {
    std::cout << "\n";

    f = new double[order];
    w = new double[order];
    x = new double[order];

    webbur::fejer2_compute ( order, alpha, beta, x, w );

    if ( ( order % 2 ) == 0 )
    {
      n_hi = order + 2;
    }
    else
    {
      n_hi = order + 3;
    }

    for ( n = 0; n <= n_hi; n = n + 1 )
    {
      exact = webbur::legendre_integral ( n );

      if ( n == 0 )
      {
        for ( i = 0; i < order; i++ )
        {
          f[i] = 1.0;
        }
      }
      else
      {
        for ( i = 0; i < order; i++ )
        {
          f[i] = std::pow ( x[i], n );
        }
      }
      estimate = 0.0;
      for ( i = 0; i < order; i++ )
      {
        estimate = estimate + w[i] * f[i];
      }

      error = webbur::r8_abs ( exact - estimate );
  
      std::cout << "  " << std::setw(8)  << order
           << "  " << std::setw(8)  << n
           << "  " << std::setprecision(6) << std::setw(14) << estimate
           << "  " << std::setprecision(6) << std::setw(14) << exact
           << "  " << std::setprecision(6) << std::setw(14) << error << "\n";
    }
    delete [] f;
    delete [] w;
    delete [] x;
  }
  return;
}
//****************************************************************************80

void test08 ( )

//****************************************************************************80
//
//  Purpose:
//
//    TEST08 tests FEJER2_COMPUTE.
//
//  Licensing:
//
//    This code is distributed under the GNU LGPL license. 
//
//  Modified:
//
//    19 March 2009
//
//  Author:
//
//    John Burkardt
//
{
  double alpha = 0.0;
  double beta = 0.0;
  int i;
  int order;
  int order_max = 10;
  int test;
  double *w;
  double *x;

  std::cout << "\n";
  std::cout << "TEST08\n";
  std::cout << "  FEJER2_COMPUTE computes a Fejer Type 2 rule\n";
  std::cout << "  which is appropriate for integrands of the form\n";
  std::cout << "    Integral ( -1 <= x <= +1 ) f(x) dx.\n";

  for ( order = 1; order <= order_max; order++ )
  {
    std::cout << "\n";
    std::cout << "  Order = " << order << "\n";

    w = new double[order];
    x = new double[order];

    webbur::fejer2_compute ( order, alpha, beta, x, w );
 
    for ( i = 0; i < order; i =i + 1 )
    {
      std::cout << "  " << std::setw(8) << i
           << "  " << std::setprecision(16) << std::setw(24) << x[i]
           << "  " << std::setprecision(16) << std::setw(24) << w[i] << "\n";
    }
    delete [] w;
    delete [] x;
  }
 
  return;
}
//****************************************************************************80

void test09 ( )

//****************************************************************************80
//
//  Purpose:
//
//    TEST09 tests GEGENBAUER_COMPUTE against GEGENBAUER_INTEGRAL.
//
//  Licensing:
//
//    This code is distributed under the GNU LGPL license. 
//
//  Modified:
//
//    19 March 2009
//
//  Author:
//
//    John Burkardt
//
{
# define TEST_NUM 3

  double alpha;
  double alpha_test[TEST_NUM] = { 0.5, 1.0, 2.5 };
  double beta = 0.0;
  double error;
  double estimate;
  double exact;
  double *f;
  int i;
  int n;
  int order;
  int order_max = 10;
  int test;
  double *w;
  double *x;

  std::cout << "\n";
  std::cout << "TEST09\n";
  std::cout << "  GEGENBAUER_COMPUTE computes a generalized Gauss-Gegenbauer rule\n";
  std::cout << "  which is appropriate for integrands of the form\n";
  std::cout << "    Integral ( 0 <= x < +oo ) f(x) (1-x^2)^alpha dx.\n";
  std::cout << "\n";
  std::cout << "  GEGENBAUER_INTEGRAL determines the exact value of\n";
  std::cout << "  this integal when f(x) = x^n.\n";
  std::cout << "\n";
  std::cout << "  A rule of order ORDER should be exact for monomials X^N\n";
  std::cout << "  up to N = 2*ORDER-1\n";
  std::cout << "\n";
  std::cout << "  In the following table, for each order, the LAST THREE estimates\n";
  std::cout << "  are made on monomials that exceed the exactness limit for the rule.\n";
  std::cout << "\n";
  std::cout << "     Order         N       Alpha           Estimate       Exact            Error\n";

  for ( test = 0; test < TEST_NUM; test++ )
  {
    alpha = alpha_test[test];

    for ( order = 1; order <= order_max; order++ )
    {
      std::cout << "\n";

      f = new double[order];
      w = new double[order];
      x = new double[order];

      webbur::gegenbauer_compute ( order, alpha, beta, x, w );
 
      for ( n = 0; n <= 2 * order + 2; n = n + 1 )
      {
        exact = webbur::gegenbauer_integral ( n, alpha );

        if ( n == 0 )
        {
          for ( i = 0; i < order; i++ )
          {
            f[i] = 1.0;
          }
        }
        else
        {
          for ( i = 0; i < order; i++ )
          {
            f[i] = std::pow ( x[i], n );
          }
        }
        estimate = 0.0;
        for ( i = 0; i < order; i++ )
        {
          estimate = estimate + w[i] * f[i];
        }

        error = webbur::r8_abs ( exact - estimate );
  
        std::cout << "  " << std::setw(8)  << order
             << "  " << std::setw(8)  << n
             << "  " << std::setw(14) << alpha
             << "  " << std::setprecision(6) << std::setw(14) << estimate
             << "  " << std::setprecision(6) << std::setw(14) << exact
             << "  " << std::setprecision(6) << std::setw(14) << error << "\n";
      }
      delete [] f;
      delete [] w;
      delete [] x;
    }
  }
 
  return;
# undef TEST_NUM
}
//****************************************************************************80

void test10 ( )

//****************************************************************************80
//
//  Purpose:
//
//    TEST10 tests GEGENBAUER_COMPUTE.
//
//  Licensing:
//
//    This code is distributed under the GNU LGPL license. 
//
//  Modified:
//
//    19 March 2009
//
//  Author:
//
//    John Burkardt
//
{
# define TEST_NUM 3

  double alpha;
  double alpha_test[TEST_NUM] = { 0.5, 1.0, 2.5 };
  double beta = 0.0;
  int i;
  int order;
  int order_max = 10;
  int test;
  double *w;
  double *x;

  std::cout << "\n";
  std::cout << "TEST10\n";
  std::cout << "  GEGENBAUER_COMPUTE computes a generalized Gauss-Gegenbauer rule\n";
  std::cout << "  which is appropriate for integrands of the form\n";
  std::cout << "    Integral ( -1 <= x <= +1 ) f(x) (1-x^2)^alpha dx.\n";

  for ( test = 0; test < TEST_NUM; test++ )
  {
    alpha = alpha_test[test];

    for ( order = 1; order <= order_max; order++ )
    {
      std::cout << "\n";
      std::cout << "  Order = " << order << "\n";
      std::cout << "  ALPHA = " << alpha << "\n";

      w = new double[order];
      x = new double[order];

      webbur::gegenbauer_compute ( order, alpha, beta, x, w );
 
      for ( i = 0; i < order; i =i + 1 )
      {
        std::cout << "  " << std::setw(8) << i
             << "  " << std::setprecision(16) << std::setw(24) << x[i]
             << "  " << std::setprecision(16) << std::setw(24) << w[i] << "\n";
      }
      delete [] w;
      delete [] x;
    }
  }
 
  return;
# undef TEST_NUM
}
//****************************************************************************80

void test11 ( )

//****************************************************************************80
//
//  Purpose:
//
//    TEST11 tests GEN_HERMITE_COMPUTE against GEN_HERMITE_INTEGRAL.
//
//  Licensing:
//
//    This code is distributed under the GNU LGPL license. 
//
//  Modified:
//
//    19 March 2009
//
//  Author:
//
//    John Burkardt
//
{
# define TEST_NUM 3

  double alpha;
  double alpha_test[TEST_NUM] = { 0.5, 1.0, 2.5 };
  double beta = 0.0;
  double error;
  double estimate;
  double exact;
  double *f;
  int i;
  int n;
  int order;
  int order_max = 10;
  int test;
  double *w;
  double *x;

  std::cout << "\n";
  std::cout << "TEST11\n";
  std::cout << "  GEN_HERMITE_COMPUTE computes a generalized Gauss-Hermite rule\n";
  std::cout << "  which is appropriate for integrands of the form\n";
  std::cout << "    Integral ( -oo < x < +oo ) f(x) x^alpha exp(-x*x) dx.\n";
  std::cout << "\n";
  std::cout << "  GEN_HERMITE_INTEGRAL determines the exact value of\n";
  std::cout << "  this integal when f(x) = x^n.\n";
  std::cout << "\n";
  std::cout << "  A rule of order ORDER should be exact for monomials X^N\n";
  std::cout << "  up to N = 2*ORDER-1\n";
  std::cout << "\n";
  std::cout << "  In the following table, for each order, the LAST THREE estimates\n";
  std::cout << "  are made on monomials that exceed the exactness limit for the rule.\n";
  std::cout << "\n";
  std::cout << "     Order         N       Alpha           Estimate       Exact            Error\n";

  for ( test = 0; test < TEST_NUM; test++ )
  {
    alpha = alpha_test[test];

    for ( order = 1; order <= order_max; order++ )
    {
      std::cout << "\n";

      f = new double[order];
      w = new double[order];
      x = new double[order];

      webbur::gen_hermite_compute ( order, alpha, beta, x, w );
 
      for ( n = 0; n <= 2 * order + 2; n = n + 1 )
      {
        exact = webbur::gen_hermite_integral ( n, alpha );

        if ( n == 0 )
        {
          for ( i = 0; i < order; i++ )
          {
            f[i] = 1.0;
          }
        }
        else
        {
          for ( i = 0; i < order; i++ )
          {
            f[i] = std::pow ( x[i], n );
          }
        }
        estimate = 0.0;
        for ( i = 0; i < order; i++ )
        {
          estimate = estimate + w[i] * f[i];
        }

        error = webbur::r8_abs ( exact - estimate );
  
        std::cout << "  " << std::setw(8)  << order
             << "  " << std::setw(8)  << n
             << "  " << std::setprecision(6) << std::setw(14) << alpha
             << "  " << std::setprecision(6) << std::setw(14) << estimate
             << "  " << std::setprecision(6) << std::setw(14) << exact
             << "  " << std::setprecision(6) << std::setw(14) << error << "\n";
      }
      delete [] f;
      delete [] w;
      delete [] x;
    }
  }
 
  return;
# undef TEST_NUM
}
//****************************************************************************80

void test12 ( )

//****************************************************************************80
//
//  Purpose:
//
//    TEST12 tests GEN_HERMITE_COMPUTE.
//
//  Licensing:
//
//    This code is distributed under the GNU LGPL license. 
//
//  Modified:
//
//    19 March 2009
//
//  Author:
//
//    John Burkardt
//
{
# define TEST_NUM 3

  double alpha;
  double alpha_test[TEST_NUM] = { 0.5, 1.0, 2.5 };
  double beta = 0.0;
  int i;
  int order;
  int order_max = 10;
  int test;
  double *w;
  double *x;

  std::cout << "\n";
  std::cout << "TEST12\n";
  std::cout << "  GEN_HERMITE_COMPUTE computes a generalized Gauss-Hermite rule\n";
  std::cout << "  which is appropriate for integrands of the form\n";
  std::cout << "    Integral ( -oo < x < +oo ) f(x) x^alpha exp(-x*x) dx.\n";

  for ( test = 0; test < TEST_NUM; test++ )
  {
    alpha = alpha_test[test];

    for ( order = 1; order <= order_max; order++ )
    {
      std::cout << "\n";
      std::cout << "  Order = " << order << "\n";
      std::cout << "  ALPHA = " << alpha << "\n";

      w = new double[order];
      x = new double[order];

      webbur::gen_hermite_compute ( order, alpha, beta, x, w );
 
      for ( i = 0; i < order; i =i + 1 )
      {
        std::cout << "  " << std::setw(8) << i
             << "  " << std::setprecision(16) << std::setw(24) << x[i]
             << "  " << std::setprecision(16) << std::setw(24) << w[i] << "\n";
      }
      delete [] w;
      delete [] x;
    }
  }
 
  return;
# undef TEST_NUM
}
//****************************************************************************80

void test13 ( )

//****************************************************************************80
//
//  Purpose:
//
//    TEST13 tests GEN_LAGUERRE_COMPUTE against GEN_LAGUERRE_INTEGRAL.
//
//  Licensing:
//
//    This code is distributed under the GNU LGPL license. 
//
//  Modified:
//
//    19 March 2009
//
//  Author:
//
//    John Burkardt
//
{
# define TEST_NUM 3

  double alpha;
  double alpha_test[TEST_NUM] = { 0.5, 1.0, 2.5 };
  double beta = 0.0;
  double error;
  double estimate;
  double exact;
  double *f;
  int i;
  int n;
  int order;
  int order_max = 10;
  int test;
  double *w;
  double *x;

  std::cout << "\n";
  std::cout << "TEST13\n";
  std::cout << "  GEN_LAGUERRE_COMPUTE computes a generalized Gauss-Laguerre rule\n";
  std::cout << "  which is appropriate for integrands of the form\n";
  std::cout << "    Integral ( 0 <= x < +oo ) f(x) x^alpha exp(-x) dx.\n";
  std::cout << "\n";
  std::cout << "  GEN_LAGUERRE_INTEGRAL determines the exact value of\n";
  std::cout << "  this integal when f(x) = x^n.\n";
  std::cout << "\n";
  std::cout << "  A rule of order ORDER should be exact for monomials X^N\n";
  std::cout << "  up to N = 2*ORDER-1\n";
  std::cout << "\n";
  std::cout << "  In the following table, for each order, the LAST THREE estimates\n";
  std::cout << "  are made on monomials that exceed the exactness limit for the rule.\n";
  std::cout << "\n";
  std::cout << "     Order         N       Alpha           Estimate       Exact            Error\n";

  for ( test = 0; test < TEST_NUM; test++ )
  {
    alpha = alpha_test[test];

    for ( order = 1; order <= order_max; order++ )
    {
      std::cout << "\n";

      f = new double[order];
      w = new double[order];
      x = new double[order];

      webbur::gen_laguerre_compute ( order, alpha, beta, x, w );
 
      for ( n = 0; n <= 2 * order + 2; n = n + 1 )
      {
        exact = webbur::gen_laguerre_integral ( n, alpha );

        if ( n == 0 )
        {
          for ( i = 0; i < order; i++ )
          {
            f[i] = 1.0;
          }
        }
        else
        {
          for ( i = 0; i < order; i++ )
          {
            f[i] = std::pow ( x[i], n );
          }
        }
        estimate = 0.0;
        for ( i = 0; i < order; i++ )
        {
          estimate = estimate + w[i] * f[i];
        }

        error = webbur::r8_abs ( exact - estimate );
  
        std::cout << "  " << std::setw(8)  << order
             << "  " << std::setw(8)  << n
             << "  " << std::setprecision(6) << std::setw(14) << alpha
             << "  " << std::setprecision(6) << std::setw(14) << estimate
             << "  " << std::setprecision(6) << std::setw(14) << exact
             << "  " << std::setprecision(6) << std::setw(14) << error << "\n";
      }
      delete [] f;
      delete [] w;
      delete [] x;
    }
  }
 
  return;
# undef TEST_NUM
}
//****************************************************************************80

void test14 ( )

//****************************************************************************80
//
//  Purpose:
//
//    TEST14 tests GEN_LAGUERRE_COMPUTE.
//
//  Licensing:
//
//    This code is distributed under the GNU LGPL license. 
//
//  Modified:
//
//    19 March 2009
//
//  Author:
//
//    John Burkardt
//
{
# define TEST_NUM 3

  double alpha;
  double alpha_test[TEST_NUM] = { 0.5, 1.0, 2.5 };
  double beta = 0.0;
  int i;
  int order;
  int order_max = 10;
  int test;
  double *w;
  double *x;

  std::cout << "\n";
  std::cout << "TEST14\n";
  std::cout << "  GEN_LAGUERRE_COMPUTE computes a generalized Gauss-Laguerre rule\n";
  std::cout << "  which is appropriate for integrands of the form\n";
  std::cout << "    Integral ( 0 <= x < +oo ) f(x) x^alpha exp(-x) dx.\n";

  for ( test = 0; test < TEST_NUM; test++ )
  {
    alpha = alpha_test[test];

    for ( order = 1; order <= order_max; order++ )
    {
      std::cout << "\n";
      std::cout << "  Order = " << order << "\n";
      std::cout << "  ALPHA = " << alpha << "\n";

      w = new double[order];
      x = new double[order];

      webbur::gen_laguerre_compute ( order, alpha, beta, x, w );
 
      for ( i = 0; i < order; i =i + 1 )
      {
        std::cout << "  " << std::setw(8) << i
             << "  " << std::setprecision(16) << std::setw(24) << x[i]
             << "  " << std::setprecision(16) << std::setw(24) << w[i] << "\n";
      }
      delete [] w;
      delete [] x;
    }
  }
 
  return;
# undef TEST_NUM
}
//****************************************************************************80

void test15 ( )

//****************************************************************************80
//
//  Purpose:
//
//    TEST15 tests HERMITE_COMPUTE against HERMITE_INTEGRAL.
//
//  Licensing:
//
//    This code is distributed under the GNU LGPL license. 
//
//  Modified:
//
//    19 March 2009
//
//  Author:
//
//    John Burkardt
//
{
  double alpha = 0.0;
  double beta = 0.0;
  double error;
  double estimate;
  double exact;
  double *f;
  int i;
  int n;
  int order;
  int order_max = 10;
  double *w;
  double *x;

  std::cout << "\n";
  std::cout << "TEST15\n";
  std::cout << "  HERMITE_COMPUTE computes a Gauss-Hermite rule\n";
  std::cout << "  which is appropriate for integrands of the form\n";
  std::cout << "    Integral ( -oo < x < +oo ) f(x) exp(-x*x) dx.\n";
  std::cout << "\n";
  std::cout << "  HERMITE_INTEGRAL determines the exact value of\n";
  std::cout << "  this integal when f(x) = x^n.\n";
  std::cout << "\n";
  std::cout << "  A rule of order ORDER should be exact for monomials X^N\n";
  std::cout << "  up to N = 2*ORDER-1\n";
  std::cout << "\n";
  std::cout << "  In the following table, for each order, the LAST THREE estimates\n";
  std::cout << "  are made on monomials that exceed the exactness limit for the rule.\n";
  std::cout << "\n";
  std::cout << "     Order         N       Estimate       Exact            Error\n";

  for ( order = 1; order <= order_max; order++ )
  {
    std::cout << "\n";

    f = new double[order];
    w = new double[order];
    x = new double[order];

    webbur::hermite_compute ( order, alpha, beta, x, w );

    for ( n = 0; n <= 2 * order + 2; n = n + 1 )
    {
      exact = webbur::hermite_integral ( n );
 
      if ( n == 0 )
      {
        for ( i = 0; i < order; i++ )
        {
          f[i] = 1.0;
        }
      }
      else
      {
        for ( i = 0; i < order; i++ )
        {
          f[i] = std::pow ( x[i], n );
        }
      }
      estimate = 0.0;
      for ( i = 0; i < order; i++ )
      {
        estimate = estimate + w[i] * f[i];
      }

      error = webbur::r8_abs ( exact - estimate );
  
      std::cout << "  " << std::setw(8)  << order
           << "  " << std::setw(8)  << n
           << "  " << std::setprecision(6) << std::setw(14) << estimate
           << "  " << std::setprecision(6) << std::setw(14) << exact
           << "  " << std::setprecision(6) << std::setw(14) << error << "\n";
    }
    delete [] f;
    delete [] w;
    delete [] x;
  }
 
  return;
}
//****************************************************************************80

void test16 ( )

//****************************************************************************80
//
//  Purpose:
//
//    TEST16 tests HERMITE_COMPUTE.
//
//  Licensing:
//
//    This code is distributed under the GNU LGPL license. 
//
//  Modified:
//
//    19 March 2009
//
//  Author:
//
//    John Burkardt
//
{
  double alpha = 0.0;
  double beta = 0.0;
  int i;
  int order;
  int order_max = 10;
  int test;
  double *w;
  double *x;

  std::cout << "\n";
  std::cout << "TEST16\n";
  std::cout << "  HERMITE_COMPUTE computes a Gauss-Hermite rule\n";
  std::cout << "  which is appropriate for integrands of the form\n";
  std::cout << "    Integral ( -oo < x < +oo ) f(x) exp(-x*x) dx.\n";

  for ( order = 1; order <= order_max; order++ )
  {
    std::cout << "\n";
    std::cout << "  Order = " << order << "\n";

    w = new double[order];
    x = new double[order];

    webbur::hermite_compute ( order, alpha, beta, x, w );
 
    for ( i = 0; i < order; i =i + 1 )
    {
      std::cout << "  " << std::setw(8) << i
           << "  " << std::setprecision(16) << std::setw(24) << x[i]
           << "  " << std::setprecision(16) << std::setw(24) << w[i] << "\n";
    }
    delete [] w;
    delete [] x;
  }
 
  return;
}
//****************************************************************************80

void test17 ( )

//****************************************************************************80
//
//  Purpose:
//
//    TEST17 tests JACOBI_COMPUTE against JACOBI_INTEGRAL.
//
//  Licensing:
//
//    This code is distributed under the GNU LGPL license. 
//
//  Modified:
//
//    26 February 2008
//
//  Author:
//
//    John Burkardt
//
{
# define TEST_NUM 3

  double alpha;
  double alpha_test[TEST_NUM] = { 0.5, 1.0, 2.5 };
  double beta;
  double beta_test[TEST_NUM] = { 0.5, 1.0, 2.5 };
  double error;
  double estimate;
  double exact;
  double *f;
  int i;
  int n;
  int order;
  int order_max = 10;
  int test1;
  int test2;
  double *w;
  double *x;

  std::cout << "\n";
  std::cout << "TEST17\n";
  std::cout << "  JACOBI_COMPUTE computes a Gauss-Jacobi rule\n";
  std::cout << "  which is appropriate for integrands of the form\n";
  std::cout << "    Integral ( -1 <= x <= +1 ) f(x) (1-x)^alpha (1+x)^beta dx.\n";
  std::cout << "\n";
  std::cout << "  JACOBI_INTEGRAL determines the exact value of\n";
  std::cout << "  this integal when f(x) = x^n.\n";
  std::cout << "\n";
  std::cout << "  A rule of order ORDER should be exact for monomials X^N\n";
  std::cout << "  up to N = 2*ORDER-1\n";
  std::cout << "\n";
  std::cout << "  In the following table, for each order, the LAST THREE estimates\n";
  std::cout << "  are made on monomials that exceed the exactness limit for the rule.\n";
  std::cout << "\n";
  std::cout << "     Order         N       Alpha           Beta            Estimate       Exact            Error\n";

  for ( test1 = 0; test1 < TEST_NUM; test1++ )
  {
    alpha = alpha_test[test1];

    for ( test2 = 0; test2 < TEST_NUM; test2++ )
    {
      beta = beta_test[test2];

      for ( order = 1; order <= order_max; order++ )
      {
        std::cout << "\n";

        f = new double[order];
        w = new double[order];
        x = new double[order];

        webbur::jacobi_compute ( order, alpha, beta, x, w );

        for ( n = 0; n <= 2 * order + 2; n = n + 1 )
        {
          exact = webbur::jacobi_integral ( n, alpha, beta );
 
          if ( n == 0 )
          {
            for ( i = 0; i < order; i++ )
            {
              f[i] = 1.0;
            }
          }
          else
          {
            for ( i = 0; i < order; i++ )
            {
              f[i] = std::pow ( x[i], n );
            }
          }
          estimate = 0.0;
          for ( i = 0; i < order; i++ )
          {
            estimate = estimate + w[i] * f[i];
          }
 
          error = webbur::r8_abs ( exact - estimate );
  
          std::cout << "  " << std::setw(8)  << order
               << "  " << std::setw(8)  << n
               << "  " << std::setprecision(6) << std::setw(14) << alpha
               << "  " << std::setprecision(6) << std::setw(14) << beta
               << "  " << std::setprecision(6) << std::setw(14) << estimate
               << "  " << std::setprecision(6) << std::setw(14) << exact
               << "  " << std::setprecision(6) << std::setw(14) << error << "\n";
        }
        delete [] f;
        delete [] w;
        delete [] x;
      }
    }
  }
  return;
# undef TEST_NUM
}
//****************************************************************************80

void test18 ( )

//****************************************************************************80
//
//  Purpose:
//
//    TEST18 tests JACOBI_COMPUTE.
//
//  Licensing:
//
//    This code is distributed under the GNU LGPL license. 
//
//  Modified:
//
//    26 February 2008
//
//  Author:
//
//    John Burkardt
//
{
# define TEST_NUM 3

  double alpha;
  double alpha_test[TEST_NUM] = { 0.5, 1.0, 2.5 };
  double beta;
  double beta_test[TEST_NUM] = { 0.5, 1.0, 2.5 };
  int i;
  int order;
  int order_max = 10;
  int test1;
  int test2;
  double *w;
  double *x;

  std::cout << "\n";
  std::cout << "TEST18\n";
  std::cout << "  JACOBI_COMPUTE computes a Gauss-Jacobi rule\n";
  std::cout << "  which is appropriate for integrands of the form\n";
  std::cout << "    Integral ( -1 <= x <= +1 ) f(x) (1-x)^alpha (1+x)^beta dx.\n";

  for ( test1 = 0; test1 < TEST_NUM; test1++ )
  {
    alpha = alpha_test[test1];

    for ( test2 = 0; test2 < TEST_NUM; test2++ )
    {
      beta = beta_test[test2];

      for ( order = 1; order <= order_max; order++ )
      {
        std::cout << "\n";
        std::cout << "  Order = " << order << "\n";
        std::cout << "  ALPHA = " << alpha << "\n";
        std::cout << "  BETA = "  << beta << "\n";

        w = new double[order];
        x = new double[order];

        webbur::jacobi_compute ( order, alpha, beta, x, w );

        for ( i = 0; i < order; i =i + 1 )
        {
          std::cout << "  " << std::setw(8) << i
               << "  " << std::setprecision(16) << std::setw(24) << x[i]
               << "  " << std::setprecision(16) << std::setw(24) << w[i] << "\n";
        }
        delete [] w;
        delete [] x;
      }
    }
  }
  return;
# undef TEST_NUM
}
//****************************************************************************80

void test19 ( )

//****************************************************************************80
//
//  Purpose:
//
//    TEST19 tests LAGUERRE_COMPUTE against LAGUERRE_INTEGRAL.
//
//  Licensing:
//
//    This code is distributed under the GNU LGPL license. 
//
//  Modified:
//
//    19 March 2009
//
//  Author:
//
//    John Burkardt
//
{
  double alpha = 0.0;
  double beta = 0.0;
  double error;
  double estimate;
  double exact;
  double *f;
  int i;
  int n;
  int order;
  int order_max = 10;
  double *w;
  double *x;

  std::cout << "\n";
  std::cout << "TEST19\n";
  std::cout << "  LAGUERRE_COMPUTE computes a Gauss-Laguerre rule\n";
  std::cout << "  which is appropriate for integrands of the form\n";
  std::cout << "    Integral ( 0 <= x < +oo ) f(x) exp(-x) dx.\n";
  std::cout << "\n";
  std::cout << "  LAGUERRE_INTEGRAL determines the exact value of\n";
  std::cout << "  this integal when f(x) = x^n.\n";
  std::cout << "\n";
  std::cout << "  A rule of order ORDER should be exact for monomials X^N\n";
  std::cout << "  up to N = 2*ORDER-1\n";
  std::cout << "\n";
  std::cout << "  In the following table, for each order, the LAST THREE estimates\n";
  std::cout << "  are made on monomials that exceed the exactness limit for the rule.\n";
  std::cout << "\n";
  std::cout << "     Order         N       Estimate       Exact            Error\n";

  for ( order = 1; order <= order_max; order++ )
  {
    std::cout << "\n";

    f = new double[order];
    w = new double[order];
    x = new double[order];

    webbur::laguerre_compute ( order, alpha, beta, x, w );

    for ( n = 0; n <= 2 * order + 2; n = n + 1 )
    {
      exact = webbur::laguerre_integral ( n );

      if ( n == 0 )
      {
        for ( i = 0; i < order; i++ )
        {
          f[i] = 1.0;
        }
      }
      else
      {
        for ( i = 0; i < order; i++ )
        {
          f[i] = std::pow ( x[i], n );
        }
      }
      estimate = 0.0;
      for ( i = 0; i < order; i++ )
      {
        estimate = estimate + w[i] * f[i];
      }

      error = webbur::r8_abs ( exact - estimate );
  
      std::cout << "  " << std::setw(8)  << order
           << "  " << std::setw(8)  << n
           << "  " << std::setprecision(6) << std::setw(14) << estimate
           << "  " << std::setprecision(6) << std::setw(14) << exact
           << "  " << std::setprecision(6) << std::setw(14) << error << "\n";
    }
    delete [] f;
    delete [] w;
    delete [] x;
  }
  return;
}
//****************************************************************************80

void test20 ( )

//****************************************************************************80
//
//  Purpose:
//
//    TEST20 tests LAGUERRE_COMPUTE.
//
//  Licensing:
//
//    This code is distributed under the GNU LGPL license. 
//
//  Modified:
//
//    19 March 2009
//
//  Author:
//
//    John Burkardt
//
{
  double alpha = 0.0;
  double beta = 0.0;
  int i;
  int order;
  int order_max = 10;
  double *w;
  double *x;

  std::cout << "\n";
  std::cout << "TEST20\n";
  std::cout << "  LAGUERRE_COMPUTE computes a generalized Gauss-Laguerre rule\n";
  std::cout << "  which is appropriate for integrands of the form\n";
  std::cout << "    Integral ( 0 <= x < +oo ) f(x) exp(-x) dx.\n";

  for ( order = 1; order <= order_max; order++ )
  {
    std::cout << "\n";
    std::cout << "  Order = " << order << "\n";

    w = new double[order];
    x = new double[order];

    webbur::laguerre_compute ( order, alpha, beta, x, w );
 
    for ( i = 0; i < order; i =i + 1 )
    {
      std::cout << "  " << std::setw(8) << i
           << "  " << std::setprecision(16) << std::setw(24) << x[i]
           << "  " << std::setprecision(16) << std::setw(24) << w[i] << "\n";
    }
    delete [] w;
    delete [] x;
  }
 
  return;
}
//****************************************************************************80

void test21 ( )

//****************************************************************************80
//
//  Purpose:
//
//    TEST21 tests LEGENDRE_COMPUTE against LEGENDRE_INTEGRAL.
//
//  Licensing:
//
//    This code is distributed under the GNU LGPL license. 
//
//  Modified:
//
//    19 March 2009
//
//  Author:
//
//    John Burkardt
//
{
  double alpha = 0.0;
  double beta = 0.0;
  double error;
  double estimate;
  double exact;
  double *f;
  int i;
  int n;
  int order;
  int order_max = 10;
  double *w;
  double *x;

  std::cout << "\n";
  std::cout << "TEST21\n";
  std::cout << "  LEGENDRE_COMPUTE computes a Gauss-Legendre rule\n";
  std::cout << "  which is appropriate for integrands of the form\n";
  std::cout << "    Integral ( -1 <= x <= +1 ) f(x)  dx.\n";
  std::cout << "\n";
  std::cout << "  LEGENDRE_INTEGRAL determines the exact value of\n";
  std::cout << "  this integal when f(x) = x^n.\n";
  std::cout << "\n";
  std::cout << "  A rule of order ORDER should be exact for monomials X^N\n";
  std::cout << "  up to N = 2*ORDER-1\n";
  std::cout << "\n";
  std::cout << "  In the following table, for each order, the LAST THREE estimates\n";
  std::cout << "  are made on monomials that exceed the exactness limit for the rule.\n";
  std::cout << "\n";
  std::cout << "     Order         N       Estimate       Exact            Error\n";

  for ( order = 1; order <= order_max; order++ )
  {
    std::cout << "\n";

    f = new double[order];
    w = new double[order];
    x = new double[order];

    webbur::legendre_compute ( order, alpha, beta, x, w );

    for ( n = 0; n <= 2 * order + 2; n = n + 1 )
    {
      exact = webbur::legendre_integral ( n );

      if ( n == 0 )
      {
        for ( i = 0; i < order; i++ )
        {
          f[i] = 1.0;
        }
      }
      else
      {
        for ( i = 0; i < order; i++ )
        {
          f[i] = std::pow ( x[i], n );
        }
      }
      estimate = 0.0;
      for ( i = 0; i < order; i++ )
      {
        estimate = estimate + w[i] * f[i];
      }

      error = webbur::r8_abs ( exact - estimate );
  
      std::cout << "  " << std::setw(8)  << order
           << "  " << std::setw(8)  << n
           << "  " << std::setprecision(6) << std::setw(14) << estimate
           << "  " << std::setprecision(6) << std::setw(14) << exact
           << "  " << std::setprecision(6) << std::setw(14) << error << "\n";
    }
    delete [] f;
    delete [] w;
    delete [] x;
  }
  return;
}
//****************************************************************************80

void test22 ( )

//****************************************************************************80
//
//  Purpose:
//
//    TEST22 tests LEGENDRE_COMPUTE.
//
//  Licensing:
//
//    This code is distributed under the GNU LGPL license. 
//
//  Modified:
//
//    19 March 2009
//
//  Author:
//
//    John Burkardt
//
{
  double alpha = 0.0;
  double beta = 0.0;
  int i;
  int order;
  int order_max = 10;
  int test;
  double *w;
  double *x;

  std::cout << "\n";
  std::cout << "TEST22\n";
  std::cout << "  LEGENDRE_COMPUTE computes a Gauss-Legendre rule\n";
  std::cout << "  which is appropriate for integrands of the form\n";
  std::cout << "    Integral ( -1 <= x <= +1 ) f(x) dx.\n";

  for ( order = 1; order <= order_max; order++ )
  {
    std::cout << "\n";
    std::cout << "  Order = " << order << "\n";

    w = new double[order];
    x = new double[order];

    webbur::legendre_compute ( order, alpha, beta, x, w );
 
    for ( i = 0; i < order; i =i + 1 )
    {
      std::cout << "  " << std::setw(8) << i
           << "  " << std::setprecision(16) << std::setw(24) << x[i]
           << "  " << std::setprecision(16) << std::setw(24) << w[i] << "\n";
    }
    delete [] w;
    delete [] x;
  }
 
  return;
}
