C***********************************************************************
C LHS (Latin Hypercube Sampling) UNIX Library/Standalone. 
C Copyright (c) 2004, Sandia Corporation.  Under the terms of Contract
C DE-AC04-94AL85000 with Sandia Corporation, the U.S. Government
C retains certain rights in this software.
C
C This software is distributed under the GNU General Public License.
C For more information, see the README file in the LHS directory. 
C***********************************************************************
C     Last change:  SLD  29 May 101   10:25 am
C
C      COMMON /CHAR1/ TITLE
Cc      CHARACTER TITLE*LENT
C      CHARACTER (len = LENT) TITLE
C      Character*(NamLen) List
C      Character*60 TreeFl, SFile, MFile, CmdLin
C      COMMON /PARAM/ ISEED, N, NV, IRS, ICM, NREP, IDATA, IHIST,
C     1               ICORR, IDIST(NVAR), IRP, IV1, IRSET,
C     2               List(NVar), IVarNm(NVar), PValue(NVar),
C     3               NamOut, IPtVal, TreeFl, SFile, MFile, CmdLin
C
c===============================================================
C
      MODULE CPARAM
C
C       Here are the elements from the old common block
C
cc      PARMS provides NVAR,LENT,NamLen                                 sld01
        USE PARMS
C
        IMPLICIT DOUBLE PRECISION (A-H,O-Z)
        CHARACTER (LEN = LENT) TITLE
        CHARACTER (LEN = 256) :: TreeFl, SFile, MFile, CmdLin
cc        INTEGER :: ISEED, N, NV, IRS, ICM, NREP, IDATA, IHIST         SLD
cc        INTEGER :: ICORR                                              SLD
        INTEGER :: ISEED, N, NV, IRS, ICM, NREP, IDATA, IHIST, ICORR    SLD
ccc     Added variables for second random number routine                SLD
        INTEGER :: ISEEDSV, JSEED                                       SLD
ccc
        INTEGER, ALLOCATABLE :: IDIST(:)
        INTEGER :: IRP, IV1, IRSET
        Character*(NamLen), ALLOCATABLE :: List (:)
        INTEGER, ALLOCATABLE :: IVarNm(:)
        DOUBLE PRECISION, ALLOCATABLE :: PValue(:)
        INTEGER NamOut, I1Col, IPtVal
C
C       Now here is the initialization routine for this module
      CONTAINS
C
      SUBROUTINE CPARAM_INIT()
C
        USE PARMS
C
        ALLOCATE( IDIST(NVAR) )
        IDIST = 0 
C
        ALLOCATE( IVarNm(NVAR) )
        IVarNm = 0
C
        ALLOCATE( PValue(NVar) )
        PValue = 0.0
C
        ALLOCATE( List(NVar) ) 
        List = " "
C
        RETURN
C
      END SUBROUTINE
C
      SUBROUTINE CPARAM_CLOSE()
C
        DEALLOCATE( IDIST )
C
        DEALLOCATE( IVarNm )
C
        DEALLOCATE( PValue )
C
        DEALLOCATE( List )
C
        RETURN
C
      END SUBROUTINE
C
      END MODULE
