//@HEADER
// ************************************************************************
// 
//         HOPSPACK: Hybrid Opitmization Parallel Search Package
//               Copyright (2008) Sandia Corporation
// 
// Under terms of Contract DE-AC04-94AL85000, there is a non-exclusive
// license for use of this work by or on behalf of the U.S. Government.
// 
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation; either version 2.1 of the
// License, or (at your option) any later version.
//  
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//                                                                                 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.                                                                           .
// 
// Questions? Contact Tammy Kolda (tgkolda@sandia.gov) 
// 
// ************************************************************************
//@HEADER

/*!
  \file APPSPACK_Citizen_Generator.cpp
  \brief Implements APPSPACK::Citizen_Generator

  \todo Josh Comment parameters.
*/

#include "APPSPACK_Citizen_Generator.hpp"
#include "APPSPACK_Citizen_GSS.hpp"
#include "APPSPACK_Citizen_LHS.hpp"
#include "APPSPACK_Citizen_TGP.hpp"
#include "APPSPACK_Citizen_DIRECT.hpp"
#include "APPSPACK_Citizen_DIRECTserial.hpp"
#include "APPSPACK_Citizen_Random.hpp"
#include "APPSPACK_Citizen_NAPPSPACK.hpp"
#include "APPSPACK_Citizen_Listener.hpp"
#include "APPSPACK_Citizen_NAPPSListener.hpp"
#include "APPSPACK_Citizen_Interface.hpp"

APPSPACK::Citizen::Generator::Generator()
{
}

APPSPACK::Citizen::Generator::~Generator()
{  
}

APPSPACK::Citizen::Interface* 
APPSPACK::Citizen::Generator::newCitizenType(APPSPACK::Parameter::List& params,
                                             APPSPACK::Constraints::Linear& linear,
                                             APPSPACK::Combiner::Generic& combiner,
                                             const string& type, const string& name,
                                             const vector<int>& workerRank)
{  
  Citizen::Interface* ci;
  if (type == "GSS")
  {
    ci = new Citizen::GSS(params, linear, combiner, name);
  }
  else if (type == "LHS")
  {
    ci = new Citizen::LHS(params, linear, combiner, name);
  }
  else if (type == "TGP")
  {
    if (workerRank.size()!=1)
    {
      cerr << "TGP Citizen designed to use only one processor." << endl;
      throw "APPSPACK Error";
    }
    ci = new Citizen::TGP(params, linear, combiner, 
			  workerRank[0], name);
  }  
  else if (type == "DIRECT")
  {
    if (workerRank.size()!=1)
    {
      cerr << "DIRECT Citizen designed to use only one processor." << endl;
      throw "APPSPACK Error";
    }
    ci = new Citizen::DIRECT(params, linear, combiner, 
			  workerRank[0], name);
  }
  else if (type == "Random")
  {
    ci = new Citizen::Random(params, linear, combiner, name);
  }
  else if (type == "DIRECTserial")
  {
    ci = new Citizen::DIRECTserial(params, linear, combiner, name);
  }
  else if (type == "NAPPSPACK")
  {
    ci = new Citizen::NAPPSPACK(params, linear, combiner, name);
  }  
  else if (type == "Listener")
  {
    ci = new Citizen::Listener(params, linear, combiner, name);
  }  
  else if (type == "NAPPSListener")
  {
    ci = new Citizen::NAPPSListener(params, linear, combiner, name);
  }  
  else
  {
    cerr << "Unsupported type given" << endl;
    throw "APPSPACK Error";
  }

  return ci;
}
