#!/bin/bash
#
# Template for a wrapper executable to LHS sampling
#
# Taddy, March 07
#
# T.G.Kolda, May 08 - Incorporated justLHS.R directly 
# into this code.
#
###############################################################

export PATH=$PATH:$R_PATH

# 1 = bounds, e.g. looks like "c(dim1min,dim1max),c(dim2min,dim2max), ... ,c(dimPmin,dimPmax)"
# 2 = outfile name.
# 3 = number of samples.
# 4 = tag.

databounds=$1
ofile=$2
nsamples=$3
tag=$4

# Switch to working directory to avoid possible file clobber.
if [ -e workdir_lhs.$tag ]; then
  rm -r workdir_lhs.$tag
fi
mkdir workdir_lhs.$tag
cd workdir_lhs.$tag

#date > CALL_BEGIN

args=$args" ncand <- $nsamples;"
args=$args" ofile <- \"$ofile\";"
args=$args" Xrect <- cbind($databounds); " 

line_a="library(tgp)"
line_b="XX <- lhs(ncand, Xrect)"
line_c="o <- c(1:ncand)"
line_d="write.table(XX[o,],file=ofile, row.names=FALSE, col.names=FALSE);"

# Call the tgp emulator
echo $args$'\n'$line_a$'\n'$line_b$'\n'$line_c$'\n'$line_d | R --no-save >> tgp.log

cp $ofile ../$ofile.$tag
cd ..
rm -r workdir_lhs.$tag

#date > CALL_COMPLETE







