#!/usr/bin/ruby

## Test problem list.
problems = %w{bra sh5 sh7 sh10 ha3 ha6 gol ca6 shu};
sizes = [2, 4, 4, 4, 3, 6, 2, 2, 2];

## Create combinations of solvers
##        0      1        2
list = ["l", "g", "d"];
combos = [[1], [2], [1,2], [0,1,2]];
priorities = ["3 1", "3 1", "3 1 1", "3 1 1 1"];

## Create run names
runs = ["r1", "r2", "r3", "r4", "r5"];

## Create global output directory
outdir = "outdir";
Dir.mkdir(outdir) unless File.directory?(outdir);

## Loop through each run --- creating a separate script file and directory to run in
runs.each { |run|

  Dir.mkdir(run) unless File.directory?(run);

  ## Create script file
  sout = File.open("script_" + run,"w");
  sout.puts "\#! /bin/bash";
  sout.puts "\#PBS -l nodes=3:ppn=2:compute";
  sout.puts "\#PBS -l walltime=02:00:00";
  #sout.puts "\#PBS -A 42005/01.03.03";
  sout.puts "\#PBS -A 100959/01";
  sout.puts "cd " + run;

  pidx = 0; 
  problems.each { |prob|
  
    # extract the problem size
    size = sizes[pidx];
    pidx += 1;

    cidx = 0;
    combos.each { |comb|

      # extract the corresponding priorities
      prio = priorities[cidx];
      cidx += 1;

      # number of citizens
      ncitizens = comb.length + 1;

      # combination name
      combname = outdir + "/" + run + "_" + prob + "_";
      comb.each { |ci|
        combname = combname + list[ci];
      }

      # Output to screen
      puts combname
    
      # HOPS file
      out = File.open(combname + ".hops", "w");

      # Update combname to go up one directory
      combname = "../" + combname;

      # Create mediator section of APPS file
      out.puts "@ \"Mediator\"";
      out.puts "\"Debug\" int 4";
      out.puts "\"Cache Comparison Tolerance\" double 1e-11";
      out.puts "\"Percent Error\" double 0.01";
      out.puts "\"Cache Output File\" string \"" + combname + ".cache\"";
      out.puts "\"Citizen Count\" int " + ncitizens.to_s;
      out.puts "\"Priority Level\" vector " + ncitizens.to_s + " " + prio;
      out.puts "\"Maximum Evaluations\" int 3000";
      out.puts "@@\n\n";

      # Create Listener Citizen
      out.puts "@ \"Citizen 1\"";
      out.puts "\"Type\" string \"Listener\"";
      out.puts "\"Results File\" string \"" + combname + ".listener\"";
      out.puts "@@\n\n";

      # Create citizens from combination
      count = 2;
      comb.each{ |ci|
      
        # Output section header and increment count
        out.puts "@ \"Citizen " + count.to_s + "\"";
        count = count + 1;

        case list[ci]

          when "l"
  	  out.puts "\"Type\" string \"LHS\"";
  	  out.puts "\"Executable Name\" string \"lhs.sh\";
  	  out.puts "\"Sample Size\" int 50";
  	  out.puts "\"LHS File\" string \"LHS.txt\"";
  	  #out.puts "\"Default Step\" double 1.0";

          when "d"
  	  out.puts "\"Type\" string \"DIRECT\"";
  	  out.puts "\"Processors\" int 1";
  	  out.puts "\"Max Evaluations\" int 10000";
  	  out.puts "\"Max Iterations\" int 100";
  	  out.puts "\"Epsilon\" double 1e-2";

          when "g"
  	  out.puts "\"Type\" string \"GSS\"";
  	  out.puts "\"Debug\" int 3";
  	  out.puts "\"Initial Step\" double 1.0";
	  out.puts "\"Step Tolerance\" double 1e-4";
	  out.puts "\"Use Random Order\" bool true";

        end
        out.puts "@@\n\n"
    }

      # Copy problem-specific information    
      IO.foreach("blocks/" + prob + "-block.apps"){|line| out.puts line}

      # Append script
      sout.puts "mpirun -n 5 hopspack_mpi " + combname + ".hops > " + combname + ".out";

    }
  }

}
