import os
import re
import sys
import string



def recursive_delete(path,deleteRoot=True):
    if os.path.exists(path):
       #
       # Recursively remove files and directories
       #
       for root, dirs, files in os.walk(path, topdown=False):
         for name in files:
           os.remove(os.path.join(root,name))
         for name in dirs:
           os.rmdir(os.path.join(root,name))
       if deleteRoot:
          os.rmdir(path)


def isint(x):
  try:
    int(x)
    return True
  except ValueError:
    return False


def quote_split(re_str, str):
  mylist = []
  chars = []
  state = 1
  for token in re.split(re_str,str):
    prev = " "
    for character in token:
      if character == "\"" and prev != "\\":
         if state == 1:
            chars = chars + [ "\"" ]
            state = 2
         else:
            state = 1
            chars = chars + [ "\"" ]
      else:
         chars = chars + [ character ]
         prev = character
    if state == 1:
       if len(chars) > 0:
          mylist = mylist + [ string.join(chars,"") ]
          chars = []
    else:
       chars = chars + [ " " ]
  if state == 2:
     raise ValueError, "ERROR: unterminated quotation found in quote_split()"

  return mylist


def mean(mylist):
  total = 1.0*sum(mylist)
  length = len(mylist)
  if length == 0.0:
     raise ArithmeticError, "ERROR: attempting to compute the mean of a zero-length list."
  return (total/length)

def median(mylist):
  mylist.sort()
  if (len(mylist) == 0):
     return -1
  elif (len(mylist) == 1):
     return mylist[0]
  elif (divmod(len(mylist),2)[1] == 1):
     return mylist[(len(mylist)-1)/2]
  ndx = len(mylist)/2
  return (mylist[ndx-1]+mylist[ndx])/2



#
# Adapted from code developed by Andres Tuells and submitted to
# the ActiveState Programmer Network http://aspn.activestate.com
#
class Factory(object):
    def __init__(self):
	self.Keys = []
	self.constructors = {}

    def register(self, methodName, constructor, *args, **kargs):
        """register a constructor"""
	self.Keys = self.Keys + [methodName]
        _args = [constructor]
        _args.extend(args)
        mname = "construct_" + methodName
	self.constructors[methodName] = apply(Functor,_args, kargs)
        setattr(self, methodName,apply(Functor,_args, kargs))
        
    def construct(self,name):
	method = self.constructors[name]
	return method()

    def unregister(self, methodName):
        """unregister a constructor"""
        delattr(self, methodName)

    def keys(self):
	return self.Keys

    def __len__(self):
	return len(self.Keys)

    def __iter__(self):
	return self.Keys.__iter__()

    def __getitem__(self,index):
	return self.Keys[index]


#
# Adapted from code developed by Andres Tuells and submitted to
# the ActiveState Programmer Network http://aspn.activestate.com
#
class Functor:
    def __init__(self, function, *args, **kargs):
        assert callable(function), "function should be a callable obj"
        self._function = function
        self._args = args
        self._kargs = kargs
        
    def __call__(self, *args, **kargs):
        """call function"""
        _args = list(self._args)
        _args.extend(args)
        _kargs = self._kargs.copy()
        _kargs.update(kargs)
        return apply(self._function,_args,_kargs)

#
# A class that can be used to store a bunch of data dynamically
#
# foo = Bunch(data=y, sq=y*y, val=2)
# print foo.data
# print foo.sq
# print foo.val
#
# Adapted from code developed by Alex Martelli and submitted to
# the ActiveState Programmer Network http://aspn.activestate.com
#
class Bunch(dict):
    def __init__(self, **kw):
	dict.__init__(self,kw)
	self.__dict__.update(kw)


#
# Add a method to a class:
#
# self   - the object that is modified
# method - a function
# name   - a string that describes the new method name
#
# Adapted from code submitted by Moshe Zadka to the 
# ActiveState Programmer Network http://aspn.activestate.com
#
def add_method(self, method, name=None):
	if name is None:
	   name = method.__name__
	class new(self.__class__): pass
	setattr(new, name, method)
	self.__class__ = new
	return getattr(self,name)

#
# Add a method to a class given a function class
#
# self        - the object that is modified
# method_name - the name of a function
# name        - a string that describes the new method name
#
# Adapted from code submitted by Moshe Zadka to the 
# ActiveState Programmer Network http://aspn.activestate.com
#
def add_method_by_name(self, method_name, name=None):
	add_method(self, eval(method_name), name)


def flatten_dict(mydict):
        """
        A function that takes a dictionary and flattens it into a tuple in
        a uniform manner: keys are sorted, and the tuple consists of
        key-value pairs in order.
        """
        keys = mydict.keys()
        keys.sort()
        ans = ()
        for key in keys:
          ans += (key,)
          ans += (mydict[key],)
        return ans
