/* This is third-party software that is distributed with Acro.
 * For licensing information concerning this file, see the Acro home page:
 * http://software.sandia.gov/Acro
 */

///////////////////////////////////////////////////////////////////
/*****************************************************************
Copyright: Artificial Life and Adaptive Robotics Laboratory - ALAR
School of ITEE, UNSW@ADFA, Australia, 2005
*******************************************************************/
///////////////////////////////////////////////////////////////////

#if !defined(_NSGA2)
#define _NSGA2

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "population.h"
#include "Random.h"
#include "objective.h"

class operators_NSGA2  
{
public:
	void Evolve(int population_size, int N_generation, int SEED, int n_Genes,int n_Objs,int *GSize,double *Ub,double *Lb);
	void combination(population &R, population &Q,population &P);
	void set_objectivevalue(individual &id,double *real_params);
	void initialize_population(const int n_Genes,int n_Objs,int *GSize,double *Ub,double *Lb,population &pop);
	static void copyarray(unsigned int *&d,unsigned int *s,int size);
	void set_objectivevalue_maxmin(population &p, int size);
	void crowding_sort(population &F, int sort);
	
	void mutation(population &pop);
	void crossover(population &pop);
	void selection(population &q,population &p);  // crowded selection
	operators_NSGA2() {
	    pc=1;
	    pm=0;
	    max_values=NULL;
	    min_values=NULL;
	};
	operators_NSGA2(double _pc,double _pm,int ObjID) {
	    pc=_pc;
	    pm=_pm;
	    objID=ObjID;
	    max_values=NULL;
	    min_values=NULL;
	};
	virtual ~operators_NSGA2();

	population newpop;  // temp;
	population P;     // parrent population: size N
	population Q;     // offspring population: size N
	population R;    // size 2*N
	population F;         // sub population 


//private:
	int n_SEED,n_GEN;
	objective *obj;
	Random rnd;   //random generator
	double pc;
	double pm;
	double *min_values;
	double *max_values;
	//int lastrun;
	double dev;
	int objID;
};

#endif // !defined(_NSGA2)
