/*  _________________________________________________________________________
 *
 *  Coliny: A Library of COLIN optimizers
 *  Copyright (c) 2003, Sandia National Laboratories.
 *  This software is distributed under the GNU Lesser General Public License.
 *  For more information, see the README.html file in the top Coliny directory.
 *  _________________________________________________________________________
 */

//
// A C interface to an EAgeneric class
//

#include <acro_config.h>
#include <utilib/BasicArray.h>
#include <coliny/DomainOpsBase.h>
#include <coliny/DomainInfoBase.h>
#include <coliny/EAgeneric.h>
#include <coliny/c_EAgeneric.h>

using namespace std;
using namespace utilib;

namespace local {

//typedef colin::AppResponse_Utilib::realarray_t realarray_t;

class Container
{
public:

  Container() : obj(0) {}
  Container& operator=(const Container& item)
	{ obj = item.obj; return *this; }
  EAgenericUserType obj;
  bool operator==(const Container& pt) const
	{return c_EAgeneric_point_equal(obj,pt.obj);}
  void eval(colin::real& val, utilib::BasicArray<colin::real>& cval) const
	{
	double tmp;
        if (num_constraints == 0)
	   c_EAgeneric_evaluate_point(obj,tmp,&tmp);
        else
	   c_EAgeneric_evaluate_point(obj,tmp,cvec.data());
	val = tmp;
	for (int i=0; i<num_constraints; i++)
          cval[i] = cvec[i];
	}

  static int num_constraints;
  static utilib::BasicArray<double> cvec;
};

int Container::num_constraints = 0;
utilib::BasicArray<double> Container::cvec;

void testfunc(const Container& x, colin::real& val, utilib::BasicArray<colin::real>& cval)
{
x.eval(val,cval);
}

PackBuffer& operator<<(PackBuffer& os, const Container& pt)
{ return os; }

UnPackBuffer& operator>>(UnPackBuffer& is, Container& pt)
{ return is; }


ostream& operator<<(ostream& os, const Container& pt)
{
os.flush();
c_EAgeneric_write_point(pt.obj);
return os;
}

istream& operator>>(istream& is, Container& pt)
{ return is; }


Container& operator<<(Container& to, const Container& from)
{
c_EAgeneric_copy_point(from.obj,to.obj);
return to;
}


typedef coliny::DomainInfoBase DomainInfo;

class DomainOps  : public utilib::ParameterSet, public utilib::CommonIO
{
public:

  DomainOps() {}

  void reset() { c_EAgeneric_init_operators(); }

  void write(ostream& os) const {}

  void initialize(
  		colin::OptProblem<Container,colin::AppResponse_Utilib>& problem,
		unsigned int popsize, Container& best_pt, double xover_rate, double m_rate) {}

  template <class A, class B>
  bool check_domain(A&,B&) {return false;}

  void read_point(istream& is, Container& point, unsigned int&) {}

  /// Randomize the point
  void randomize(Container& point, DomainInfo& info)
	{ c_EAgeneric_randomize_point(point.obj); }

  /// Allocate the memory for this point
  void initialize_point(Container& point, DomainInfo& info)
	{ c_EAgeneric_initialize_point(point.obj); }

  int apply_xover(Container& parent1, DomainInfo& info1,
		  Container& parent2, DomainInfo& info2,
		  Container& child,   DomainInfo& info_c)
        { return c_EAgeneric_xover(parent1.obj, parent2.obj, child.obj); }

  bool apply_mutation(Container& point, DomainInfo& info, int parent_ndx)
        {
	int tmp=-1;
	c_EAgeneric_mutation(point.obj, &parent_ndx, &tmp);
	return (tmp == 0 ? false : true);
	}

  void set_rng(utilib::AnyRNG& rng_) {}

};


class ColinyHandle
{
public:
  ColinyHandle() : setup_problem(false) {}
  bool setup_problem;
  coliny::EAgeneric<Container,DomainInfo,DomainOps> solver;
  colin::OptProblem<Container,colin::AppResponse_Utilib> problem;
};

typedef ColinyHandle coliny_handle_t;
}




EAgenericObjectType c_EAgeneric_allocate()
{
local::ColinyHandle* tmp = new local::ColinyHandle;
return static_cast<EAgenericObjectType>(tmp);
}



void c_EAgeneric_deallocate(EAgenericObjectType& obj_)
{
local::coliny_handle_t* obj = static_cast<local::coliny_handle_t*>(obj_);
if (obj) {
   delete obj;
   obj_ = 0;
   }
}


void c_EAgeneric_set_parameter(EAgenericObjectType obj_, 
				char* name, char* value)
{
local::coliny_handle_t* obj = static_cast<local::coliny_handle_t*>(obj_);
if (obj) {
   obj->solver.set_parameter_with_string(name,value);
   }
}


void c_EAgeneric_reset(EAgenericObjectType obj_)
{
local::coliny_handle_t* obj = static_cast<local::coliny_handle_t*>(obj_);
if (obj) {
   if (!(obj->setup_problem)) {
      obj->setup_problem = true;
      c_EAgeneric_init_problem(local::Container::num_constraints);
      utilib::pvector<double> clower(local::Container::num_constraints);
      utilib::pvector<double> cupper(local::Container::num_constraints);
      c_EAgeneric_init_constraints(&(clower[0]),&(cupper[0]));
#if !defined(COUGAR) && !defined(TFLOPS)
      OptSetup(obj->problem,&local::testfunc,local::Container::num_constraints);
#else
      EXCEPTION_MNGR(runtime_error, "OptSetup usage is not supported.");
#endif
      obj->problem.set_constraint_bounds(clower,cupper);
      obj->solver.set_problem(obj->problem);
      local::Container::cvec.resize(local::Container::num_constraints);
      }
   obj->solver.reset();
   }
}



void c_EAgeneric_minimize(EAgenericObjectType obj_)
{
local::coliny_handle_t* obj = static_cast<local::coliny_handle_t*>(obj_);
if (obj)
   obj->solver.minimize();
}


void c_EAgeneric_get_best_point(EAgenericObjectType obj_,
				EAgenericUserType pt)
{
local::coliny_handle_t* obj = static_cast<local::coliny_handle_t*>(obj_);
if (obj) {
   pt = obj->solver.best().point.obj;
   }
}


void c_EAgeneric_get_value_of_best_point(EAgenericObjectType obj_,
				double* value)
{
local::coliny_handle_t* obj = static_cast<local::coliny_handle_t*>(obj_);
if (obj) {
   *value = obj->solver.best().value();
   }
}
