/*  _________________________________________________________________________
 *
 *  COLIN: A Common Optimization Library INterface
 *  Copyright (c) 2003, Sandia National Laboratories.
 *  This software is distributed under the GNU Lesser General Public License.
 *  For more information, see the README.html file in the top COLIN directory.
 *  _________________________________________________________________________
 */

//
// test gradient call
//

#include <acro_config.h>
#include <utilib/std_headers.h>
#include <colin/colin.h>

using namespace std;
using namespace colin;


void func(const utilib::pvector<double>& x, AppResponse<>& response)
{
double val = x[0];
for (unsigned int i=1; i<x.size(); i++)
  if (val > x[i]) val = x[i];

response.function_value() = val;
}


double fn(const double* x, int n)
{
double val = x[0];
for (int i=1; i<n; i++)
  if (val > x[i]) val = x[i];

return val;
}


void foo()
{
OptProblem<utilib::pvector<double> > opt;
OptSetup(opt,&func);
OptSetup(opt,&fn);
utilib::pvector<double> a;
#ifdef ACRO_HAVE_TEMPLATES_AS_TEMPLATE_ARGUMENTS
utilib::pvector<real > g;
#else
utilib::BasicArray<real > g;
#endif
real value;
opt.EvalF(a,value);
opt.EvalG(a,g);
}

int main()
{ return 0;}
