/*  _________________________________________________________________________
 *
 *  COLIN: A Common Optimization Library INterface
 *  Copyright (c) 2003, Sandia National Laboratories.
 *  This software is distributed under the GNU Lesser General Public License.
 *  For more information, see the README.html file in the top COLIN directory.
 *  _________________________________________________________________________
 */

//
// OptSolver test
//

#include <acro_config.h>
#include <colin/colin.h>

using namespace colin;
using namespace std;

OptSolver<vector<double> >* opt;


double func(vector<double>& vec)
{
double val;
for (unsigned int i=0; i<vec.size(); i++)
  val = (i+1)*vec[i];
return val;
}

class TestOptSolver : public OptSolver<vector<double> >
{
public:

  void minimize();

  void set_initial_point(vector<double>& pt)
		{curr = pt;}

protected:

  void initialize_best_point() {this->opt_response().point.resize(problem.num_real_params());}

  vector<double> curr;
};


void TestOptSolver::minimize()
{
real tmp;
problem.EvalF(curr, tmp);
opt_response().value() = tmp;

int j=0;
while (opt_response().value() > accuracy) {
  for (unsigned int i=0; i<curr.size(); i++)
    curr[i] -= 0.0001;
  problem.EvalF(curr,tmp);
  opt_response().value() = tmp;
  cout << j << " " << opt_response().value() << " " << curr << endl;
  j++;
  }

opt_response().point = curr;
}



int main()
{
OptProblem<vector<double> > prob;
OptSetup(prob,func,"[-10.0,10.0]^3");

TestOptSolver opt;

vector<double> point(4);
point << 10.0;

opt.set_initial_point(point);
opt.set_problem(prob);
opt.set_parameter("accuracy",29.0);

opt.reset();
opt.minimize();

return 0;
}
