/*  _________________________________________________________________________
 *
 *  COLIN: A Common Optimization Library INterface
 *  Copyright (c) 2003, Sandia National Laboratories.
 *  This software is distributed under the GNU Lesser General Public License.
 *  For more information, see the README.html file in the top COLIN directory.
 *  _________________________________________________________________________
 */


#include <acro_config.h>
#include <colin/OptPointDB.h>

using namespace std;

void exit_fn() {}

int main()
{
utilib::exception_mngr::set_mode(utilib::exception_mngr::Abort);
utilib::exception_mngr::set_exit_function(&exit_fn);

colin::db::OptPointDB<utilib::BasicArray<double> > foo;

utilib::BasicArray<double> tmp(3);
for (size_type i=0; i<tmp.size(); i++)
  tmp[i] = i+1.0;

for (unsigned int k=0; k<40; k++) {
  for (size_type i=0; i<tmp.size(); i++)
    tmp[i] /= 10.0;
  colin::real tval = k;
  foo.add(tmp, tval, 1);
  }

foo.write(std::cout);

return 0;
}
