/*  _________________________________________________________________________
 *
 *  COLIN: A Common Optimization Library INterface
 *  Copyright (c) 2003, Sandia National Laboratories.
 *  This software is distributed under the GNU Lesser General Public License.
 *  For more information, see the README.html file in the top COLIN directory.
 *  _________________________________________________________________________
 */

//
// Colin.cpp
//

#include <acro_config.h>
#ifdef ACRO_HAVE_MPI
#include <mpi.h>
#endif
#include <colin/ColinGlobals.h>

#if defined(USING_PROBE)
void probe() {}
#endif

namespace colin {

int ColinGlobals::write_precision = 10;

char* ColinGlobals::output_level = "normal";

//
// TODO - a more general model for processor id's?  (PVM/MPI/??)
//
int ColinGlobals::processor_id()
{
#ifdef ACRO_HAVE_MPI

int local_mpi;
MPI_Initialized(&local_mpi);
if (!local_mpi)
   return 0;

int rank;
MPI_Comm_rank(MPI_COMM_WORLD,&rank);
return rank;

#else

return 0;

#endif
}

};

