/*  _________________________________________________________________________
 *
 *  COLIN: A Common Optimization Library INterface
 *  Copyright (c) 2003, Sandia National Laboratories.
 *  This software is distributed under the GNU Lesser General Public License.
 *  For more information, see the README.html file in the top COLIN directory.
 *  _________________________________________________________________________
 */

/**
 * \file DirectSimpleApplication.h
 *
 * Defines colin::DirectSimpleApplication.
 */

#ifndef colin_DirectSimpleApplication_h
#define colin_DirectSimpleApplication_h

#include <acro_config.h>
#include <colin/DirectApplicationBase.h>

namespace colin {

/** \class DirectSimpleApplication
  * This subclass of \c DirectApplicationBase specializes the functionality in
  * that class for the case where the domain is an array and for which the
  * user function is passed in as a pointer to the data in the array.  We
  * assume, however, that the class ArrayT is used in the C++ code (since
  * this provides a nice degree of encapsulation).
  */
#if defined(ACRO_HAVE_TEMPLATES_AS_TEMPLATE_ARGUMENTS) && !defined(DOXYGEN)

template <class ParamT,  template <class T> class ArrayT, class ResponseT, class FuncT>
class DirectSimpleApplication : public DirectApplicationBase<ArrayT<ParamT>,ResponseT,FuncT>
{
public:

  /// Generic constructor.
  DirectSimpleApplication(int app_mode_, FuncT fn) 
	: DirectApplicationBase<ArrayT<ParamT>,ResponseT,FuncT>(app_mode_,fn) {}

  ///
  void EvalFn(ArrayT<ParamT>& point, ResponseT& response)
	{
	double val = (*(this->eval_fn))(&(point[0]), point.size());
	response.function_value() = val;
   	response.request_vector()[0] &= mode_f;
   	response.response_vector()[0] |= mode_f;
	}
		
};

#else

template <class DomainT, class ResponseT, class FuncT>
class DirectSimpleApplication : public DirectApplicationBase<DomainT,ResponseT,FuncT>
{
public:

  /// Generic constructor.
  DirectSimpleApplication(int app_mode_, FuncT fn) 
	: DirectApplicationBase<DomainT,ResponseT,FuncT>(app_mode_,fn) {}

  ///
  void EvalFn(DomainT& point, ResponseT& response)
	{
	double val = (*(this->eval_fn))(&(point[0]), point.size());
	response.function_value() = val;
   	response.request_vector()[0] &= mode_f;
   	response.response_vector()[0] |= mode_f;
	}
		
};

#endif

}

#endif
