/*  _________________________________________________________________________
 *
 *  COLIN: A Common Optimization Library INterface
 *  Copyright (c) 2003, Sandia National Laboratories.
 *  This software is distributed under the GNU Lesser General Public License.
 *  For more information, see the README.html file in the top COLIN directory.
 *  _________________________________________________________________________
 */

/**
 * \file ColinGlobals.h
 *
 * Defines the colin::ColinGlobals class.
 */

#ifndef colin_ColinGlobals_h
#define colin_ColinGlobals_h

#include <acro_config.h>

namespace colin {


/// This class defines static data that is "global" for all of the COLIN
/// data structures.  For example, the processor ID (for parallel applications)
/// and precision used to write real values.
class ColinGlobals
{
public:

  /// The precision used to write real values.
  static int write_precision;

  /// A string indicating the verbosity of output.
  static char* output_level;

  /// The processor ID within MPI_COMM_WORLD.
  static int processor_id();
};

}

#endif
