/*
================================================================================
    PROJECT:

        John Eddy's Genetic Algorithms (JEGA)

    CONTENTS:

        Implementation of class SimpleFunctorEvaluatorCreator.

    NOTES:

        See notes of SimpleFunctorEvaluatorCreator.hpp.

    PROGRAMMERS:

        John Eddy (jpeddy@sandia.gov) (JE)

    ORGANIZATION:

        Sandia National Laboratories

    COPYRIGHT:

        See the LICENSE file in the top level JEGA directory.

    VERSION:

        2.1.0

    CHANGES:

        Wed Oct 18 15:58:41 2006 - Original Version (JE)

================================================================================
*/




/*
================================================================================
Document This File
================================================================================
*/
/** \file
 * \brief Contains the implementation of the SimpleFunctorEvaluatorCreator
 *        class.
 */




/*
================================================================================
Includes
================================================================================
*/
// JEGAConfig.hpp should be the first include in all JEGA files.
#include <../Utilities/include/JEGAConfig.hpp>

#include <utilities/include/EDDY_DebugScope.hpp>
#include <../FrontEnd/Core/include/SimpleFunctorEvaluatorCreator.hpp>







/*
================================================================================
Namespace Using Directives
================================================================================
*/
using namespace JEGA::Algorithms;







/*
================================================================================
Begin Namespace
================================================================================
*/
namespace JEGA {
    namespace FrontEnd {





/*
================================================================================
Static Member Data Definitions
================================================================================
*/








/*
================================================================================
Mutators
================================================================================
*/








/*
================================================================================
Accessors
================================================================================
*/








/*
================================================================================
Public Methods
================================================================================
*/








/*
================================================================================
Subclass Visible Methods
================================================================================
*/








/*
================================================================================
Subclass Overridable Methods
================================================================================
*/
GeneticAlgorithmEvaluator*
SimpleFunctorEvaluatorCreator::CreateEvaluator(
    GeneticAlgorithm& algorithm
    )
{
    EDDY_FUNC_DEBUGSCOPE
    return new SimpleFunctorEvaluator(algorithm, _theFunc);
}








/*
================================================================================
Private Methods
================================================================================
*/








/*
================================================================================
Structors
================================================================================
*/

SimpleFunctorEvaluatorCreator::SimpleFunctorEvaluatorCreator(
    SimpleFunctorEvaluator::Functor* theFunc
    ) :
        _theFunc(theFunc)
{
    EDDY_FUNC_DEBUGSCOPE
}
    







/*
================================================================================
End Namespace
================================================================================
*/
    } // namespace FrontEnd
} // namespace JEGA

