*   _______________________________________________________________________
*
*   DAKOTA: Design Analysis Kit for Optimization and Terascale Applications
*   Copyright (c) 2006, Sandia National Laboratories.
*   This software is distributed under the GNU General Public License.
*   For more information, see the README file in the top Dakota directory.
*   _______________________________________________________________________
*
c    This code was written to detect rebound (completion of an impact event)
c    from a Kinetic Energy history.  Since KE(t) does not decrease monotonically,
c    rebound is detected when KE has increased from its current minimum value an
c    amount equal to 1% of the initial KE (the initial KE is needed as a reference
c    since %change of something near zero is poorly behaved).
c
c    The input data containing the raw data is in a neutral file written from 
c    BLOT (xmgr.neu). 
c
c    Adapted from fildata.f by Mike Eldred for use in the DAKOTA system, 4/19/95.
c
      character*72 line
      character*13 text
      real         time, ke, kemax, kemin, rebnd, detect
c
      open(unit=11,file='xmgr.neu')
c
c **** Read 17 header lines ****
      do 10 i=1,17
         read(11,100)line
c         write(*,*) 'line ',i,': ',line
 10   continue
c
c **** Read first record for max KE (for use in rebound magnitude tolerance) ****
      read( 11, 110, err=999, end=999 ) time, kemax
c
c **** Read data until error at first end text line ****
      do 20 i = 2, 500000
c
         read( 11, 110, err=999, end=999 ) time, ke
c
         if(( time .lt. 0.0 ).OR.( ke .lt. 0.0 )) then
           write(*,*)'ERROR - Problem with reading raw data'
           write(*,*)'ERROR - time = ', time,'  ke = ',ke
           stop
         endif
c
c         write(*,*) 'record ', i, ': ', time, ke
c
 20   continue
c
 999  do 25 i=2, 3
c **** read 2nd and 3rd end text lines ****
         read(11,100)line
c         write(*,*) 'end text line ', i,': ', line
 25   continue
c
c **** read final end text line for minimum KE value ****
      read(11, 120) text, kemin
c
c      rebnd=(ke-kemin)/kemin*100.0 [this causes unpredictable detection for kemin near 0]
      rebnd=ke-kemin
      detect=.01*kemax
c23456789012345678901234567890123456789012345678901234567890123456789012
      write(*,*) 'KEmax, KEmin, last KE:', kemax, kemin, ke
      write(*,*) 'Rebound magnitude, detection magnitude (.01*KEmax):',
     +            rebnd, detect
c
      if (rebnd .ge. detect) then
         write(*,*) 'Rebound captured.  Analysis may be terminated.'
      else
         write(*,*) 'Rebound not yet captured.  Continue analysis.'
      endif
c
 100  format(a72)
 110  format(e14.11,e18.11)
 120  format(a13,e14.11)
c
      stop 
      end
