#!/bin/csh 
source /etc/profile.d/00-modules.csh
source /etc/profile.d/01-module-loader.csh

# NOTES
#   on NWCC, DAKOTA 4.2 is built with the following modules (currently default):
#     compilers/intel-9.1-f040-c045
#     mpi/openmpi-1.2.2_mx_intel-9.1-f040-c045
#     libraries/intel-mklA (aka libraries/intel-mkl-9.1.018)
#
#   At the current time, these are the same modules loaded for nightly testing.
#   If production DAKOTA and nightly testing diverge to different compilers, libraries, 
#   or MPI versions, it should be documented here for correct nightly build/test.

setenv PATH "${PATH}:/usr/bin"

# Run nightly test on NWCC from a script so we can change modules if necessary
# (currently default modules are acceptable)
 
/usr/kerberos/bin/kinit -k -t ${HOME}/dakota.keytab dakota

echo "My environment on spirit"
env

echo "...add module for torque"
module load system/torque-2.1.8

module list
echo " "
echo "PATH= $PATH"
echo " "


/projects/dakota/Dakota/test/sqa/run_base_test.csh /projects/dakota/nightly/builds votd >>& ${HOME}/cronlogs/${SNLCLUSTER}/run_base_test
