#!/bin/csh -f
#
# This is the package test script for dakota subpackages.  It loops through
# the given package names and executes basic configure/make on those
# packages.

# Note : To run different configures for each package, more logic needs to
# be added to the script.
#
# Usage: run_package_test.csh root_directory
#
# The script can be started at the command line or by using the cron

# --- external variables used ---
# $1     root directory for builds ($TEST_ROOT)
# $UNAME output of uname (environment.csh)
# -------------------------------

echo "Running $0 on `uname -n` at `date`"

# set up the shell variables (local) and environment variables (global)
# move to environment.csh where possible
setenv DAKOTA_ROOT $1
setenv TEST_SQA  $DAKOTA_ROOT/Dakota/test/sqa
source $TEST_SQA/environment.csh
setenv TEST_DIR_FQ $DAKOTA_ROOT/$TEST_DIR

# checkout packages
$TEST_SQA/checkout_script.csh $TEST_DIR_FQ/packages packages checkout

# autoreconf, configure, build, and test each package
foreach package ( `cat $TEST_SQA/package-list-test` )
  set a = `echo $package | awk -F^ '{print $NF}' | awk -F- '{print $1}'`
  if ( $a == 'acro' ) then
    # Acro manages it's own nightly tests
    cd $TEST_DIR_FQ/packages/acro-th
    ./run_fast >&! fast.out
  else
    # set filenames
    set coutput = "config_$a.out"
    set cerror  = "config_$a.err"
    set moutput = "make_$a.out"
    set merror  = "make_$a.err"
    set toutput = "test_$a.out"
    # run configure in package directory
    cd $TEST_DIR_FQ/packages/$a
    \rm -f $coutput $cerror $moutput $merror
    autoreconf --install --verbose # using autotools to build configure
    if ( $a == 'Surfpack' ) then
      configure --with-cppunit-prefix=/usr/netpub/cppunit >& $coutput
    else
      configure >& $coutput
    endif
    $TEST_SQA/grep_error.perl $coutput
    # run make in package directory
    make -k clean
    gmake -j $BUILD_JOBS -k >& $moutput
    $TEST_SQA/grep_error.perl $moutput
    # execute package tests
    gmake -j $BUILD_JOBS -k check >& $toutput
  endif
end
