#!/bin/csh -f
#
# a crude script for killing runaway nightly DAKOTA tests before the next build
# and making sure cronlog directory is setup
echo "Running $0 on `uname -n` at `date`"

setenv UNAME `uname`
setenv DELAY 2

# take two passes through the kills
foreach attempt ( 1 2 )
  echo "Kill attempt $attempt"  
  if ( $UNAME == 'AIX' ) then
    poekill dakota
    sleep $DELAY
    ps -u dakota | grep 'dakota' | awk '{print $2}' | xargs kill -9
    sleep $DELAY
    ps -u dakota | grep 'poe' | awk '{print $2}' | xargs kill -9

  else if ( $UNAME == 'Darwin' ) then
    ps -U dakota | grep 'dakota' | awk '{print $1}' | xargs kill -9

  else if ( $UNAME == 'IRIX64' ) then
    ps -u 50935 | grep 'dakota' | awk '{print $1}' | xargs kill -9
    sleep $DELAY
    ps -u 50935 | grep 'mpirun' | awk '{print $1}' | xargs kill -9

  else if ( $UNAME == 'Linux' ) then
    pgrep -l -u dakota | grep dakota | awk '{print $1}' | xargs kill -9
    sleep $DELAY
    pgrep -l -u dakota | grep mpirun | awk '{print $1}' | xargs kill -9

  else if ( $UNAME == 'SunOS' ) then
    pgrep -l -u dakota | grep dakota | awk '{print $1}' | xargs kill -9
    sleep $DELAY
    pgrep -l -u dakota | grep mprun | awk '{print $1}' | xargs kill -9

  endif
  sleep $DELAY
end
