/*  _______________________________________________________________________

    DAKOTA: Design Analysis Kit for Optimization and Terascale Applications
    Copyright (c) 2006, Sandia National Laboratories.
    This software is distributed under the GNU General Public License.
    For more information, see the README file in the top Dakota directory.
    _______________________________________________________________________ */

//- This include file defines which templates to use as base classes.
//- At one time, templates from RogueWave tools.h++ were used.  Currently, the
//- Standard Template Library (STL) is used exclusively.  Eventually, STL will
//- be used for bookkeeping types and Teuchos will be used for numerical types.

#ifndef DAKOTA_TEMPLATE_DEFS_H
#define DAKOTA_TEMPLATE_DEFS_H

#ifdef HAVE_CONFIG_H
#include "dakota_config.h"
#endif

#ifdef HAVE_ALGORITHM
#include <algorithm>
#endif
#ifdef HAVE_LIMITS
#include <limits>
#endif
#include <vector>
#include <deque>
#include <list>
#include <string>
#include <map>
#include <set>
#include <iterator>


namespace Dakota {

/// special value returned by index() when entry not found
const size_t _NPOS = ~(size_t)0; // one's complement

// still some issues with valarray (works on Sun and DEC but not SGI and linux).
// Could use platform ifdef's for use of valarray, but this is not warranted
// since: (1) derived template member function definitions are much simpler
// using vector for the numerical type, and (2) Teuchos template types will be
// used once they become available.

// #define used because typedef will not work for templates with no
// specialization type

// the following macros define base classes used for deriving Dakota::Vector,
// Dakota::Matrix, Dakota::Array, Dakota::List, and Dakota::String.  In this
// model, the Dakota types specialize the base types in order to provide a
// consistent API and/or add functionality.
#define DAKOTA_BASE_VECTOR std::vector
#define DAKOTA_BASE_ARRAY  std::vector
#define DAKOTA_BASE_LIST   std::list
#define DAKOTA_BASE_STRING std::string
//#define DAKOTA_BASE_SET    std::set
//#define DAKOTA_BASE_MAP    std::map
// the following macros provide a thin Dakota wrapper without derivation.
// In this case, the base data types are used as is.
//#define Set                std::set
//#define Map                std::map

// Old definitions for pre-ANSI DAKOTA were based on Rogue Wave Tools.h++
//#include <rw/tvvector.h>
//#include <rw/tvslist.h>
//#include <rw/cstring.h>
//#define DAKOTA_BASE_VECTOR RWTValVector
//#define DAKOTA_BASE_ARRAY  RWTValVector
//#define DAKOTA_BASE_LIST   RWTValSlist
//#define DAKOTA_BASE_STRING RWCString

} // namespace Dakota

#endif // DAKOTA_TEMPLATE_DEFS_H
