/*  _______________________________________________________________________

    DAKOTA: Design Analysis Kit for Optimization and Terascale Applications
    Copyright (c) 2006, Sandia National Laboratories.
    This software is distributed under the GNU General Public License.
    For more information, see the README file in the top Dakota directory.
    _______________________________________________________________________ */

//- Class:       DistinctVariables
//- Description: Container class of variables, employing the "distinct" 
//-              approach to variables usage.
//- Owner:       Mike Eldred
//- Version: $Id: DistinctVariables.H 5793 2009-03-31 03:15:00Z mseldre $

#ifndef DISTINCT_VARS_H
#define DISTINCT_VARS_H

#include "DakotaVariables.H"
#include "DataVariables.H"


namespace Dakota {

/// Derived class within the Variables hierarchy which employs
/// the default data view (no variable or domain type array merging).

/** Derived variables classes take different views of the design,
    uncertain, and state variable types and the continuous and
    discrete domain types.  The DistinctVariables derived class
    separates the design, uncertain, and state variable types as well
    as the continuous and discrete domain types.  The result is
    separate arrays for continuous design, discrete design, uncertain,
    continuous state, and discrete state variables.  This is the
    default approach, so all iterators and strategies not specifically
    utilizing the All or Merged views use this approach (see
    Variables::get_variables(problem_db)). */

class DistinctVariables: public Variables
{
public:

  //
  //- Heading: Constructors and destructor
  //

  /// default constructor
  DistinctVariables();
  /// standard constructor
  DistinctVariables(const ProblemDescDB& problem_db,
		    const pair<short,short>& view);
  /// destructor
  ~DistinctVariables();

  //
  //- Heading: Virtual function redefinitions
  //

  void read(istream& s);
  void write(ostream& s) const;
  void write_aprepro(ostream& s) const;

  void read_annotated(istream& s);
  void write_annotated(ostream& s) const;

  void write_tabular(ostream& s) const;

  void read(BiStream& s);
  void write(BoStream& s) const;

  void read(MPIUnpackBuffer& s);
  void write(MPIPackBuffer& s) const;

protected:

  void copy_rep(const Variables* vars_rep);
  void reshape_rep(const Sizet2DArray& vars_comps);

  void build_active_views();
  void build_inactive_views();

private:

  //
  //- Heading: Private member functions
  //
};


inline DistinctVariables::DistinctVariables()
{ }


inline DistinctVariables::~DistinctVariables()
{ }


inline void DistinctVariables::copy_rep(const Variables* vars_rep)
{ build_views(); }

} // namespace Dakota

#endif
